/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.traits;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.traits.DispatchCase;
import com.flipkart.krystal.traits.PredicateDispatchPolicy;
import com.flipkart.krystal.vajramexecutor.krystex.VajramGraph;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PredicateDispatchPolicyImpl
extends PredicateDispatchPolicy {
    private final VajramID traitID;
    private final ImmutableList<DispatchCase> dispatchCases;
    private final ImmutableSet<VajramID> dispatchTargetIDs;
    private final ImmutableSet<Class<? extends Request<?>>> dispatchTargetReqs;
    private final @NonNull VajramGraph graph;

    public PredicateDispatchPolicyImpl(Class<? extends Request<?>> traitReqType, ImmutableList<DispatchCase> traitDispatchCases, VajramGraph graph) {
        this.graph = graph;
        this.traitID = graph.getVajramIdByVajramReqType(traitReqType);
        this.dispatchCases = traitDispatchCases;
        this.dispatchTargetReqs = (ImmutableSet)this.dispatchCases.stream().map(DispatchCase::dispatchTargets).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        this.dispatchTargetIDs = (ImmutableSet)this.dispatchTargetReqs.stream().map(graph::getVajramIdByVajramReqType).collect(ImmutableSet.toImmutableSet());
    }

    protected VajramID getVajramIdByVajramReqType(Class<? extends Request<?>> reqType) {
        return this.graph.getVajramIdByVajramReqType(reqType);
    }

    protected void validateDispatchTarget(VajramID dispatchTargetID) {
    }

    @Generated
    public VajramID traitID() {
        return this.traitID;
    }

    @Generated
    public ImmutableList<DispatchCase> dispatchCases() {
        return this.dispatchCases;
    }

    @Generated
    public ImmutableSet<VajramID> dispatchTargetIDs() {
        return this.dispatchTargetIDs;
    }

    @Generated
    public ImmutableSet<Class<? extends Request<?>>> dispatchTargetReqs() {
        return this.dispatchTargetReqs;
    }
}

