/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.traits;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.traits.ComputeDispatchPolicy;
import com.flipkart.krystal.vajramexecutor.krystex.VajramGraph;
import com.flipkart.krystal.vajramexecutor.krystex.traits.DispatchTargetComputing;
import com.google.common.collect.ImmutableSet;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ComputeDispatchPolicyImpl<T extends Request<?>>
extends ComputeDispatchPolicy {
    private final VajramGraph graph;
    private final Class<T> traitReqType;
    private final VajramID traitID;
    private final ImmutableSet<VajramID> dispatchTargetIDs;
    private final ImmutableSet<Class<? extends T>> dispatchTargetReqs;
    private final DispatchTargetComputing.DispatchTargetComputer<T> dispatchTargetComputer;

    public ComputeDispatchPolicyImpl(Class<T> traitReqType, DispatchTargetComputing.DispatchTargetComputer<T> dispatchTargetComputer, ImmutableSet<Class<? extends T>> dispatchTargetReqs, VajramGraph graph) {
        this.traitReqType = traitReqType;
        this.graph = graph;
        this.traitID = graph.getVajramIdByVajramReqType(traitReqType);
        this.dispatchTargetComputer = dispatchTargetComputer;
        this.dispatchTargetReqs = dispatchTargetReqs;
        this.dispatchTargetIDs = (ImmutableSet)dispatchTargetReqs.stream().map(graph::getVajramIdByVajramReqType).collect(ImmutableSet.toImmutableSet());
    }

    public @Nullable VajramID getDispatchTargetID(@Nullable Dependency dependency, Request<?> request) {
        Class dispatchTargetReqClass;
        VajramID vajramID;
        @Nullable Object dispatchTarget = this.dispatchTargetComputer.computeDispatchTarget(dependency, request);
        if (dispatchTarget == null) {
            return null;
        }
        if (dispatchTarget instanceof VajramID) {
            vajramID = (VajramID)dispatchTarget;
            dispatchTargetReqClass = this.graph.getVajramReqByVajramId(vajramID).orElse(null);
        } else if (dispatchTarget instanceof Class) {
            dispatchTargetReqClass = (Class)dispatchTarget;
            vajramID = this.graph.getVajramIdByVajramReqType(dispatchTargetReqClass);
        } else {
            throw new AssertionError((Object)"Dispatch target will be either a VajramID or a Class<? extends Request<?>>. This is a bug in platform code");
        }
        if (dispatchTargetReqClass == null) {
            throw new IllegalArgumentException("Could not find request type for vajram Id: " + String.valueOf(vajramID) + ". Please check if the vajram has been loaded into the vajram graph");
        }
        if (!this.traitReqType.isAssignableFrom(dispatchTargetReqClass)) {
            throw new IllegalArgumentException("Dispatch target id: " + String.valueOf(vajramID) + " does not implement the trait " + String.valueOf(this.traitID) + ". Please check your dispatch policy logic.");
        }
        return vajramID;
    }

    public ImmutableSet<Class<? extends Request<?>>> dispatchTargetReqs() {
        return ImmutableSet.copyOf(this.dispatchTargetReqs);
    }

    @Generated
    public VajramID traitID() {
        return this.traitID;
    }

    @Generated
    public ImmutableSet<VajramID> dispatchTargetIDs() {
        return this.dispatchTargetIDs;
    }
}

