/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.inputinjection;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.ErrableFacetValue;
import com.flipkart.krystal.data.ExecutionItem;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FacetValuesBuilder;
import com.flipkart.krystal.data.Failure;
import com.flipkart.krystal.except.KrystalCompletionException;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.krystex.commands.DirectForwardReceive;
import com.flipkart.krystal.krystex.commands.ForwardReceiveBatch;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonCommandResponse;
import com.flipkart.krystal.krystex.kryon.VajramKryonDefinition;
import com.flipkart.krystal.krystex.request.InvocationId;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.facets.specs.DefaultFacetSpec;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajram.inputinjection.VajramInjectionProvider;
import com.flipkart.krystal.vajramexecutor.krystex.VajramGraph;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InjectingDecoratedKryon
implements Kryon<KryonCommand<? extends KryonCommandResponse>, KryonCommandResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InjectingDecoratedKryon.class);
    private final Kryon<KryonCommand<? extends KryonCommandResponse>, KryonCommandResponse> kryon;
    private final VajramGraph vajramGraph;
    private final @Nullable VajramInjectionProvider injectionProvider;

    InjectingDecoratedKryon(Kryon<KryonCommand<? extends KryonCommandResponse>, KryonCommandResponse> kryon, VajramGraph vajramGraph, @Nullable VajramInjectionProvider injectionProvider) {
        this.kryon = kryon;
        this.vajramGraph = vajramGraph;
        this.injectionProvider = injectionProvider;
    }

    public VajramKryonDefinition getKryonDefinition() {
        return this.kryon.getKryonDefinition();
    }

    public CompletableFuture<KryonCommandResponse> executeCommand(KryonCommand<? extends KryonCommandResponse> kryonCommand) {
        VajramDefinition vajramDefinition = this.vajramGraph.getVajramDefinition(VajramID.vajramID((String)kryonCommand.vajramID().id()));
        if (vajramDefinition.metadata().isInputInjectionNeeded() && vajramDefinition.def() instanceof VajramDef) {
            if (kryonCommand instanceof ForwardReceiveBatch) {
                ForwardReceiveBatch forwardBatch = (ForwardReceiveBatch)kryonCommand;
                return this.injectFacets(forwardBatch, vajramDefinition);
            }
            if (kryonCommand instanceof DirectForwardReceive) {
                DirectForwardReceive forwardReceive = (DirectForwardReceive)kryonCommand;
                return this.injectFacets(forwardReceive, vajramDefinition);
            }
        }
        return this.kryon.executeCommand(kryonCommand);
    }

    private CompletableFuture<KryonCommandResponse> injectFacets(DirectForwardReceive forwardReceive, VajramDefinition vajramDefinition) {
        LinkedHashSet injectableFacets = new LinkedHashSet();
        vajramDefinition.facetSpecs().forEach(facetSpec -> {
            if (FacetType.INJECTION.equals((Object)facetSpec.facetType())) {
                injectableFacets.add((FacetSpec<?, ?>)facetSpec);
            }
        });
        for (ExecutionItem executionItem : forwardReceive.executionItems()) {
            FacetValuesBuilder facetsBuilder = executionItem.facetValues();
            List<AutoCloseable> closeables = this.injectFacetsOfVajram(vajramDefinition, injectableFacets, facetsBuilder);
            executionItem.response().whenComplete((o, throwable) -> {
                for (AutoCloseable closeable : closeables) {
                    try {
                        closeable.close();
                    }
                    catch (Exception e) {
                        log.error("Failed to close injected closeable", (Throwable)e);
                    }
                }
            });
        }
        return this.kryon.executeCommand((KryonCommand)forwardReceive);
    }

    private CompletableFuture<KryonCommandResponse> injectFacets(ForwardReceiveBatch forwardBatch, VajramDefinition vajramDefinition) {
        Map requestIdToFacets = forwardBatch.executableInvocations();
        ImmutableMap.Builder newRequests = ImmutableMap.builder();
        LinkedHashSet injectableFacets = new LinkedHashSet();
        vajramDefinition.facetSpecs().forEach(facetSpec -> {
            if (FacetType.INJECTION.equals((Object)facetSpec.facetType())) {
                injectableFacets.add((FacetSpec<?, ?>)facetSpec);
            }
        });
        for (Map.Entry entry : requestIdToFacets.entrySet()) {
            InvocationId invocationId = (InvocationId)entry.getKey();
            FacetValuesBuilder facetsBuilder = ((FacetValues)entry.getValue())._asBuilder();
            this.injectFacetsOfVajram(vajramDefinition, injectableFacets, facetsBuilder);
            newRequests.put((Object)invocationId, (Object)facetsBuilder);
        }
        ForwardReceiveBatch kryonCommand = new ForwardReceiveBatch(forwardBatch.vajramID(), (Map)newRequests.build(), forwardBatch.dependentChain(), forwardBatch.invocationsToSkip());
        CompletableFuture resp = this.kryon.executeCommand((KryonCommand)kryonCommand);
        resp.whenComplete((kryonCommandResponse, throwable) -> {});
        return resp;
    }

    private List<AutoCloseable> injectFacetsOfVajram(VajramDefinition vajramDefinition, Set<FacetSpec<?, ?>> injectableFacets, FacetValuesBuilder facetsBuilder) {
        ArrayList<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
        for (FacetSpec<?, ?> facetSpec : injectableFacets) {
            Errable value;
            DefaultFacetSpec defaultFacetSpec;
            Errable facetValue;
            if (!(facetSpec instanceof DefaultFacetSpec) || (facetValue = (defaultFacetSpec = (DefaultFacetSpec)facetSpec).getFacetValue((FacetValues)facetsBuilder).asErrable()).valueOpt().isPresent()) continue;
            try {
                Provider<Object> provider = this.getInjectedValue(vajramDefinition.vajramId(), facetSpec);
                if (provider instanceof AutoCloseable) {
                    AutoCloseable closeable = (AutoCloseable)provider;
                    closeables.add(closeable);
                }
                value = Errable.errableFrom(() -> provider.get());
            }
            catch (Exception e) {
                log.error("Could not inject input {} of vajram {}", new Object[]{facetSpec, this.kryon.getKryonDefinition().vajramID().id(), e});
                value = Errable.withError((Throwable)e);
            }
            if (value instanceof Failure) {
                Failure f = (Failure)value;
                defaultFacetSpec.setFacetValue(facetsBuilder, (FacetValue)new ErrableFacetValue((Errable)f));
                log.error("Could not inject input {} of vajram {}", new Object[]{facetSpec, this.kryon.getKryonDefinition().vajramID().id(), f.error()});
            }
            defaultFacetSpec.setFacetValue(facetsBuilder, (FacetValue)new ErrableFacetValue(value));
        }
        return closeables;
    }

    private Provider<Object> getInjectedValue(VajramID vajramId, FacetSpec<?, ?> facetDef) throws Exception {
        VajramInjectionProvider inputInjector = this.injectionProvider;
        if (inputInjector == null) {
            throw new KrystalCompletionException("Dependency injector is null");
        }
        return inputInjector.get(vajramId, facetDef);
    }
}

