/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.except.KrystalCompletionException;
import com.flipkart.krystal.facets.BasicFacetInfo;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.facets.Facet;
import com.flipkart.krystal.facets.resolution.ResolverCommand;
import com.flipkart.krystal.facets.resolution.ResolverDefinition;
import com.flipkart.krystal.krystex.Logic;
import com.flipkart.krystal.krystex.LogicDefinition;
import com.flipkart.krystal.krystex.LogicDefinitionRegistry;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.krystex.kryon.KryonDefinitionRegistry;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.resolution.CreateNewRequest;
import com.flipkart.krystal.krystex.resolution.FacetsFromRequest;
import com.flipkart.krystal.krystex.resolution.Resolver;
import com.flipkart.krystal.krystex.resolution.ResolverLogic;
import com.flipkart.krystal.model.IfAbsent;
import com.flipkart.krystal.tags.ElementTags;
import com.flipkart.krystal.vajram.IOVajramDef;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.exception.MandatoryFacetMissingException;
import com.flipkart.krystal.vajram.exception.MandatoryFacetsMissingException;
import com.flipkart.krystal.vajram.exception.VajramDefinitionException;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.facets.FacetValidation;
import com.flipkart.krystal.vajram.facets.resolution.FanoutInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.One2OneInputResolver;
import com.flipkart.krystal.vajram.facets.specs.DependencySpec;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajram.utils.VajramLoader;
import com.flipkart.krystal.vajramexecutor.krystex.LogicDefRegistryDecorator;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VajramGraph {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VajramGraph.class);
    private final KryonDefinitionRegistry kryonDefinitionRegistry;
    private final LogicDefRegistryDecorator logicRegistryDecorator;
    private final ImmutableMap<VajramID, VajramDefinition> vajramDefinitions;
    private final ImmutableMap<Class<? extends VajramDefRoot>, VajramDefinition> definitionByDefType;
    private final ImmutableMap<Class<? extends Request<?>>, VajramDefinition> definitionByReqType;
    private final Set<VajramID> vajramExecutables = Collections.synchronizedSet(new LinkedHashSet());

    private VajramGraph(Set<String> packagePrefixes, Set<Class<? extends VajramDefRoot>> classes) {
        LogicDefinitionRegistry logicDefinitionRegistry = new LogicDefinitionRegistry();
        this.kryonDefinitionRegistry = new KryonDefinitionRegistry(logicDefinitionRegistry);
        this.logicRegistryDecorator = new LogicDefRegistryDecorator(logicDefinitionRegistry);
        LinkedHashMap<VajramID, VajramDefinition> vajramDefinitions = new LinkedHashMap<VajramID, VajramDefinition>();
        LinkedHashMap<Class<? extends VajramDefRoot>, VajramDefinition> definitionByDefType = new LinkedHashMap<Class<? extends VajramDefRoot>, VajramDefinition>();
        LinkedHashMap definitionByReqType = new LinkedHashMap();
        for (VajramDefRoot vajramDef : VajramLoader.loadVajrams(packagePrefixes, classes)) {
            this.registerVajram((VajramDefRoot<Object>)vajramDef, vajramDefinitions, definitionByDefType, definitionByReqType);
        }
        this.vajramDefinitions = ImmutableMap.copyOf(vajramDefinitions);
        this.definitionByDefType = ImmutableMap.copyOf(definitionByDefType);
        this.definitionByReqType = ImmutableMap.copyOf(definitionByReqType);
        this.loadKryons();
    }

    public ImmutableMap<VajramID, VajramDefinition> vajramDefinitions() {
        return ImmutableMap.copyOf(this.vajramDefinitions);
    }

    public DependentChain computeDependentChain(String firstVajramId, Dependency firstDependency, Dependency ... subsequentDependencies) {
        DependentChain currentDepChain = this.kryonDefinitionRegistry.getDependentChainsStart().extend(VajramID.vajramID((String)firstVajramId), firstDependency);
        for (Dependency dependency : subsequentDependencies) {
            currentDepChain = currentDepChain.extend(dependency.ofVajramID(), dependency);
        }
        return currentDepChain;
    }

    private VajramDefinition registerVajram(VajramDefRoot<Object> vajramDef, Map<VajramID, VajramDefinition> vajramDefinitions, Map<Class<? extends VajramDefRoot>, VajramDefinition> definitionByDefType, Map<Class<? extends Request<?>>, VajramDefinition> definitionByReqType) {
        VajramDefinition vajramDefinition = new VajramDefinition(vajramDef);
        VajramID vajramID = vajramDefinition.vajramId();
        if (vajramDefinitions.containsKey(vajramID)) {
            return vajramDefinition;
        }
        vajramDefinitions.put(vajramID, vajramDefinition);
        definitionByDefType.putIfAbsent(vajramDefinition.defType(), vajramDefinition);
        definitionByReqType.putIfAbsent(vajramDefinition.reqRootType(), vajramDefinition);
        return vajramDefinition;
    }

    private void loadKryons() {
        for (VajramID vajramID : this.vajramDefinitions.keySet()) {
            this.loadKryonSubgraph(vajramID, new LinkedHashSet<VajramID>());
        }
    }

    private void loadKryonSubgraph(VajramID vajramId, Set<VajramID> loadingInProgress) {
        if (this.vajramExecutables.contains(vajramId)) {
            return;
        }
        if (loadingInProgress.contains(vajramId)) {
            return;
        }
        loadingInProgress.add(vajramId);
        VajramDefinition vajramDefinition = this.getVajramDefinition(vajramId);
        VajramDefRoot vajramDefRoot = vajramDefinition.def();
        ImmutableSet facets = vajramDefinition.facetSpecs();
        LogicDefinition createNewRequest = new LogicDefinition(new KryonLogicId(vajramId, "%s:newRequest"), (Set)ImmutableSet.of(), ElementTags.emptyTags(), (Logic)((CreateNewRequest)() -> ((VajramDefRoot)vajramDefRoot).newRequestBuilder()));
        if (vajramDefinition.isTrait()) {
            this.kryonDefinitionRegistry.newTraitKryonDefinition(vajramId.id(), (Set)facets, createNewRequest, vajramDefinition.vajramTags());
        } else if (vajramDefRoot instanceof VajramDef) {
            VajramDef vajramDef = (VajramDef)vajramDefRoot;
            InputResolverCreationResult inputResolverCreationResult = this.createKryonLogicsForInputResolvers(vajramDefinition);
            this.createKryonDefinitionsForDependencies(vajramDefinition, loadingInProgress);
            OutputLogicDefinition<?> outputLogicDefinition = this.createKryonOutputLogic(vajramId, vajramDefinition, (VajramDef<Object>)vajramDef);
            this.kryonDefinitionRegistry.newVajramKryonDefinition(vajramId, (Set)facets, outputLogicDefinition.kryonLogicId(), inputResolverCreationResult.resolversByDefinition(), createNewRequest, new LogicDefinition(new KryonLogicId(vajramId, "%s:facetsFromRequest"), (Set)ImmutableSet.of(), ElementTags.emptyTags(), (Logic)((FacetsFromRequest)arg_0 -> ((VajramDef)vajramDef).facetsFromRequest(arg_0))), arg_0 -> ((VajramDef)vajramDef).executeGraph(arg_0), vajramDefinition.vajramTags());
        }
        this.vajramExecutables.add(vajramId);
    }

    private InputResolverCreationResult createKryonLogicsForInputResolvers(VajramDefinition vajramDefinition) {
        VajramID vajramId = vajramDefinition.vajramId();
        ImmutableSet facetDefinitions = vajramDefinition.facetSpecs();
        ImmutableMap inputResolvers = vajramDefinition.inputResolvers();
        LinkedHashMap resolverDefinitions = new LinkedHashMap();
        inputResolvers.forEach((resolverId, inputResolver) -> {
            ResolverDefinition inputResolverDefinition = inputResolver.definition();
            Dependency dependency = inputResolverDefinition.target().dependency();
            if (dependency == null) {
                throw new IllegalStateException();
            }
            String depName = dependency.name();
            ImmutableSet sources = inputResolver.definition().sources();
            ImmutableCollection sourceFacets = (ImmutableCollection)facetDefinitions.stream().filter(arg_0 -> ((ImmutableSet)sources).contains(arg_0)).collect(ImmutableList.toImmutableList());
            LogicDefinition<ResolverLogic> inputResolverLogic = this.logicRegistryDecorator.newResolverLogic(vajramId.id(), "%s:dep(%s):inputResolver(%s)".formatted(vajramId, dependency, String.join((CharSequence)",", inputResolver.definition().target().targetInputs().stream().map(BasicFacetInfo::name).toList())), (Set<? extends Facet>)sources, (depRequests, facets) -> {
                ResolverCommand resolverCommand;
                block5: {
                    try {
                        this.validateMandatory(vajramId, facets, (ImmutableCollection<FacetSpec>)sourceFacets);
                        if (inputResolver instanceof One2OneInputResolver) {
                            One2OneInputResolver singleInputResolver = (One2OneInputResolver)inputResolver;
                            resolverCommand = singleInputResolver.resolve(depRequests, facets);
                            break block5;
                        }
                        if (inputResolver instanceof FanoutInputResolver) {
                            FanoutInputResolver fanoutInputResolver = (FanoutInputResolver)inputResolver;
                            if (depRequests.size() != 1) {
                                throw new IllegalStateException("The vajram " + vajramId.id() + " can have at most one fanout resolver");
                            }
                            resolverCommand = fanoutInputResolver.resolve((ImmutableRequest.Builder)depRequests.get(0), facets);
                            break block5;
                        }
                        throw new UnsupportedOperationException("Unsupported input resolver type: " + String.valueOf(inputResolver));
                    }
                    catch (Throwable t) {
                        resolverCommand = ResolverCommand.skip((String)"Got exception '%s' while executing the resolver of the dependency '%s'".formatted(t, depName), (Throwable)t);
                    }
                }
                return resolverCommand;
            });
            Resolver resolver = new Resolver(inputResolverLogic.kryonLogicId(), inputResolver.definition());
            resolverDefinitions.put(resolver.definition(), resolver);
        });
        return new InputResolverCreationResult((ImmutableMap<ResolverDefinition, Resolver>)ImmutableMap.copyOf(resolverDefinitions));
    }

    private void validateMandatory(VajramID vajramID, FacetValues facetValues, ImmutableCollection<FacetSpec> sourceFacets) {
        HashMap<String, Object> missingMandatoryValues = new HashMap<String, Object>();
        for (Facet facet : sourceFacets) {
            if (!facet.tags().getAnnotationByType(IfAbsent.class).map(ifAbsent -> IfAbsent.IfAbsentThen.FAIL.equals((Object)ifAbsent.value())).orElse(false).booleanValue()) continue;
            Facet mandatoryFacet = facet;
            FacetValue facetValue = mandatoryFacet.getFacetValue(facetValues);
            if (!(facetValue instanceof FacetValue.SingleFacetValue)) {
                FanoutDepResponses fanoutDepResponses;
                List requestResponsePairs;
                if (!(facetValue instanceof FanoutDepResponses) || !(requestResponsePairs = (fanoutDepResponses = (FanoutDepResponses)facetValue).requestResponsePairs()).stream().allMatch(reqResp -> reqResp.response().valueOpt().isEmpty())) continue;
                missingMandatoryValues.put(mandatoryFacet.name(), new MandatoryFacetMissingException(vajramID.id(), mandatoryFacet.name()));
                continue;
            }
            FacetValue.SingleFacetValue errableFacetValue = (FacetValue.SingleFacetValue)facetValue;
            Errable value = errableFacetValue.asErrable();
            Optional error = value.errorOpt();
            if (error.isPresent()) {
                missingMandatoryValues.put(mandatoryFacet.name(), (Throwable)error.get());
                continue;
            }
            try {
                FacetValidation.validateMandatoryFacet(value.valueOpt().orElse(null), (String)vajramID.id(), (String)mandatoryFacet.name());
            }
            catch (Throwable e) {
                missingMandatoryValues.put(mandatoryFacet.name(), e);
            }
        }
        if (missingMandatoryValues.isEmpty()) {
            return;
        }
        throw new MandatoryFacetsMissingException(vajramID, missingMandatoryValues);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private OutputLogicDefinition<?> createKryonOutputLogic(VajramID vajramID, VajramDefinition vajramDefinition, VajramDef<Object> vajramDef) {
        VajramID vajramId = vajramDefinition.vajramId();
        ImmutableSet facetSpecs = vajramDefinition.facetSpecs();
        ImmutableSet kryonOutputLogicSources = (ImmutableSet)facetSpecs.stream().filter(arg_0 -> ((ImmutableSet)vajramDefinition.outputLogicSources()).contains(arg_0)).collect(ImmutableSet.toImmutableSet());
        KryonLogicId outputLogicName = new KryonLogicId(vajramID, "%s:outputLogic".formatted(vajramId));
        @Nullable OutputLogic outputLogicCode = input -> {
            List inputsList = input.facetValueResponses();
            ArrayList validInputs = new ArrayList(inputsList.size());
            inputsList.forEach(inputs -> {
                try {
                    this.validateMandatory(vajramId, (FacetValues)inputs.facetValues(), (ImmutableCollection<FacetSpec>)facetSpecs);
                    validInputs.add(inputs);
                }
                catch (Throwable e) {
                    inputs.response().completeExceptionally(KrystalCompletionException.wrapAsCompletionException((Throwable)e));
                }
            });
            try {
                vajramDef.execute(input.withFacetValueResponses(validInputs));
            }
            catch (Throwable e) {
                validInputs.forEach(i -> i.response().completeExceptionally(KrystalCompletionException.wrapAsCompletionException((Throwable)e)));
            }
        };
        return this.logicRegistryDecorator.newOutputLogic(vajramDef instanceof IOVajramDef, outputLogicName, (Set<Facet>)kryonOutputLogicSources, outputLogicCode, vajramDefinition.outputLogicTags());
    }

    private void createKryonDefinitionsForDependencies(VajramDefinition vajramDefinition, Set<VajramID> loadingInProgress) {
        ArrayList<DependencySpec> dependencies = new ArrayList<DependencySpec>();
        for (Facet facet : vajramDefinition.facetSpecs()) {
            if (!(facet instanceof DependencySpec)) continue;
            DependencySpec definition = (DependencySpec)facet;
            dependencies.add(definition);
        }
        for (DependencySpec dependency : dependencies) {
            VajramID accessSpec = dependency.onVajramID();
            VajramDefinition dependencyVajram = (VajramDefinition)this.vajramDefinitions.get((Object)accessSpec);
            if (dependencyVajram == null) {
                throw new VajramDefinitionException("Unable to find vajram for vajramId %s".formatted(accessSpec));
            }
            this.loadKryonSubgraph(dependencyVajram.vajramId(), loadingInProgress);
        }
    }

    public VajramDefinition getVajramDefinition(VajramID vajramId) {
        VajramDefinition vajramDefinition = (VajramDefinition)this.vajramDefinitions.get((Object)vajramId);
        if (vajramDefinition == null) {
            throw new IllegalArgumentException("Could not find vajram definition for id %s".formatted(vajramId));
        }
        return vajramDefinition;
    }

    public VajramID getVajramIdByVajramDefType(Class<? extends VajramDefRoot<?>> vajramDefClass) {
        VajramDefinition vajramDefinition = (VajramDefinition)this.definitionByDefType.get(vajramDefClass);
        if (vajramDefinition == null) {
            throw new IllegalArgumentException("Could not find vajram definition for class %s".formatted(vajramDefClass));
        }
        return vajramDefinition.vajramId();
    }

    public VajramID getVajramIdByVajramReqType(Class<? extends Request> vajramReqClass) {
        VajramDefinition vajramDefinition = (VajramDefinition)this.definitionByReqType.get(vajramReqClass);
        if (vajramDefinition == null) {
            throw new IllegalArgumentException("Could not find vajram definition for request type %s".formatted(vajramReqClass));
        }
        return vajramDefinition.vajramId();
    }

    public Optional<Class<? extends Request<?>>> getVajramReqByVajramId(VajramID vajramID) {
        return Optional.ofNullable((VajramDefinition)this.vajramDefinitions.get((Object)vajramID)).map(VajramDefinition::reqRootType);
    }

    @Generated
    public static @NonNull VajramGraphBuilder builder() {
        return new VajramGraphBuilder();
    }

    @Generated
    public KryonDefinitionRegistry kryonDefinitionRegistry() {
        return this.kryonDefinitionRegistry;
    }

    private record InputResolverCreationResult(ImmutableMap<ResolverDefinition, Resolver> resolversByDefinition) {
    }

    public static final class VajramGraphBuilder {
        private final Set<String> packagePrefixes = new LinkedHashSet<String>();
        private final Set<Class<? extends VajramDefRoot>> classes = new LinkedHashSet<Class<? extends VajramDefRoot>>();

        public VajramGraphBuilder loadFromPackage(String packagePrefix) {
            this.packagePrefixes.add(packagePrefix);
            return this;
        }

        @SafeVarargs
        public final VajramGraphBuilder loadClasses(Class<? extends VajramDefRoot> ... classes) {
            this.classes.addAll(Arrays.asList(classes));
            return this;
        }

        private VajramGraphBuilder packagePrefixes(Set<String> packagePrefixes) {
            return this;
        }

        private VajramGraphBuilder classes(Set<Class<? extends VajramDefRoot>> packagePrefixes) {
            return this;
        }

        @Generated
        VajramGraphBuilder() {
        }

        @Generated
        public @NonNull VajramGraph build() {
            return new VajramGraph(this.packagePrefixes, this.classes);
        }

        @Generated
        public @NonNull String toString() {
            return "VajramGraph.VajramGraphBuilder(packagePrefixes=" + String.valueOf(this.packagePrefixes) + ", classes=" + String.valueOf(this.classes) + ")";
        }
    }
}

