/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.data.RequestResponseFuture;
import com.flipkart.krystal.krystex.KrystalExecutor;
import com.flipkart.krystal.krystex.kryon.KryonExecutionConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.vajram.exec.VajramExecutor;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexGraph;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutorConfig;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KrystexVajramExecutor
implements VajramExecutor {
    private final KrystalExecutor krystalExecutor;

    public KrystexVajramExecutor(@lombok.NonNull KrystexGraph executableGraph, @lombok.NonNull KrystexVajramExecutorConfig executorConfig) {
        if (executableGraph == null) {
            throw new NullPointerException("executableGraph is marked non-null but is null");
        }
        if (executorConfig == null) {
            throw new NullPointerException("executorConfig is marked non-null but is null");
        }
        this.krystalExecutor = new KryonExecutor(executableGraph.vajramGraph().kryonDefinitionRegistry(), executorConfig.kryonExecutorConfigBuilder().configureWith(executableGraph.inputInjectionConfig()).configureWith(executableGraph.inputBatchingConfig()).build());
    }

    public <T> CompletableFuture<@Nullable T> execute(ImmutableRequest<T> request) {
        return this.execute(request, KryonExecutionConfig.builder().build());
    }

    public <T> void execute(RequestResponseFuture<? extends Request<T>, T> requestResponseFuture) {
        this.execute(requestResponseFuture, KryonExecutionConfig.builder().build());
    }

    public <T> CompletableFuture<@Nullable T> execute(ImmutableRequest<T> vajramRequest, KryonExecutionConfig executionConfig) {
        RequestResponseFuture requestResponseFuture = new RequestResponseFuture(vajramRequest, new CompletableFuture());
        this.execute(requestResponseFuture, executionConfig);
        return requestResponseFuture.response();
    }

    public <T> void execute(RequestResponseFuture<? extends Request<T>, T> requestResponseFuture, KryonExecutionConfig executionConfig) {
        this.krystalExecutor.executeKryon(requestResponseFuture, executionConfig);
    }

    public KrystalExecutor getKrystalExecutor() {
        return this.krystalExecutor;
    }

    public void close() {
        this.krystalExecutor.close();
    }

    public void shutdownNow() {
        this.krystalExecutor.shutdownNow();
    }

    @Generated
    public static @NonNull KrystexVajramExecutorBuilder builder() {
        return new KrystexVajramExecutorBuilder();
    }

    @Generated
    public static class KrystexVajramExecutorBuilder {
        @Generated
        private KrystexGraph executableGraph;
        @Generated
        private KrystexVajramExecutorConfig executorConfig;

        @Generated
        KrystexVajramExecutorBuilder() {
        }

        @Generated
        public @NonNull KrystexVajramExecutorBuilder executableGraph(@lombok.NonNull KrystexGraph executableGraph) {
            if (executableGraph == null) {
                throw new NullPointerException("executableGraph is marked non-null but is null");
            }
            this.executableGraph = executableGraph;
            return this;
        }

        @Generated
        public @NonNull KrystexVajramExecutorBuilder executorConfig(@lombok.NonNull KrystexVajramExecutorConfig executorConfig) {
            if (executorConfig == null) {
                throw new NullPointerException("executorConfig is marked non-null but is null");
            }
            this.executorConfig = executorConfig;
            return this;
        }

        @Generated
        public @NonNull KrystexVajramExecutor build() {
            return new KrystexVajramExecutor(this.executableGraph, this.executorConfig);
        }

        @Generated
        public @NonNull String toString() {
            return "KrystexVajramExecutor.KrystexVajramExecutorBuilder(executableGraph=" + String.valueOf(this.executableGraph) + ", executorConfig=" + String.valueOf(this.executorConfig) + ")";
        }
    }
}

