/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.krystex.dependencydecorators.TraitDispatchDecorator;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfigurator;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorConfig;
import com.flipkart.krystal.krystex.kryondecoration.KryonExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecoratorConfig;
import com.flipkart.krystal.traits.TraitDispatchPolicies;
import com.flipkart.krystal.traits.TraitDispatchPolicy;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.inputinjection.VajramInjectionProvider;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutor;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutorConfig;
import com.flipkart.krystal.vajramexecutor.krystex.VajramGraph;
import com.flipkart.krystal.vajramexecutor.krystex.batching.DepChainBatcherConfig;
import com.flipkart.krystal.vajramexecutor.krystex.batching.InputBatcherConfig;
import com.flipkart.krystal.vajramexecutor.krystex.batching.InputBatchingDecorator;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.KryonInputInjector;
import com.flipkart.krystal.vajramexecutor.krystex.traits.DefaultTraitDispatcher;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KrystexGraph {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KrystexGraph.class);
    private final VajramGraph vajramGraph;
    private final TraitDispatchPolicies traitDispatchPolicies;
    private final @Nullable TraitDispatchDecorator traitDispatchDecorator;
    private final KryonExecutorConfigurator inputBatchingConfig;
    private final KryonExecutorConfigurator inputInjectionConfig;

    public KrystexGraph(@NonNull VajramGraph vajramGraph, @Nullable TraitDispatchPolicies traitDispatchPolicies, @Nullable InputBatcherConfig inputBatcherConfig, @Nullable VajramInjectionProvider injectionProvider) {
        if (vajramGraph == null) {
            throw new NullPointerException("vajramGraph is marked non-null but is null");
        }
        this.vajramGraph = vajramGraph;
        this.traitDispatchPolicies = traitDispatchPolicies != null ? traitDispatchPolicies : new TraitDispatchPolicies();
        this.traitDispatchDecorator = new DefaultTraitDispatcher(vajramGraph, this.traitDispatchPolicies);
        this.inputInjectionConfig = KrystexGraph.create(injectionProvider, vajramGraph);
        this.inputBatchingConfig = KrystexGraph.create(inputBatcherConfig, vajramGraph);
    }

    public KrystexVajramExecutor createExecutor(KrystexVajramExecutorConfig vajramExecConfig) {
        vajramExecConfig.kryonExecutorConfigBuilder().traitDispatchDecorator(this.traitDispatchDecorator);
        return KrystexVajramExecutor.builder().executableGraph(this).executorConfig(vajramExecConfig).build();
    }

    public @Nullable TraitDispatchPolicy getTraitDispatchPolicy(VajramID traitID) {
        VajramDefinition traitDef = this.vajramGraph.getVajramDefinition(traitID);
        if (!traitDef.isTrait()) {
            throw new IllegalArgumentException("Vajram with id %s is not a trait!".formatted(traitID));
        }
        return this.traitDispatchPolicies.get(traitID);
    }

    private static KryonExecutorConfigurator create(@Nullable VajramInjectionProvider injectionProvider, VajramGraph vajramGraph) {
        if (injectionProvider == null) {
            return KryonExecutorConfigurator.NO_OP;
        }
        return configBuilder -> configBuilder.kryonDecoratorConfig(KryonInputInjector.DECORATOR_TYPE, new KryonDecoratorConfig(KryonInputInjector.DECORATOR_TYPE, executionContext -> KrystexGraph.isInjectionNeeded(executionContext, vajramGraph), executionContext -> KryonInputInjector.DECORATOR_TYPE, decoratorContext -> new KryonInputInjector(vajramGraph, injectionProvider)));
    }

    private static boolean isInjectionNeeded(KryonExecutionContext executionContext, VajramGraph vajramGraph) {
        return vajramGraph.getVajramDefinition(executionContext.vajramID()).metadata().isInputInjectionNeeded();
    }

    private static KryonExecutorConfigurator create(@Nullable InputBatcherConfig inputBatcherConfig, VajramGraph vajramGraph) {
        if (inputBatcherConfig == null) {
            return KryonExecutorConfigurator.NO_OP;
        }
        ConcurrentHashMap batcherConfigByDepChain = new ConcurrentHashMap();
        Function<LogicExecutionContext, DepChainBatcherConfig> inputBatcherForLogicExecContext = logicExecutionContext -> batcherConfigByDepChain.computeIfAbsent(logicExecutionContext.dependents(), d -> {
            VajramID vajramID = logicExecutionContext.vajramID();
            VajramDefinition vajramDefinition = (VajramDefinition)vajramGraph.vajramDefinitions().get((Object)vajramID);
            if (vajramDefinition == null) {
                log.error("Unable to find vajram with id {}. Something is wrong. Skipping InputBatchingDecorator application.", (Object)vajramID);
                return DepChainBatcherConfig.NO_BATCHING;
            }
            if (vajramDefinition.isTrait()) {
                log.error("Cannot register input Batchers for vajramId {} since it is a Trait. Skipping InputBatchingDecorator application.", (Object)vajramID.id());
                return DepChainBatcherConfig.NO_BATCHING;
            }
            for (DepChainBatcherConfig depChainBatcherConfig : (ImmutableList)inputBatcherConfig.depChainBatcherConfigs().getOrDefault((Object)vajramID, (Object)ImmutableList.of())) {
                boolean shouldDecorate = vajramDefinition.metadata().isBatched() && depChainBatcherConfig.shouldBatch().test((LogicExecutionContext)logicExecutionContext);
                if (!shouldDecorate) continue;
                return depChainBatcherConfig;
            }
            return DepChainBatcherConfig.NO_BATCHING;
        });
        OutputLogicDecoratorConfig batchingDecoratorConfig = new OutputLogicDecoratorConfig(InputBatchingDecorator.DECORATOR_TYPE, logicExecutionContext -> !DepChainBatcherConfig.NO_BATCHING.equals(inputBatcherForLogicExecContext.apply((LogicExecutionContext)logicExecutionContext)), logicExecutionContext -> Objects.requireNonNull((DepChainBatcherConfig)inputBatcherForLogicExecContext.apply((LogicExecutionContext)logicExecutionContext)).instanceIdGenerator().apply((LogicExecutionContext)logicExecutionContext), decoratorContext -> Objects.requireNonNull((DepChainBatcherConfig)inputBatcherForLogicExecContext.apply(decoratorContext.logicExecutionContext())).decoratorFactory().apply((OutputLogicDecoratorConfig.OutputLogicDecoratorContext)decoratorContext));
        return configBuilder -> configBuilder.outputLogicDecoratorConfig(InputBatchingDecorator.DECORATOR_TYPE, batchingDecoratorConfig);
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull KrystexGraphBuilder builder() {
        return new KrystexGraphBuilder();
    }

    @Generated
    public VajramGraph vajramGraph() {
        return this.vajramGraph;
    }

    @Generated
    KryonExecutorConfigurator inputBatchingConfig() {
        return this.inputBatchingConfig;
    }

    @Generated
    KryonExecutorConfigurator inputInjectionConfig() {
        return this.inputInjectionConfig;
    }

    @Generated
    public static class KrystexGraphBuilder {
        @Generated
        private VajramGraph vajramGraph;
        @Generated
        private TraitDispatchPolicies traitDispatchPolicies;
        @Generated
        private InputBatcherConfig inputBatcherConfig;
        @Generated
        private VajramInjectionProvider injectionProvider;

        @Generated
        KrystexGraphBuilder() {
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KrystexGraphBuilder vajramGraph(@NonNull VajramGraph vajramGraph) {
            if (vajramGraph == null) {
                throw new NullPointerException("vajramGraph is marked non-null but is null");
            }
            this.vajramGraph = vajramGraph;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KrystexGraphBuilder traitDispatchPolicies(@Nullable TraitDispatchPolicies traitDispatchPolicies) {
            this.traitDispatchPolicies = traitDispatchPolicies;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KrystexGraphBuilder inputBatcherConfig(@Nullable InputBatcherConfig inputBatcherConfig) {
            this.inputBatcherConfig = inputBatcherConfig;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KrystexGraphBuilder injectionProvider(@Nullable VajramInjectionProvider injectionProvider) {
            this.injectionProvider = injectionProvider;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KrystexGraph build() {
            return new KrystexGraph(this.vajramGraph, this.traitDispatchPolicies, this.inputBatcherConfig, this.injectionProvider);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "KrystexGraph.KrystexGraphBuilder(vajramGraph=" + String.valueOf(this.vajramGraph) + ", traitDispatchPolicies=" + String.valueOf(this.traitDispatchPolicies) + ", inputBatcherConfig=" + String.valueOf(this.inputBatcherConfig) + ", injectionProvider=" + String.valueOf(this.injectionProvider) + ")";
        }
    }
}

