/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.traits;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.data.RequestResponseFuture;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.krystex.commands.ClientSideCommand;
import com.flipkart.krystal.krystex.commands.DirectForwardSend;
import com.flipkart.krystal.krystex.commands.ForwardSendBatch;
import com.flipkart.krystal.krystex.dependencydecoration.VajramInvocation;
import com.flipkart.krystal.krystex.dependencydecorators.TraitDispatchDecorator;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.DirectResponse;
import com.flipkart.krystal.krystex.kryon.KryonCommandResponse;
import com.flipkart.krystal.krystex.request.InvocationId;
import com.flipkart.krystal.traits.DynamicDispatchPolicy;
import com.flipkart.krystal.traits.StaticDispatchPolicy;
import com.flipkart.krystal.traits.TraitDispatchPolicy;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public class TraitDispatchDecoratorImpl
implements TraitDispatchDecorator {
    public static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String DECORATOR_TYPE = StaticDispatchPolicy.class.getName();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramKryonGraph vajramKryonGraph;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramID, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TraitDispatchPolicy> traitDispatchPolicies;

    public TraitDispatchDecoratorImpl(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramKryonGraph vajramKryonGraph, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramID, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TraitDispatchPolicy> traitDispatchPolicies) {
        this.vajramKryonGraph = vajramKryonGraph;
        this.traitDispatchPolicies = traitDispatchPolicies;
    }

    public <R extends KryonCommandResponse> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInvocation<R> decorateDependency(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInvocation<R> invocationToDecorate) {
        return kryonCommand -> {
            if (!this.vajramKryonGraph.getVajramDefinition(kryonCommand.vajramID()).isTrait()) {
                return invocationToDecorate.invokeDependency(kryonCommand);
            }
            VajramID traitId = kryonCommand.vajramID();
            Dependency dependency = kryonCommand.dependentChain().latestDependency();
            TraitDispatchPolicy traitDispatchPolicy = (TraitDispatchPolicy)this.traitDispatchPolicies.get((Object)traitId);
            if (traitDispatchPolicy instanceof StaticDispatchPolicy) {
                StaticDispatchPolicy staticDispatchDefinition = (StaticDispatchPolicy)traitDispatchPolicy;
                if (dependency == null) {
                    throw new AssertionError((Object)"This is not possible. A dependency decorator can only be invoked when there is a dependency present.");
                }
                VajramID dispatchTarget = staticDispatchDefinition.getDispatchTargetID(dependency);
                ClientSideCommand commandToDispatch = kryonCommand.rerouteTo(dispatchTarget);
                return invocationToDecorate.invokeDependency(commandToDispatch);
            }
            if (traitDispatchPolicy instanceof DynamicDispatchPolicy) {
                DynamicDispatchPolicy dynamicPolicy = (DynamicDispatchPolicy)traitDispatchPolicy;
                if (kryonCommand instanceof ForwardSendBatch) {
                    ForwardSendBatch forwardSend = (ForwardSendBatch)kryonCommand;
                    Map originalExecutableRequests = forwardSend.executableRequests();
                    Map originalSkippedInvocations = forwardSend.skippedInvocations();
                    LinkedHashMap dispatchRequests = new LinkedHashMap();
                    LinkedHashMap<VajramID, CompletableFuture> dispatchResponses = new LinkedHashMap<VajramID, CompletableFuture>();
                    LinkedHashSet<InvocationId> orphanedRequests = new LinkedHashSet<InvocationId>();
                    for (Map.Entry requestEntry : originalExecutableRequests.entrySet()) {
                        InvocationId invocationId = (InvocationId)requestEntry.getKey();
                        Request originalRequest = (Request)requestEntry.getValue();
                        VajramID dispatchTarget = dynamicPolicy.getDispatchTargetID(dependency, originalRequest);
                        if (dispatchTarget != null) {
                            dispatchRequests.computeIfAbsent(dispatchTarget, k -> new LinkedHashMap()).put(invocationId, originalRequest);
                            continue;
                        }
                        orphanedRequests.add(invocationId);
                    }
                    ImmutableSet dispatchTargets = dynamicPolicy.dispatchTargetIDs();
                    ImmutableMap requestsToSkip = ImmutableMap.builder().putAll(originalSkippedInvocations).putAll(orphanedRequests.stream().collect(Collectors.toMap(Function.identity(), _r -> "The request did not match any of the configured dynamic dispatch targets of trait: " + traitId))).build();
                    for (VajramID dispatchTargetID : dispatchTargets) {
                        ForwardSendBatch commandToDispatch;
                        Map requestsForTarget = dispatchRequests.getOrDefault(dispatchTargetID, Map.of());
                        if (requestsForTarget.isEmpty()) {
                            LinkedHashMap skipRequests = new LinkedHashMap();
                            skipRequests.putAll(originalExecutableRequests.keySet().stream().collect(Collectors.toMap(Function.identity(), _r -> "None of the requests to trait " + traitId + " matched " + dispatchTargetID + " via dynamic predicate dispatch")));
                            skipRequests.putAll(requestsToSkip);
                            commandToDispatch = new ForwardSendBatch(dispatchTargetID, (Map)ImmutableMap.of(), forwardSend.dependentChain(), skipRequests);
                        } else {
                            commandToDispatch = new ForwardSendBatch(dispatchTargetID, requestsForTarget, forwardSend.dependentChain(), (Map)requestsToSkip);
                        }
                        CompletableFuture depResponse = invocationToDecorate.invokeDependency((ClientSideCommand)commandToDispatch);
                        dispatchResponses.put(dispatchTargetID, depResponse);
                    }
                    CompletableFuture mergedResponse = new CompletableFuture();
                    CompletableFuture.allOf((CompletableFuture[])dispatchResponses.values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> {
                        LinkedHashMap<InvocationId, Errable> mergedResults = new LinkedHashMap<InvocationId, Errable>();
                        for (Map.Entry dispatchResponseEntry : dispatchResponses.entrySet()) {
                            VajramID dispatchTarget = (VajramID)dispatchResponseEntry.getKey();
                            CompletableFuture dispatchResponse = (CompletableFuture)dispatchResponseEntry.getValue();
                            if (dispatchResponse.isCompletedExceptionally()) {
                                try {
                                    dispatchResponse.join();
                                    continue;
                                }
                                catch (Throwable e) {
                                    Set invocationIds = dispatchRequests.getOrDefault(dispatchTarget, Map.of()).keySet();
                                    for (InvocationId id : invocationIds) {
                                        mergedResults.put(id, Errable.withError((Throwable)e));
                                    }
                                    continue;
                                }
                            }
                            BatchResponse resultValue = dispatchResponse.getNow(BatchResponse.empty());
                            mergedResults.putAll(resultValue.responses());
                        }
                        mergedResponse.complete(new BatchResponse((Map)ImmutableMap.copyOf(mergedResults)));
                    });
                    CompletableFuture castMergedResponse = mergedResponse;
                    return castMergedResponse;
                }
                if (kryonCommand instanceof DirectForwardSend) {
                    DirectForwardSend forwardSend = (DirectForwardSend)kryonCommand;
                    List originalExecutableRequests = forwardSend.executableRequests();
                    LinkedHashMap dispatchRequests = new LinkedHashMap();
                    for (RequestResponseFuture requestEntry : originalExecutableRequests) {
                        Request originalRequest = requestEntry.request();
                        VajramID dispatchTarget = dynamicPolicy.getDispatchTargetID(dependency, originalRequest);
                        if (dispatchTarget != null) {
                            dispatchRequests.computeIfAbsent(dispatchTarget, k -> new ArrayList(originalExecutableRequests.size())).add(requestEntry);
                            continue;
                        }
                        dispatchRequests.computeIfAbsent(traitId, k -> new ArrayList(originalExecutableRequests.size())).add(requestEntry);
                    }
                    ImmutableSet dispatchTargets = dynamicPolicy.dispatchTargetReqs();
                    for (Class dispatchTarget : dispatchTargets) {
                        VajramID dispatchTargetId = this.vajramKryonGraph.getVajramIdByVajramReqType(dispatchTarget);
                        List requestsForTarget = dispatchRequests.getOrDefault(dispatchTargetId, List.of());
                        DirectForwardSend commandToDispatch = new DirectForwardSend(dispatchTargetId, requestsForTarget, forwardSend.dependentChain());
                        CompletableFuture completableFuture = invocationToDecorate.invokeDependency((ClientSideCommand)commandToDispatch);
                    }
                    CompletableFuture<DirectResponse> castMergedResponse = CompletableFuture.completedFuture(DirectResponse.INSTANCE);
                    return castMergedResponse;
                }
                throw new IllegalStateException("Unknown command type: " + kryonCommand);
            }
            throw new IllegalStateException("Unknown dispatch policy: " + traitDispatchPolicy);
        };
    }

    @Generated
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramID, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TraitDispatchPolicy> traitDispatchPolicies() {
        return this.traitDispatchPolicies;
    }
}

