/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.inputinjection;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.ErrableFacetValue;
import com.flipkart.krystal.data.ExecutionItem;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FacetValuesBuilder;
import com.flipkart.krystal.data.Failure;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.krystex.commands.DirectForwardReceive;
import com.flipkart.krystal.krystex.commands.ForwardReceiveBatch;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonCommandResponse;
import com.flipkart.krystal.krystex.kryon.VajramKryonDefinition;
import com.flipkart.krystal.krystex.request.InvocationId;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.facets.specs.DefaultFacetSpec;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajram.inputinjection.VajramInjectionProvider;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InjectingDecoratedKryon
implements Kryon<KryonCommand, KryonCommandResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InjectingDecoratedKryon.class);
    private final Kryon<KryonCommand, KryonCommandResponse> kryon;
    private final VajramKryonGraph vajramKryonGraph;
    private final @Nullable VajramInjectionProvider injectionProvider;

    InjectingDecoratedKryon(Kryon<KryonCommand, KryonCommandResponse> kryon, VajramKryonGraph vajramKryonGraph, @Nullable VajramInjectionProvider injectionProvider) {
        this.kryon = kryon;
        this.vajramKryonGraph = vajramKryonGraph;
        this.injectionProvider = injectionProvider;
    }

    public VajramKryonDefinition getKryonDefinition() {
        return this.kryon.getKryonDefinition();
    }

    public CompletableFuture<KryonCommandResponse> executeCommand(KryonCommand kryonCommand) {
        VajramDefinition vajramDefinition = this.vajramKryonGraph.getVajramDefinition(VajramID.vajramID((String)kryonCommand.vajramID().id()));
        if (vajramDefinition.metadata().isInputInjectionNeeded() && vajramDefinition.def() instanceof VajramDef) {
            if (kryonCommand instanceof ForwardReceiveBatch) {
                ForwardReceiveBatch forwardBatch = (ForwardReceiveBatch)kryonCommand;
                return this.injectFacets(forwardBatch, vajramDefinition);
            }
            if (kryonCommand instanceof DirectForwardReceive) {
                DirectForwardReceive forwardReceive = (DirectForwardReceive)kryonCommand;
                return this.injectFacets(forwardReceive, vajramDefinition);
            }
        }
        return this.kryon.executeCommand(kryonCommand);
    }

    private CompletableFuture<KryonCommandResponse> injectFacets(DirectForwardReceive forwardReceive, VajramDefinition vajramDefinition) {
        LinkedHashSet injectableFacets = new LinkedHashSet();
        vajramDefinition.facetSpecs().forEach(facetSpec -> {
            if (FacetType.INJECTION.equals((Object)facetSpec.facetType())) {
                injectableFacets.add((FacetSpec<?, ?>)facetSpec);
            }
        });
        for (ExecutionItem executionItem : forwardReceive.executionItems()) {
            FacetValuesBuilder facetsBuilder = executionItem.facetValues();
            this.injectFacetsOfVajram(vajramDefinition, injectableFacets, facetsBuilder);
        }
        return this.kryon.executeCommand((KryonCommand)forwardReceive);
    }

    private CompletableFuture<KryonCommandResponse> injectFacets(ForwardReceiveBatch forwardBatch, VajramDefinition vajramDefinition) {
        Map requestIdToFacets = forwardBatch.executableInvocations();
        ImmutableMap.Builder newRequests = ImmutableMap.builder();
        LinkedHashSet injectableFacets = new LinkedHashSet();
        vajramDefinition.facetSpecs().forEach(facetSpec -> {
            if (FacetType.INJECTION.equals((Object)facetSpec.facetType())) {
                injectableFacets.add((FacetSpec<?, ?>)facetSpec);
            }
        });
        for (Map.Entry entry : requestIdToFacets.entrySet()) {
            InvocationId invocationId = (InvocationId)entry.getKey();
            FacetValuesBuilder facetsBuilder = ((FacetValues)entry.getValue())._asBuilder();
            newRequests.put((Object)invocationId, (Object)this.injectFacetsOfVajram(vajramDefinition, injectableFacets, facetsBuilder));
        }
        return this.kryon.executeCommand((KryonCommand)new ForwardReceiveBatch(forwardBatch.vajramID(), (Map)newRequests.build(), forwardBatch.dependentChain(), forwardBatch.invocationsToSkip()));
    }

    private FacetValuesBuilder injectFacetsOfVajram(VajramDefinition vajramDefinition, Set<FacetSpec<?, ?>> injectableFacets, FacetValuesBuilder facetsBuilder) {
        for (FacetSpec<?, ?> facetSpec : injectableFacets) {
            DefaultFacetSpec defaultFacetSpec;
            Errable facetValue;
            if (!(facetSpec instanceof DefaultFacetSpec) || (facetValue = (defaultFacetSpec = (DefaultFacetSpec)facetSpec).getFacetValue((FacetValues)facetsBuilder).asErrable()).valueOpt().isPresent()) continue;
            Errable<Object> injectedValue = this.getInjectedValue(vajramDefinition.vajramId(), facetSpec);
            if (injectedValue instanceof Failure) {
                Failure f = (Failure)injectedValue;
                defaultFacetSpec.setFacetValue(facetsBuilder, (FacetValue)new ErrableFacetValue((Errable)f));
                log.error("Could not inject input {} of vajram {}", new Object[]{facetSpec, this.kryon.getKryonDefinition().vajramID().id(), f.error()});
            }
            defaultFacetSpec.setFacetValue(facetsBuilder, (FacetValue)new ErrableFacetValue(injectedValue));
        }
        return facetsBuilder;
    }

    private Errable<Object> getInjectedValue(VajramID vajramId, FacetSpec facetDef) {
        VajramInjectionProvider inputInjector = this.injectionProvider;
        if (inputInjector == null) {
            StackTracelessException exception = new StackTracelessException("Dependency injector is null");
            log.error("Cannot inject input {} of vajram {}", new Object[]{facetDef, this.kryon.getKryonDefinition().vajramID().id(), exception});
            return Errable.withError((Throwable)exception);
        }
        try {
            return inputInjector.get(vajramId, facetDef);
        }
        catch (Throwable e) {
            String message = "Could not inject input %s of vajram %s".formatted(facetDef, this.kryon.getKryonDefinition().vajramID().id());
            log.error(message, e);
            return Errable.withError((Throwable)e);
        }
    }
}

