/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.traits;

import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.InputMirror;
import com.flipkart.krystal.traits.DispatchCase;
import com.flipkart.krystal.traits.PredicateDispatchPolicy;
import com.flipkart.krystal.traits.UseForPredicateDispatch;
import com.flipkart.krystal.traits.matchers.InputValueMatcher;
import com.flipkart.krystal.vajram.TraitRequestRoot;
import com.flipkart.krystal.vajram.VajramRequestRoot;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.flipkart.krystal.vajramexecutor.krystex.traits.PredicateDispatchPolicyImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PredicateDispatchUtil {
    public static <R extends Request<?>> InputDispatcherBuilder<R> dispatchTrait(Class<R> traitReq, VajramKryonGraph graph) {
        Preconditions.checkArgument((traitReq.getAnnotation(TraitRequestRoot.class) != null ? 1 : 0) != 0, (Object)"Expecting a trait request root i.e a request class with the annotation @TraitRequestRoot");
        return new InputDispatcherBuilder<R>(traitReq, graph);
    }

    public static <T, R> DispatchCaseBuilder<R> when(InputMirrorSpec<T, ? extends Request<R>> input, InputValueMatcher<T> inputValueMatcher) {
        Preconditions.checkArgument((boolean)input.tags().getAnnotationByType(UseForPredicateDispatch.class).isPresent(), (Object)"Only the trait Inputs annotated as @UseForPredicateDispatch can be used for dynamic dispatching");
        return new DispatchCaseBuilder(ImmutableMap.of(input, inputValueMatcher));
    }

    private PredicateDispatchUtil() {
    }

    public static class InputDispatcherBuilder<R extends Request<?>> {
        private final Class<R> traitReq;
        private final VajramKryonGraph graph;

        @SafeVarargs
        public final PredicateDispatchPolicy conditionally(PredicatesDispatchCase<? extends Request<?>> ... dispatchCases) {
            return new PredicateDispatchPolicyImpl(this.traitReq, (ImmutableList<DispatchCase>)ImmutableList.copyOf((Object[])dispatchCases), this.graph);
        }

        public final PredicateDispatchPolicyImpl computingTargetWith(Function<? super R, Optional<? extends Class<? extends R>>> dispatchTargetSelector, ImmutableSet<? extends Class<? extends R>> dispatchTargets) {
            return new PredicateDispatchPolicyImpl(this.traitReq, (ImmutableList<DispatchCase>)ImmutableList.of(new ComputedDispatchCase<R>(dispatchTargetSelector, ImmutableSet.copyOf(dispatchTargets))), this.graph);
        }

        @Generated
        private InputDispatcherBuilder(Class<R> traitReq, VajramKryonGraph graph) {
            this.traitReq = traitReq;
            this.graph = graph;
        }
    }

    public static class DispatchCaseBuilder<T> {
        private ImmutableMap<InputMirror, InputValueMatcher<?>> facetPredicates;

        public <P> DispatchCaseBuilder<T> and(InputMirrorSpec<P, ? extends Request<T>> input, InputValueMatcher<P> dataType) {
            Preconditions.checkArgument((!this.facetPredicates.containsKey(input) ? 1 : 0) != 0, (Object)("Facet " + String.valueOf(input) + " already has a type check in this case"));
            LinkedHashMap newMap = new LinkedHashMap((Map<InputMirror, InputValueMatcher<?>>)this.facetPredicates);
            newMap.put((InputMirror)input, dataType);
            return new DispatchCaseBuilder<T>(ImmutableMap.copyOf(newMap));
        }

        public PredicatesDispatchCase<? extends Request<T>> to(Class<? extends Request<T>> dispatchTarget) {
            Preconditions.checkArgument((dispatchTarget.getAnnotation(VajramRequestRoot.class) != null ? 1 : 0) != 0, (Object)"Expecting a Vajram request root class, i.e. one with the @VajramRequestRoot annotation");
            return new PredicatesDispatchCase<Request<T>>(this.facetPredicates, dispatchTarget);
        }

        @Generated
        private DispatchCaseBuilder(ImmutableMap<InputMirror, InputValueMatcher<?>> facetPredicates) {
            this.facetPredicates = facetPredicates;
        }
    }

    private record ComputedDispatchCase<R extends Request<?>>(Function<? super R, Optional<? extends Class<? extends R>>> dispatchTargetSelector, ImmutableSet<Class<? extends Request<?>>> dispatchTargets) implements DispatchCase
    {
        public Optional<? extends Class<? extends Request<?>>> computeDispatchTarget(Request<?> request) {
            Optional<Class<R>> dispatchTarget = this.dispatchTargetSelector.apply(request);
            if (dispatchTarget.isPresent() && this.dispatchTargets.contains(dispatchTarget.get())) {
                return dispatchTarget;
            }
            return Optional.empty();
        }
    }

    public static final class PredicatesDispatchCase<T extends Request<?>>
    implements DispatchCase {
        private final ImmutableMap<InputMirror, InputValueMatcher<?>> inputPredicates;
        private final Class<? extends T> dispatchTarget;

        public ImmutableSet<InputMirror> dispatchEnabledInputs() {
            return this.inputPredicates.keySet();
        }

        public Optional<Class<? extends T>> computeDispatchTarget(Request<?> request) {
            boolean caseMatches = true;
            for (InputMirror dispatchEnabledInput : this.dispatchEnabledInputs()) {
                Object inputValue = dispatchEnabledInput.getFromRequest(request);
                if (((InputValueMatcher)this.inputPredicates().getOrDefault((Object)dispatchEnabledInput, (Object)InputValueMatcher.isAnyValue())).matches(inputValue)) continue;
                caseMatches = false;
                break;
            }
            if (caseMatches) {
                return Optional.of(this.dispatchTarget);
            }
            return Optional.empty();
        }

        public ImmutableSet<Class<? extends Request<?>>> dispatchTargets() {
            return ImmutableSet.of(this.dispatchTarget);
        }

        @Generated
        public ImmutableMap<InputMirror, InputValueMatcher<?>> inputPredicates() {
            return this.inputPredicates;
        }

        @Generated
        public Class<? extends T> dispatchTarget() {
            return this.dispatchTarget;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PredicatesDispatchCase)) {
                return false;
            }
            PredicatesDispatchCase other = (PredicatesDispatchCase)o;
            ImmutableMap<InputMirror, InputValueMatcher<?>> this$inputPredicates = this.inputPredicates();
            ImmutableMap<InputMirror, InputValueMatcher<?>> other$inputPredicates = other.inputPredicates();
            if (this$inputPredicates == null ? other$inputPredicates != null : !this$inputPredicates.equals(other$inputPredicates)) {
                return false;
            }
            Class<T> this$dispatchTarget = this.dispatchTarget();
            Class<T> other$dispatchTarget = other.dispatchTarget();
            return !(this$dispatchTarget == null ? other$dispatchTarget != null : !this$dispatchTarget.equals(other$dispatchTarget));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ImmutableMap<InputMirror, InputValueMatcher<?>> $inputPredicates = this.inputPredicates();
            result = result * 59 + ($inputPredicates == null ? 43 : $inputPredicates.hashCode());
            Class<T> $dispatchTarget = this.dispatchTarget();
            result = result * 59 + ($dispatchTarget == null ? 43 : $dispatchTarget.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "PredicateDispatchUtil.PredicatesDispatchCase(inputPredicates=" + String.valueOf(this.inputPredicates()) + ", dispatchTarget=" + String.valueOf(this.dispatchTarget()) + ")";
        }

        @Generated
        private PredicatesDispatchCase(ImmutableMap<InputMirror, InputValueMatcher<?>> inputPredicates, Class<? extends T> dispatchTarget) {
            this.inputPredicates = inputPredicates;
            this.dispatchTarget = dispatchTarget;
        }
    }
}

