/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.traits;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.traits.ComputeDispatchPolicy;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.google.common.collect.ImmutableSet;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ComputeDispatchPolicyImpl<T extends Request<?>>
extends ComputeDispatchPolicy {
    private final VajramKryonGraph graph;
    private final Class<T> traitReqType;
    private final VajramID traitID;
    private final ImmutableSet<VajramID> dispatchTargetIDs;
    private final ImmutableSet<Class<? extends T>> dispatchTargetReqs;
    private final DispatchTargetComputer<T> dispatchTargetComputer;

    public ComputeDispatchPolicyImpl(Class<T> traitReqType, DispatchTargetComputer<T> dispatchTargetComputer, ImmutableSet<Class<? extends T>> dispatchTargetReqs, VajramKryonGraph graph) {
        this.traitReqType = traitReqType;
        this.graph = graph;
        this.traitID = graph.getVajramIdByVajramReqType(traitReqType);
        this.dispatchTargetComputer = dispatchTargetComputer;
        this.dispatchTargetReqs = dispatchTargetReqs;
        this.dispatchTargetIDs = (ImmutableSet)dispatchTargetReqs.stream().map(graph::getVajramIdByVajramReqType).collect(ImmutableSet.toImmutableSet());
    }

    public @Nullable VajramID getDispatchTargetID(@Nullable Dependency dependency, Request<?> request) {
        try {
            Class<Request<?>> dispatchTarget = this.dispatchTargetComputer.computeDispatchTarget(dependency, request);
            if (dispatchTarget == null) {
                return null;
            }
            return this.graph.getVajramIdByVajramReqType(dispatchTarget);
        }
        catch (ClassCastException e) {
            throw new AssertionError("Request type " + request.getClass() + " which is not a sub type of trait request type: " + this.traitReqType + ". This should not be possible. There seems to be a bug in the platform", e);
        }
    }

    public ImmutableSet<Class<? extends Request<?>>> dispatchTargetReqs() {
        return ImmutableSet.copyOf(this.dispatchTargetReqs);
    }

    @Generated
    public VajramID traitID() {
        return this.traitID;
    }

    @Generated
    public ImmutableSet<VajramID> dispatchTargetIDs() {
        return this.dispatchTargetIDs;
    }

    @FunctionalInterface
    public static interface DispatchTargetComputer<T extends Request<?>> {
        public @Nullable Class<? extends T> computeDispatchTarget(@Nullable Dependency var1, T var2);
    }
}

