/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.krystex.KrystalExecutor;
import com.flipkart.krystal.krystex.kryon.KryonExecutionConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.vajram.exec.VajramExecutor;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutorConfig;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KrystexVajramExecutor
implements VajramExecutor {
    private final VajramKryonGraph vajramKryonGraph;
    private final KrystalExecutor krystalExecutor;

    public KrystexVajramExecutor(@lombok.NonNull VajramKryonGraph vajramKryonGraph, @lombok.NonNull KrystexVajramExecutorConfig executorConfig) {
        if (vajramKryonGraph == null) {
            throw new NullPointerException("vajramKryonGraph is marked non-null but is null");
        }
        if (executorConfig == null) {
            throw new NullPointerException("executorConfig is marked non-null but is null");
        }
        this.vajramKryonGraph = vajramKryonGraph;
        this.krystalExecutor = new KryonExecutor(vajramKryonGraph.kryonDefinitionRegistry(), executorConfig.kryonExecutorConfigBuilder().configureWith(vajramKryonGraph.inputInjectionConfig()).configureWith(vajramKryonGraph.inputBatchingConfig()).build());
    }

    public <T> CompletableFuture<@Nullable T> execute(ImmutableRequest<T> request) {
        return this.execute(request, KryonExecutionConfig.builder().build());
    }

    public <T> CompletableFuture<@Nullable T> execute(ImmutableRequest<T> vajramRequest, KryonExecutionConfig executionConfig) {
        this.vajramKryonGraph.loadKryonSubGraphIfNeeded(vajramRequest._vajramID());
        return this.krystalExecutor.executeKryon(vajramRequest, executionConfig);
    }

    public KrystalExecutor getKrystalExecutor() {
        return this.krystalExecutor;
    }

    public void close() {
        this.krystalExecutor.close();
    }

    public void shutdownNow() {
        this.krystalExecutor.shutdownNow();
    }

    @Generated
    public static @NonNull KrystexVajramExecutorBuilder builder() {
        return new KrystexVajramExecutorBuilder();
    }

    @Generated
    public static class KrystexVajramExecutorBuilder {
        @Generated
        private VajramKryonGraph vajramKryonGraph;
        @Generated
        private KrystexVajramExecutorConfig executorConfig;

        @Generated
        KrystexVajramExecutorBuilder() {
        }

        @Generated
        public @NonNull KrystexVajramExecutorBuilder vajramKryonGraph(@lombok.NonNull VajramKryonGraph vajramKryonGraph) {
            if (vajramKryonGraph == null) {
                throw new NullPointerException("vajramKryonGraph is marked non-null but is null");
            }
            this.vajramKryonGraph = vajramKryonGraph;
            return this;
        }

        @Generated
        public @NonNull KrystexVajramExecutorBuilder executorConfig(@lombok.NonNull KrystexVajramExecutorConfig executorConfig) {
            if (executorConfig == null) {
                throw new NullPointerException("executorConfig is marked non-null but is null");
            }
            this.executorConfig = executorConfig;
            return this;
        }

        @Generated
        public @NonNull KrystexVajramExecutor build() {
            return new KrystexVajramExecutor(this.vajramKryonGraph, this.executorConfig);
        }

        @Generated
        public @NonNull String toString() {
            return "KrystexVajramExecutor.KrystexVajramExecutorBuilder(vajramKryonGraph=" + this.vajramKryonGraph + ", executorConfig=" + this.executorConfig + ")";
        }
    }
}

