/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.batching;

import com.flipkart.krystal.concurrent.Futures;
import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.config.NestedConfig;
import com.flipkart.krystal.core.OutputLogicExecutionInput;
import com.flipkart.krystal.core.OutputLogicExecutionResults;
import com.flipkart.krystal.data.ImmutableFacetValues;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.decoration.DecoratorCommand;
import com.flipkart.krystal.krystex.decoration.FlushCommand;
import com.flipkart.krystal.krystex.decoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.vajram.batching.BatchEnabledFacetValues;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.InputBatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public final class InputBatchingDecorator
implements OutputLogicDecorator {
    public static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String DECORATOR_TYPE = InputBatchingDecorator.class.getName();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String instanceId;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputBatcher inputBatcher;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Predicate<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependentChain> isApplicableToDependentChain;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableFacetValues, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object>> futureCache = new LinkedHashMap<ImmutableFacetValues, CompletableFuture<Object>>();
    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableSet<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependentChain> activeDependentChains = ImmutableSet.of();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependentChain> flushedDependentChains = new LinkedHashSet<DependentChain>();
    private @MonotonicNonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogicExecutionInput outputLogicExecutionInput;

    public InputBatchingDecorator(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String instanceId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputBatcher inputBatcher, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Predicate<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependentChain> isApplicableToDependentChain) {
        this.instanceId = instanceId;
        this.inputBatcher = inputBatcher;
        this.isApplicableToDependentChain = isApplicableToDependentChain;
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogic<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> decorateLogic(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogic<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogicDefinition<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> originalLogicDefinition) {
        this.inputBatcher.onBatching(requests -> requests.forEach(request -> this.batchFacetsList(logicToDecorate, (BatchedFacets)request)));
        return input -> {
            if (this.outputLogicExecutionInput == null) {
                this.outputLogicExecutionInput = input;
            }
            ImmutableList immutableFacetsList = (ImmutableList)input.facetValues().stream().map(f -> {
                if (f instanceof BatchEnabledFacetValues) {
                    BatchEnabledFacetValues bef = (BatchEnabledFacetValues)f;
                    return bef;
                }
                throw new IllegalStateException("Expected to receive instance of BatchEnabledFacetValues in batcher %s but received %s".formatted(this.instanceId, f));
            }).map(BatchEnabledFacetValues::_build).collect(ImmutableList.toImmutableList());
            List batchedFacetsList = immutableFacetsList.stream().map(arg_0 -> ((InputBatcher)this.inputBatcher).add(arg_0)).flatMap(Collection::stream).toList();
            input.facetValues().forEach(facetValues -> this.futureCache.computeIfAbsent(facetValues._build(), e -> new CompletableFuture()));
            for (BatchedFacets batchedFacets : batchedFacetsList) {
                this.batchFacetsList(logicToDecorate, batchedFacets);
            }
            return new OutputLogicExecutionResults((ImmutableMap)input.facetValues().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), key -> Objects.requireNonNullElseGet(this.futureCache.get(key._build()), CompletableFuture::new))));
        };
    }

    public void executeCommand(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DecoratorCommand decoratorCommand) {
        if (decoratorCommand instanceof InitiateActiveDepChains) {
            InitiateActiveDepChains initiateActiveDepChains = (InitiateActiveDepChains)decoratorCommand;
            LinkedHashSet<DependentChain> allActiveDepChains = new LinkedHashSet<DependentChain>((Collection<DependentChain>)initiateActiveDepChains.dependantsChains());
            allActiveDepChains.removeIf(this.isApplicableToDependentChain.negate());
            this.activeDependentChains = ImmutableSet.copyOf(allActiveDepChains);
        } else if (decoratorCommand instanceof FlushCommand) {
            FlushCommand flushCommand = (FlushCommand)decoratorCommand;
            this.flushedDependentChains.add(flushCommand.dependantsChain());
            if (this.flushedDependentChains.containsAll((Collection<?>)this.activeDependentChains)) {
                this.inputBatcher.batch();
                this.flushedDependentChains.clear();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void batchFacetsList(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogic<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BatchedFacets batchedFacets) {
        OutputLogicExecutionResults result;
        ImmutableList facetsList = batchedFacets.batchItems();
        if (this.outputLogicExecutionInput == null) {
            if (!facetsList.isEmpty()) throw new AssertionError((Object)"The decorateLogic was never invoked by facetsList is not empty. This should not be possible");
            result = new OutputLogicExecutionResults(ImmutableMap.of());
        } else {
            try {
                result = logicToDecorate.execute(this.outputLogicExecutionInput.withFacetValues((List)facetsList));
            }
            catch (Throwable e) {
                result = new OutputLogicExecutionResults((ImmutableMap)facetsList.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), i -> CompletableFuture.failedFuture(e))));
            }
        }
        result.results().forEach((inputs, resultFuture) -> Futures.linkFutures((CompletableFuture)resultFuture, (CompletableFuture)this.futureCache.computeIfAbsent(inputs._build(), request -> new CompletableFuture())));
    }

    public void onConfigUpdate(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ConfigProvider configProvider) {
        this.inputBatcher.onConfigUpdate((ConfigProvider)new NestedConfig(String.format("input_batching.%s.", this.instanceId), configProvider));
    }
}

