/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.krystex.node.MainLogic;
import com.flipkart.krystal.krystex.node.MainLogicDecorator;
import com.flipkart.krystal.krystex.node.MainLogicDefinition;
import com.flipkart.krystal.utils.Futures;
import com.flipkart.krystal.vajram.inputs.InputValuesAdaptor;
import com.flipkart.krystal.vajram.modulation.InputModulator;
import com.flipkart.krystal.vajram.modulation.InputsConverter;
import com.flipkart.krystal.vajram.modulation.ModulatedInput;
import com.flipkart.krystal.vajram.modulation.UnmodulatedInput;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class InputModulationDecorator<InputsNeedingModulation extends InputValuesAdaptor, CommonInputs extends InputValuesAdaptor, T>
implements MainLogicDecorator<T> {
    private final InputModulator<InputsNeedingModulation, CommonInputs> inputModulator;
    private final InputsConverter<InputsNeedingModulation, CommonInputs> inputsConverter;
    private final Map<Inputs, CompletableFuture<T>> futureCache = new HashMap<Inputs, CompletableFuture<T>>();

    public InputModulationDecorator(InputModulator<InputsNeedingModulation, CommonInputs> inputModulator, InputsConverter<InputsNeedingModulation, CommonInputs> inputsConverter) {
        this.inputModulator = inputModulator;
        this.inputsConverter = inputsConverter;
    }

    public MainLogic<T> decorateLogic(MainLogicDefinition<T> nodeDef, MainLogic<T> logicToDecorate) {
        this.inputModulator.onTermination(requests -> requests.forEach(request -> this.modulateInputsList(logicToDecorate, (ModulatedInput<InputsNeedingModulation, CommonInputs>)request)));
        return inputsList -> {
            List<CommonInputs> requests = inputsList.stream().map(this.inputsConverter).toList();
            List modulatedInputs = requests.stream().map(unmodulatedInput -> this.inputModulator.add((Object)unmodulatedInput.inputsNeedingModulation(), (Object)unmodulatedInput.commonInputs())).flatMap(Collection::stream).toList();
            requests.forEach(request -> this.futureCache.computeIfAbsent(request.toInputValues(), e -> new CompletableFuture()));
            for (ModulatedInput modulatedInput : modulatedInputs) {
                this.modulateInputsList(logicToDecorate, modulatedInput);
            }
            return (ImmutableMap)requests.stream().map(UnmodulatedInput::toInputValues).collect(ImmutableMap.toImmutableMap(Function.identity(), this.futureCache::get));
        };
    }

    private void modulateInputsList(MainLogic<T> logicToDecorate, ModulatedInput<InputsNeedingModulation, CommonInputs> modulatedInput) {
        ImmutableList requests = (ImmutableList)modulatedInput.inputsNeedingModulation().stream().map(each -> new UnmodulatedInput(each, (InputValuesAdaptor)modulatedInput.commonInputs())).collect(ImmutableList.toImmutableList());
        ImmutableMap originalFutures = logicToDecorate.execute((ImmutableList)requests.stream().map(UnmodulatedInput::toInputValues).collect(ImmutableList.toImmutableList()));
        originalFutures.forEach((inputs, resultFuture) -> {
            CompletableFuture cachedResult = this.futureCache.computeIfAbsent((Inputs)inputs, request -> new CompletableFuture());
            resultFuture.whenComplete((values, throwable) -> {
                if (values != null) {
                    cachedResult.complete(values);
                } else {
                    cachedResult.completeExceptionally((Throwable)throwable);
                }
            });
            Futures.propagateCancellation((CompletableFuture)cachedResult, (CompletableFuture)resultFuture);
        });
    }
}

