/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.ext.json.codegen;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.codegen.common.spi.ModelsCodeGenContext;
import com.flipkart.krystal.model.Model;
import com.flipkart.krystal.model.ModelRoot;
import com.flipkart.krystal.model.PlainJavaObject;
import com.flipkart.krystal.model.SupportedModelProtocols;
import com.flipkart.krystal.serial.SerializableModel;
import com.flipkart.krystal.vajram.json.Json;
import com.flipkart.krystal.vajram.json.SerializableJsonModel;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class JsonModelsGen
implements CodeGenerator {
    private final ModelsCodeGenContext codeGenContext;
    private final CodeGenUtility util;

    JsonModelsGen(ModelsCodeGenContext codeGenContext) {
        this.codeGenContext = codeGenContext;
        this.util = codeGenContext.util();
    }

    public void generate() {
        if (!this.isApplicable()) {
            return;
        }
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        CodeGenUtility util = this.codeGenContext.util();
        ClassName immutClassName = util.getImmutClassName(modelRootType);
        String packageName = immutClassName.packageName();
        String immutableModelName = immutClassName.simpleName();
        ClassName immutableJsonName = ClassName.get((String)packageName, (String)(immutableModelName + Json.JSON.modelClassesSuffix()), (String[])new String[0]);
        List modelMethods = util.extractAndValidateModelMethods(modelRootType);
        TypeSpec immutablePojo = this.generateJsonModel(packageName, modelRootType, modelMethods, immutClassName, immutableJsonName);
        util.writeJavaFile(packageName, immutablePojo, modelRootType);
    }

    private TypeSpec generateJsonModel(String packageName, TypeElement modelRootType, List<ExecutableElement> modelMethods, ClassName immutableModelName, ClassName immutableJsonModelName) {
        TypeSpec.Builder classBuilder = this.util.classBuilder(immutableJsonModelName.simpleName(), modelRootType.getQualifiedName().toString()).addAnnotation(AnnotationSpec.builder(JsonDeserialize.class).addMember("builder", "$T.class", new Object[]{immutableJsonModelName.nestedClass("Builder")}).build());
        ClassName immutablePojoName = ClassName.get((String)packageName, (String)(immutableModelName.simpleName() + PlainJavaObject.POJO.modelClassesSuffix()), (String[])new String[0]);
        ArrayTypeName byteArrayType = ArrayTypeName.of((TypeName)TypeName.BYTE);
        classBuilder.addField(FieldSpec.builder(ObjectReader.class, (String)"_READER", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.OBJECT_READER.forType($T.class)", new Object[]{Json.class, immutableJsonModelName}).build());
        classBuilder.addField(FieldSpec.builder(ObjectWriter.class, (String)"_WRITER", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.OBJECT_WRITER.forType($T.class)", new Object[]{Json.class, immutableJsonModelName}).build());
        classBuilder.addField(FieldSpec.builder((TypeName)immutablePojoName, (String)"_pojo", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        classBuilder.addField(FieldSpec.builder((TypeName)byteArrayType, (String)"_serializedPayload", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(JsonIgnore.class).build());
        classBuilder.addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethod(SerializableModel.class, "_serialize", 0)).addException(JsonProcessingException.class).addCode("if (_serializedPayload == null) {\n  this._serializedPayload = _WRITER.writeValueAsBytes(this);\n}\nreturn _serializedPayload;\n", new Object[0]).build());
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        for (ExecutableElement method : modelMethods) {
            String methodName = method.getSimpleName().toString();
            methods.add(MethodSpec.methodBuilder((String)methodName).addAnnotation(JsonProperty.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)method.getReturnType())).addStatement("return _pojo().$L()", new Object[]{methodName}).build());
        }
        methods.addAll(JsonModelsGen.commonMethods(immutableJsonModelName));
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_pojo").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)immutablePojoName).addCode("        if (_pojo == null && _serializedPayload != null) {\n          try{\n            _pojo = _READER.readValue(_serializedPayload, $T.class)._pojo();\n          } catch (Exception e) {\n            throw new RuntimeException(\"Failed to deserialize json bytes\", e);\n          }\n        } else if (_pojo == null) {\n          throw new IllegalStateException(\"Both _pojo and _serializedPayload are null\");\n        }\n        return _pojo;\n", new Object[]{immutableJsonModelName}).build());
        TypeSpec builderClass = this.generateBuilderClass(modelRootType, modelMethods, immutableModelName, immutableJsonModelName);
        this.util.addImmutableModelObjectMethods(immutableModelName, modelMethods.stream().map(ExecutableElement::getSimpleName).collect(Collectors.toSet()), classBuilder);
        return classBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)immutableModelName).addSuperinterface(SerializableJsonModel.class).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)immutablePojoName, "_pojo", new Modifier[0]).addStatement("this._pojo = _pojo", new Object[0]).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)byteArrayType, "_serializedPayload", new Modifier[0]).addStatement("this._serializedPayload = _serializedPayload", new Object[0]).addStatement("this._pojo = null", new Object[0]).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)byteArrayType, "_serializedPayload", new Modifier[0]).addParameter((TypeName)immutablePojoName, "_pojo", new Modifier[0]).addStatement("this._serializedPayload = _serializedPayload", new Object[0]).addStatement("this._pojo = _pojo", new Object[0]).build()).addMethods(methods).addType(builderClass).build();
    }

    private static List<MethodSpec> commonMethods(ClassName immutableJsonModelName) {
        MethodSpec.Builder asBuilderMethodBuilder = MethodSpec.methodBuilder((String)"_asBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)immutableJsonModelName.nestedClass("Builder")).addStatement("return new $T(_pojo()._asBuilder())", new Object[]{immutableJsonModelName.nestedClass("Builder")});
        MethodSpec builderMethod = MethodSpec.methodBuilder((String)"_builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)immutableJsonModelName.nestedClass("Builder")).addStatement("return new $T()", new Object[]{immutableJsonModelName.nestedClass("Builder")}).build();
        return List.of(asBuilderMethodBuilder.build(), builderMethod, MethodSpec.methodBuilder((String)"_newCopy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)immutableJsonModelName).addCode("if(_serializedPayload != null && _pojo != null ) {\n  return new $T(_serializedPayload, _pojo);\n} else if(_serializedPayload != null) {\n  return new $T(_serializedPayload);\n} else if(_pojo != null){\n  return new $T(_pojo);\n} else {\n  throw new $T(\"Both _pojo and _serializedPayload are null\");\n}\n", new Object[]{immutableJsonModelName, immutableJsonModelName, immutableJsonModelName, IllegalStateException.class}).build());
    }

    private TypeSpec generateBuilderClass(TypeElement modelRootType, List<ExecutableElement> modelMethods, ClassName immutableModelName, ClassName immutableJsonName) {
        TypeSpec.Builder builderSpec = this.util.classBuilder("Builder", modelRootType.getQualifiedName().toString()).addAnnotation(AnnotationSpec.builder(JsonPOJOBuilder.class).addMember("buildMethodName", "$S", new Object[]{"_build"}).addMember("withPrefix", "$S", new Object[]{""}).build());
        ModelRoot modelRoot = modelRootType.getAnnotation(ModelRoot.class);
        ClassName immutablePojoName = ClassName.get((String)immutableJsonName.packageName(), (String)(immutableModelName.simpleName() + PlainJavaObject.POJO.modelClassesSuffix()), (String[])new String[0]);
        builderSpec.addField(FieldSpec.builder((TypeName)immutablePojoName.nestedClass("Builder"), (String)"_pojo", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        builderSpec.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("this._pojo = $T._builder()", new Object[]{immutablePojoName}).build());
        builderSpec.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)immutablePojoName.nestedClass("Builder"), "_pojo", new Modifier[0]).addStatement("this._pojo = _pojo", new Object[0]).build());
        ArrayList<MethodSpec> dataAccessMethods = new ArrayList<MethodSpec>();
        for (ExecutableElement method : modelMethods) {
            String methodName = method.getSimpleName().toString();
            dataAccessMethods.add(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.util.getParameterType(method, true), methodName, new Modifier[0]).returns((TypeName)immutableJsonName.nestedClass("Builder")).addStatement("this._pojo.$L($L)", new Object[]{methodName, methodName}).addStatement("return this", new Object[0]).addAnnotation(Override.class).build());
            if (!modelRoot.builderExtendsModelRoot()) continue;
            dataAccessMethods.add(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)method.getReturnType())).addStatement("return _pojo.$L()", new Object[]{methodName}).build());
        }
        MethodSpec.Builder buildMethodBuilder = MethodSpec.methodBuilder((String)"_build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)immutableJsonName).addStatement("return new $T(_pojo._build())", new Object[]{immutableJsonName}).addAnnotation(Override.class);
        MethodSpec.Builder builderCopyMethodBuilder = MethodSpec.methodBuilder((String)"_newCopy").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)immutableJsonName.nestedClass("Builder")).addStatement("return new $T(_pojo._newCopy())", new Object[]{immutableJsonName.nestedClass("Builder")});
        return builderSpec.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addSuperinterface((TypeName)immutableModelName.nestedClass("Builder")).addMethods(dataAccessMethods).addMethod(buildMethodBuilder.build()).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethod(Model.class, "_asBuilder", 0)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)immutableJsonName.nestedClass("Builder")).addStatement("return this", new Object[0]).build()).addMethod(builderCopyMethodBuilder.build()).build();
    }

    private boolean isApplicable() {
        return CodegenPhase.MODELS.equals((Object)this.codeGenContext.codegenPhase()) && this.isJsonSerdeSupported();
    }

    private boolean isJsonSerdeSupported() {
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        SupportedModelProtocols supportedModelProtocols = modelRootType.getAnnotation(SupportedModelProtocols.class);
        if (supportedModelProtocols == null) {
            return false;
        }
        return this.util.getTypesFromAnnotationMember(() -> ((SupportedModelProtocols)supportedModelProtocols).value()).stream().map(typeMirror -> this.util.processingEnv().getTypeUtils().asElement((TypeMirror)typeMirror)).filter(elem -> elem instanceof QualifiedNameable).map(element -> Objects.requireNonNull((QualifiedNameable)element).getQualifiedName().toString()).anyMatch(Json.class.getCanonicalName()::equals);
    }
}

