/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.facets.resolution;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolverSpec;
import com.flipkart.krystal.vajram.facets.resolution.SkipPredicate;
import com.flipkart.krystal.vajram.facets.resolution.Transformer;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class OptionalSingleValTransformResolverStage<S, T, CV extends Request, DV extends Request> {
    private final InputMirrorSpec<T, DV> targetInput;
    private final FacetSpec<S, CV> sourceInput;
    private final List<SkipPredicate> skipConditions = new ArrayList<SkipPredicate>();

    OptionalSingleValTransformResolverStage(InputMirrorSpec<T, DV> targetInput, FacetSpec<S, CV> sourceInput) {
        this.targetInput = targetInput;
        this.sourceInput = sourceInput;
    }

    public OptionalSingleValTransformResolverStage<S, T, CV, DV> skipIf(Predicate<Errable<S>> whenToSkip, String reason) {
        this.skipConditions.add(new SkipPredicate(reason, facetValue -> whenToSkip.test(((FacetValue.SingleFacetValue)facetValue).asErrable())));
        return this;
    }

    public SimpleInputResolverSpec<T, CV, DV> asResolver(Function<Errable<S>, @Nullable T> transformer) {
        return new SimpleInputResolverSpec<T, CV, DV>(this.targetInput, this.sourceInput, this.skipConditions, new Transformer.One2One(facetValue -> transformer.apply(facetValue.asErrable())));
    }
}

