/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.exec;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.BasicFacetInfo;
import com.flipkart.krystal.facets.InputMirror;
import com.flipkart.krystal.facets.resolution.ResolverDefinition;
import com.flipkart.krystal.tags.ElementTags;
import com.flipkart.krystal.vajram.Trait;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.exec.VajramMetadata;
import com.flipkart.krystal.vajram.exec.Vajrams;
import com.flipkart.krystal.vajram.facets.resolution.InputResolver;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VajramDefinition {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VajramDefinition.class);
    private final VajramDefRoot<Object> def;
    private final Class<? extends VajramDefRoot<?>> defType;
    private final Class<? extends Request<?>> reqRootType;
    private final ImmutableMap<ResolverDefinition, InputResolver> inputResolvers;
    private final ElementTags outputLogicTags;
    private final ElementTags vajramTags;
    private final VajramMetadata metadata;
    private final VajramID vajramId;
    private final ImmutableSet<FacetSpec> outputLogicSources;
    private final ImmutableSet<FacetSpec> facetSpecs;
    private final ImmutableSet<InputMirror> inputMirrors;
    private final ImmutableMap<String, FacetSpec> facetsByName;
    private final ImmutableMap<Integer, FacetSpec> facetsById;

    public VajramDefinition(VajramDefRoot<Object> vajramDefRoot) {
        ImmutableSet immutableSet;
        this.vajramId = Vajrams.parseVajramId(vajramDefRoot);
        this.def = vajramDefRoot;
        this.defType = Vajrams.getVajramDefClass(vajramDefRoot.getClass());
        this.reqRootType = vajramDefRoot.requestRootType();
        if (vajramDefRoot instanceof VajramDef) {
            VajramDef v = (VajramDef)vajramDefRoot;
            immutableSet = (ImmutableSet)v.facetsFromRequest((Request<?>)vajramDefRoot.newRequestBuilder())._facets().stream().map(facetDefinition -> (FacetSpec)facetDefinition).collect(ImmutableSet.toImmutableSet());
        } else {
            immutableSet = ImmutableSet.of();
        }
        this.facetSpecs = immutableSet;
        this.inputMirrors = ImmutableSet.copyOf((Collection)vajramDefRoot.newRequestBuilder()._facets());
        this.facetsByName = (ImmutableMap)this.facetSpecs.stream().collect(ImmutableMap.toImmutableMap(BasicFacetInfo::name, Function.identity()));
        this.facetsById = (ImmutableMap)this.facetSpecs.stream().collect(ImmutableMap.toImmutableMap(BasicFacetInfo::id, Function.identity()));
        this.outputLogicTags = Vajrams.parseOutputLogicTags(vajramDefRoot);
        this.vajramTags = Vajrams.parseVajramTags(vajramDefRoot);
        this.outputLogicSources = Vajrams.parseOutputLogicSources(vajramDefRoot, this.facetSpecs, this.facetsByName);
        this.inputResolvers = Vajrams.parseInputResolvers(vajramDefRoot);
        this.metadata = new VajramMetadata(this.facetSpecs);
    }

    public boolean isTrait() {
        return this.vajramTags().getAnnotationByType(Trait.class).isPresent();
    }

    @Generated
    public VajramDefRoot<Object> def() {
        return this.def;
    }

    @Generated
    public Class<? extends VajramDefRoot<?>> defType() {
        return this.defType;
    }

    @Generated
    public Class<? extends Request<?>> reqRootType() {
        return this.reqRootType;
    }

    @Generated
    public ImmutableMap<ResolverDefinition, InputResolver> inputResolvers() {
        return this.inputResolvers;
    }

    @Generated
    public ElementTags outputLogicTags() {
        return this.outputLogicTags;
    }

    @Generated
    public ElementTags vajramTags() {
        return this.vajramTags;
    }

    @Generated
    public VajramMetadata metadata() {
        return this.metadata;
    }

    @Generated
    public VajramID vajramId() {
        return this.vajramId;
    }

    @Generated
    public ImmutableSet<FacetSpec> outputLogicSources() {
        return this.outputLogicSources;
    }

    @Generated
    public ImmutableSet<FacetSpec> facetSpecs() {
        return this.facetSpecs;
    }

    @Generated
    public ImmutableSet<InputMirror> inputMirrors() {
        return this.inputMirrors;
    }

    @Generated
    public ImmutableMap<String, FacetSpec> facetsByName() {
        return this.facetsByName;
    }

    @Generated
    public ImmutableMap<Integer, FacetSpec> facetsById() {
        return this.facetsById;
    }
}

