/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.exec;

import com.flipkart.krystal.annos.ComputeDelegationMode;
import com.flipkart.krystal.annos.OutputLogicDelegationMode;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.facets.resolution.ResolverDefinition;
import com.flipkart.krystal.tags.ElementTags;
import com.flipkart.krystal.vajram.ComputeVajramDef;
import com.flipkart.krystal.vajram.IOVajramDef;
import com.flipkart.krystal.vajram.Trait;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.facets.Output;
import com.flipkart.krystal.vajram.facets.resolution.InputResolver;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Vajrams {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Vajrams.class);

    static Class<? extends VajramDefRoot<?>> getVajramDefClass(Class<? extends VajramDefRoot> aClass) {
        Class<? extends VajramDefRoot<?>> result = Vajrams._getVajramDefClass(aClass);
        if (result == null) {
            throw new IllegalArgumentException("@Vajram or @VajramTrait annotation missing in type hierarchy of " + String.valueOf(aClass));
        }
        return result;
    }

    static VajramID parseVajramId(VajramDefRoot<?> vajramDef) {
        return VajramID.vajramID((String)Vajrams.getVajramDefClass(vajramDef.getClass()).getSimpleName());
    }

    static ElementTags parseVajramTags(VajramDefRoot<?> vajramDef) {
        return ElementTags.of(Arrays.stream(Vajrams.getVajramDefClass(vajramDef.getClass()).getAnnotations()).flatMap(a -> Vajrams.enrich(a, vajramDef)).toList());
    }

    static ImmutableMap<ResolverDefinition, InputResolver> parseInputResolvers(VajramDefRoot<?> vajramDef) {
        ImmutableMap immutableMap;
        if (vajramDef instanceof VajramDef) {
            VajramDef v = (VajramDef)vajramDef;
            immutableMap = (ImmutableMap)v.getInputResolvers().stream().collect(ImmutableMap.toImmutableMap(InputResolver::definition, Function.identity()));
        } else {
            immutableMap = ImmutableMap.of();
        }
        return immutableMap;
    }

    private static Optional<FacetSpec> inferFacetId(Parameter parameter, ImmutableMap<String, FacetSpec> facetsByName) {
        FacetSpec facetSpec = (FacetSpec)facetsByName.get((Object)parameter.getName());
        if (facetSpec == null) {
            return Optional.empty();
        }
        return Optional.of(facetSpec);
    }

    static ElementTags parseOutputLogicTags(VajramDefRoot<?> vajramDef) {
        ElementTags elementTags;
        if (vajramDef instanceof VajramDef) {
            VajramDef v = (VajramDef)vajramDef;
            elementTags = ElementTags.of(Arrays.stream(Vajrams.getVajramDefClass(v.getClass()).getDeclaredMethods()).filter(Vajrams::isOutputMethod).findFirst().stream().flatMap(method -> Arrays.stream(method.getAnnotations())).toList());
        } else {
            elementTags = ElementTags.emptyTags();
        }
        return elementTags;
    }

    private static boolean isOutputMethod(Method method) {
        return method.getAnnotation(Output.class) != null || method.getAnnotation(Output.Batched.class) != null;
    }

    private static Stream<Annotation> enrich(Annotation annotation, VajramDefRoot<?> vajramDefRoot) {
        ArrayList<OutputLogicDelegationMode> inferredAnnos = new ArrayList<OutputLogicDelegationMode>();
        if (annotation instanceof Vajram && vajramDefRoot instanceof VajramDef) {
            VajramDef vajramDef = (VajramDef)vajramDefRoot;
            inferredAnnos.add(OutputLogicDelegationMode.Creator.create((ComputeDelegationMode)Vajrams.getComputeDelegationType(vajramDef)));
        }
        return Stream.concat(Stream.of(annotation), inferredAnnos.stream());
    }

    private static ComputeDelegationMode getComputeDelegationType(VajramDef<?> vajramDef) {
        if (vajramDef instanceof ComputeVajramDef) {
            return ComputeDelegationMode.NONE;
        }
        if (vajramDef instanceof IOVajramDef) {
            return ComputeDelegationMode.SYNC;
        }
        throw new IllegalStateException("Unable infer compute delegation type of vajram %s".formatted(vajramDef.getClass()));
    }

    private static @Nullable Class<? extends VajramDefRoot<?>> _getVajramDefClass(Class<?> aClass) {
        if (!VajramDefRoot.class.isAssignableFrom(aClass)) {
            return null;
        }
        Annotation annotation = aClass.getAnnotation(Vajram.class);
        if (annotation == null) {
            annotation = aClass.getAnnotation(Trait.class);
        }
        if (annotation != null) {
            return aClass;
        }
        ArrayList superTypes = new ArrayList(Arrays.asList(aClass.getInterfaces()));
        Class<?> superclass = aClass.getSuperclass();
        if (!Object.class.equals(superclass) && superclass != null) {
            superTypes.add(superclass);
        }
        for (Class clazz : superTypes) {
            Class<? extends VajramDefRoot<?>> result = Vajrams._getVajramDefClass(clazz);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static ImmutableSet<FacetSpec> parseOutputLogicSources(VajramDefRoot<?> vajramDefRoot, ImmutableSet<FacetSpec> facetSpecs, ImmutableMap<String, FacetSpec> facetsByName) {
        Optional<Method> outputLogicMethod = Arrays.stream(Vajrams.getVajramDefClass(vajramDefRoot.getClass()).getDeclaredMethods()).filter(Vajrams::isOutputMethod).findFirst();
        if (outputLogicMethod.isEmpty()) {
            return ImmutableSet.of();
        }
        Parameter[] outputLogicParams = outputLogicMethod.get().getParameters();
        ImmutableSet.Builder facetIds = ImmutableSet.builder();
        facetSpecs.stream().filter(FacetSpec::isBatched).forEach(arg_0 -> ((ImmutableSet.Builder)facetIds).add(arg_0));
        for (Parameter param : outputLogicParams) {
            Vajrams.inferFacetId(param, facetsByName).ifPresent(arg_0 -> ((ImmutableSet.Builder)facetIds).add(arg_0));
        }
        return facetIds.build();
    }

    @Generated
    private Vajrams() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

