/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.facets.resolution;

import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.vajram.facets.resolution.InputResolverUtil;
import com.flipkart.krystal.vajram.facets.resolution.ResolveFanoutStage;
import com.flipkart.krystal.vajram.facets.resolution.ResolveStage;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolverSpec;
import com.flipkart.krystal.vajram.facets.specs.DependencySpec;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public final class InputResolvers {
    @SafeVarargs
    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent SimpleInputResolver> resolve(List<? extends SimpleInputResolver> ... inputResolvers) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List<? extends SimpleInputResolver> inputResolver : inputResolvers) {
            builder.addAll(inputResolver);
        }
        return builder.build();
    }

    @SafeVarargs
    public static <T, CV extends Request, DV extends Request<T>> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent SimpleInputResolver> dep(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependencySpec<T, CV, DV> dependency, SimpleInputResolverSpec<?, CV, DV> ... resolverStages) {
        return Arrays.stream(resolverStages).map(spec -> InputResolverUtil.toResolver(dependency, spec)).toList();
    }

    public static <I, T, DV extends Request<T>> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ResolveStage<I, T, DV> depInput(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirrorSpec<I, DV> depInput) {
        return new ResolveStage(depInput);
    }

    public static <T, DV extends Request<?>> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ResolveFanoutStage<T, DV> depInputFanout(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirrorSpec<T, DV> depInput) {
        return new ResolveFanoutStage<T, DV>(depInput);
    }

    private InputResolvers() {
    }
}

