/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.utils;

import com.flipkart.krystal.vajram.VajramDefRoot;
import java.lang.reflect.Modifier;
import java.util.List;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class VajramLoader {
    public static List<? extends VajramDefRoot<Object>> loadVajramsFromClassPath(String packagePrefix) {
        return new Reflections(packagePrefix, new Scanner[0]).getSubTypesOf(VajramDefRoot.class).stream().filter(c -> Modifier.isFinal(c.getModifiers())).map(VajramLoader::initVajram).toList();
    }

    public static VajramDefRoot<Object> loadVajramsFromClass(Class<? extends VajramDefRoot<?>> clazz) {
        List<Class> impls = new Reflections(clazz.getPackageName(), new Scanner[0]).getSubTypesOf(clazz).stream().filter(subclass -> Modifier.isFinal(subclass.getModifiers())).map(subType -> subType.asSubclass(VajramDefRoot.class)).toList();
        if (impls.size() > 1) {
            throw new IllegalArgumentException("Multiple Vajram Impl found in the package '%s' of the provided class: %s".formatted(clazz.getPackageName(), impls));
        }
        if (impls.isEmpty()) {
            throw new IllegalArgumentException("No Vajram Impl found in the package '%s' of the provided class".formatted(clazz.getPackageName()));
        }
        return VajramLoader.initVajram(impls.get(0));
    }

    private static VajramDefRoot<Object> initVajram(Class<? extends VajramDefRoot> aClass) {
        if (!Modifier.isFinal(aClass.getModifiers())) {
            throw new RuntimeException("Provided Vajram impl class should be final");
        }
        try {
            return aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private VajramLoader() {
    }
}

