/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.facets.resolution;

import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.vajram.facets.resolution.InputResolverUtil;
import com.flipkart.krystal.vajram.facets.resolution.ResolveFanoutStage;
import com.flipkart.krystal.vajram.facets.resolution.ResolveStage;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolverSpec;
import com.flipkart.krystal.vajram.facets.specs.DependencySpec;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;

public final class InputResolvers {
    @SafeVarargs
    public static ImmutableList<SimpleInputResolver> resolve(List<? extends SimpleInputResolver> ... inputResolvers) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List<? extends SimpleInputResolver> inputResolver : inputResolvers) {
            builder.addAll(inputResolver);
        }
        return builder.build();
    }

    @SafeVarargs
    public static <T, CV extends Request, DV extends Request<T>> List<? extends SimpleInputResolver> dep(DependencySpec<T, CV, DV> dependency, SimpleInputResolverSpec<?, CV, DV> ... resolverStages) {
        return Arrays.stream(resolverStages).map(spec -> InputResolverUtil.toResolver(dependency, spec)).toList();
    }

    public static <I, T, DV extends Request<T>> ResolveStage<I, T, DV> depInput(InputMirrorSpec<I, DV> depInput) {
        return new ResolveStage(depInput);
    }

    public static <T, DV extends Request<?>> ResolveFanoutStage<T, DV> depInputFanout(InputMirrorSpec<T, DV> depInput) {
        return new ResolveFanoutStage<T, DV>(depInput);
    }

    private InputResolvers() {
    }
}

