/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.exec;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.facets.resolution.ResolverDefinition;
import com.flipkart.krystal.tags.ElementTags;
import com.flipkart.krystal.vajram.ComputeDelegationMode;
import com.flipkart.krystal.vajram.ComputeVajramDef;
import com.flipkart.krystal.vajram.IOVajramDef;
import com.flipkart.krystal.vajram.Trait;
import com.flipkart.krystal.vajram.TraitDef;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.annos.OutputLogicDelegationMode;
import com.flipkart.krystal.vajram.annos.VajramIdentifier;
import com.flipkart.krystal.vajram.facets.Output;
import com.flipkart.krystal.vajram.facets.resolution.InputResolver;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Vajrams {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Vajrams.class);

    static Class<? extends VajramDefRoot<?>> getVajramDefClass(Class<? extends VajramDefRoot> aClass) {
        return Vajrams._getVajramDefClass(aClass);
    }

    static VajramID parseVajramId(VajramDefRoot<?> vajramDef) {
        return VajramID.vajramID((String)Vajrams.getVajramDefClass(vajramDef.getClass()).getSimpleName());
    }

    static ElementTags parseVajramTags(VajramID inferredVajramId, VajramDefRoot<?> vajramDef) {
        return ElementTags.of(Arrays.stream(Vajrams.getVajramDefClass(vajramDef.getClass()).getAnnotations()).flatMap(a -> Vajrams.enrich(a, inferredVajramId, vajramDef)).toList());
    }

    static ImmutableMap<ResolverDefinition, InputResolver> parseInputResolvers(VajramDefRoot<?> vajramDef) {
        ImmutableMap immutableMap;
        if (vajramDef instanceof VajramDef) {
            VajramDef v = (VajramDef)vajramDef;
            immutableMap = (ImmutableMap)v.getInputResolvers().stream().collect(ImmutableMap.toImmutableMap(InputResolver::definition, Function.identity()));
        } else {
            immutableMap = ImmutableMap.of();
        }
        return immutableMap;
    }

    private static FacetSpec inferFacetId(Parameter parameter, ImmutableMap<String, FacetSpec> facetsByName, VajramDefRoot<?> vajramDef) {
        FacetSpec facetSpec = (FacetSpec)facetsByName.get((Object)parameter.getName());
        if (facetSpec == null) {
            throw new IllegalArgumentException("Unable to infer facet id for parameter %s of vajram %s".formatted(parameter.getName(), vajramDef.getClass()));
        }
        return facetSpec;
    }

    static ElementTags parseOutputLogicTags(VajramDefRoot<?> vajramDef) {
        ElementTags elementTags;
        if (vajramDef instanceof VajramDef) {
            VajramDef v = (VajramDef)vajramDef;
            elementTags = ElementTags.of(Arrays.stream(Vajrams.getVajramDefClass(v.getClass()).getDeclaredMethods()).filter(method -> method.getAnnotation(Output.class) != null).findFirst().stream().flatMap(method -> Arrays.stream(method.getAnnotations())).toList());
        } else {
            elementTags = ElementTags.emptyTags();
        }
        return elementTags;
    }

    private static Stream<Annotation> enrich(Annotation annotation, VajramID inferredVajramId, VajramDefRoot<?> vajramDefRoot) {
        ArrayList<Annotation> inferredAnnos = new ArrayList<Annotation>();
        if (annotation instanceof Vajram && vajramDefRoot instanceof VajramDef) {
            VajramDef vajramDef = (VajramDef)vajramDefRoot;
            inferredAnnos.add(VajramIdentifier.Creator.create(inferredVajramId.id()));
            inferredAnnos.add(OutputLogicDelegationMode.Creator.create(Vajrams.getComputeDelegationType(vajramDef)));
        }
        return Stream.concat(Stream.of(annotation), inferredAnnos.stream());
    }

    private static ComputeDelegationMode getComputeDelegationType(VajramDef<?> vajramDef) {
        if (vajramDef instanceof ComputeVajramDef) {
            return ComputeDelegationMode.NONE;
        }
        if (vajramDef instanceof IOVajramDef) {
            return ComputeDelegationMode.SYNC;
        }
        throw new IllegalStateException("Unable infer compute delegation type of vajram %s".formatted(vajramDef.getClass()));
    }

    private static Class<? extends VajramDefRoot<?>> _getVajramDefClass(Class<?> aClass) {
        if (!VajramDef.class.isAssignableFrom(aClass) && !TraitDef.class.isAssignableFrom(aClass)) {
            throw new IllegalArgumentException("@Vajram or @VajramTrait annotation missing.");
        }
        Annotation annotation = aClass.getAnnotation(Vajram.class);
        if (annotation == null) {
            annotation = aClass.getAnnotation(Trait.class);
        }
        if (annotation != null) {
            return aClass;
        }
        Class<?> superclass = aClass.getSuperclass();
        if (Object.class.equals(superclass) || superclass == null) {
            throw new IllegalArgumentException("@Vajram or @VajramTrait annotation missing.");
        }
        return Vajrams._getVajramDefClass(superclass);
    }

    static ImmutableSet<FacetSpec> parseOutputLogicSources(VajramDefRoot<?> vajramDefRoot, ImmutableSet<FacetSpec> facetSpecs, ImmutableMap<String, FacetSpec> facetsByName) {
        Optional<Method> outputLogicMethod = Arrays.stream(Vajrams.getVajramDefClass(vajramDefRoot.getClass()).getDeclaredMethods()).filter(method -> method.getAnnotation(Output.class) != null).findFirst();
        if (outputLogicMethod.isEmpty()) {
            return ImmutableSet.of();
        }
        if (facetSpecs.stream().noneMatch(FacetSpec::isBatched)) {
            Parameter[] outputLogicParams = outputLogicMethod.get().getParameters();
            ImmutableSet.Builder facetIds = ImmutableSet.builder();
            for (Parameter param : outputLogicParams) {
                facetIds.add((Object)Vajrams.inferFacetId(param, facetsByName, vajramDefRoot));
            }
            return facetIds.build();
        }
        return facetSpecs;
    }

    @Generated
    private Vajrams() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

