/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.facets.resolution;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.NonNil;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.data.RequestResponse;
import com.flipkart.krystal.facets.resolution.ResolverCommand;
import com.flipkart.krystal.vajram.facets.DependencyCommand;
import com.flipkart.krystal.vajram.facets.FanoutCommand;
import com.flipkart.krystal.vajram.facets.One2OneCommand;
import com.flipkart.krystal.vajram.facets.resolution.SimpleFanoutInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolverSpec;
import com.flipkart.krystal.vajram.facets.resolution.SimpleOne2OneInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.SkipPredicate;
import com.flipkart.krystal.vajram.facets.resolution.Transformer;
import com.flipkart.krystal.vajram.facets.specs.DefaultFacetSpec;
import com.flipkart.krystal.vajram.facets.specs.DependencySpec;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajram.facets.specs.FanoutDepSpec;
import com.flipkart.krystal.vajram.facets.specs.One2OneDepSpec;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.aliasing.qual.NonLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public final class InputResolverUtil {
    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ResolverCommand toResolverCommand(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependencyCommand<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableRequest.Builder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> dependencyCommand) {
        if (dependencyCommand.shouldSkip()) {
            return ResolverCommand.skip((String)dependencyCommand.doc(), (Throwable)dependencyCommand.skipCause());
        }
        return ResolverCommand.executeWithRequests(dependencyCommand.inputs());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependencyCommand<T> handleResolverException(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Throwable e, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean fanout) {
        return InputResolverUtil.handleResolverException(e, fanout, "Resolver threw exception.");
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependencyCommand<T> handleResolverException(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Throwable e, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean fanout, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String messagePrefix) {
        Record command = fanout ? FanoutCommand.skipFanout(messagePrefix, e) : One2OneCommand.skipExecution(messagePrefix, e);
        return command;
    }

    static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependencyCommand<T> _resolutionHelper(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @MaybeLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> sourceInputs, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Transformer transformer, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent SkipPredicate> skipPredicates, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetValues facetValues) {
        boolean fanout = transformer instanceof Transformer.Fanout;
        ArrayList<Errable> inputValues = new ArrayList<Errable>();
        for (FacetSpec<?, ?> sourceInput : sourceInputs) {
            Errable inputValue;
            if (sourceInput instanceof One2OneDepSpec) {
                One2OneDepSpec depSpec = (One2OneDepSpec)sourceInput;
                inputValue = depSpec.getFacetValue(facetValues).response();
            } else if (sourceInput instanceof FanoutDepSpec) {
                FanoutDepSpec depSpec = (FanoutDepSpec)sourceInput;
                inputValue = Errable.withValue(depSpec.getFacetValue(facetValues).requestResponsePairs().stream().map(RequestResponse::response).filter(e -> e instanceof NonNil).map(e -> (NonNil)e).map(NonNil::value).toList());
            } else if (sourceInput instanceof DefaultFacetSpec) {
                DefaultFacetSpec defaultSpec = (DefaultFacetSpec)sourceInput;
                inputValue = defaultSpec.getFacetValue(facetValues);
            } else {
                throw new UnsupportedOperationException("Unknown facet type " + sourceInput.getClass());
            }
            inputValues.add(inputValue);
        }
        Optional<SkipPredicate> skipPredicate = skipPredicates.stream().map(p -> p).filter(sSkipPredicate -> sSkipPredicate.condition().test(inputValues)).findFirst();
        if (skipPredicate.isPresent()) {
            if (fanout) {
                return FanoutCommand.skipFanout(skipPredicate.get().reason());
            }
            return One2OneCommand.skipExecution(skipPredicate.get().reason());
        }
        Optional transformedInput = Optional.ofNullable(transformer.apply(inputValues));
        if (fanout) {
            FanoutCommand fanoutCommand = FanoutCommand.executeFanoutWith((Collection)transformedInput.map(ts -> ((Collection)ts).stream()).stream().flatMap(Function.identity()).collect(ImmutableList.toImmutableList()));
            return fanoutCommand;
        }
        One2OneCommand<Object> tOne2OneCommand = One2OneCommand.executeWith(transformedInput.orElse(null));
        return tOne2OneCommand;
    }

    public static <T, CV extends Request<?>, DV extends Request<T>> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent SimpleInputResolver toResolver(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependencySpec<T, CV, DV> dependency, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent SimpleInputResolverSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?, CV, DV> spec) {
        if (spec.canFanout()) {
            return new SimpleFanoutInputResolver(dependency, spec);
        }
        return new SimpleOne2OneInputResolver(dependency, spec);
    }

    private InputResolverUtil() {
    }
}

