package com.flipkart.krystal.vajram.batching;

import com.flipkart.krystal.vajram.IOVajram;

/**
 * A facet with this annotation is batched using an {@link InputBatcher} . This annotation can only
 * be used in {@link IOVajram}s. When an facet is marked as batched, the execution runtime invokes
 * the Output Logic of the IOVajram once for multiple requests by batching them into a collection.
 * This allows application developers to perform delegation operations like network IO, disk IO etc.
 * in an optimal fashion by batching the processing of multiple requests into a single IO operation.
 * This gives signinficant performance gains. Consequently, the application developers are expected
 * to return multiple results from the output logic (one each for each request in the batch) as a
 * map where the value is the response corresponding to one request and the key is an object which
 * contains all the batch inputs (this class is auto-generated by the vajram code generator)
 */
public @interface Batch {

  /**
   * Only Batch facets which have this field as {@code true} will be accessible in the output logic
   * of the IOVajram as part of the Batch Facets class. The Batch facets which are have this field
   * set as false indicate that they are directly or indirectly used to compute the Batch facets For
   * Output Logic, but are not accessed by the output logic directly.
   *
   * @return
   */
  boolean forOutputLogic() default false;
}
