/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.utils;

import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.VajramInitData;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;

public final class VajramLoader {
    public static List<? extends VajramDefRoot<Object>> loadVajrams(Set<String> packages, Collection<Class<? extends VajramDefRoot>> vajramDefClasses) {
        ArrayList<? extends VajramDefRoot<Object>> vajrams = new ArrayList<VajramDefRoot<Object>>(VajramLoader.loadAllVajrams(new Reflections((Configuration)ConfigurationBuilder.build((Object[])new Object[]{packages}))));
        Set containingPackages = vajramDefClasses.stream().map(c -> Objects.requireNonNull(c.getPackage()).getName()).collect(Collectors.toSet());
        Reflections reflections = new Reflections((Configuration)ConfigurationBuilder.build((Object[])new Object[]{containingPackages}));
        vajramDefClasses.stream().map(vajramDefClass -> VajramLoader.loadVajram(vajramDefClass, reflections)).forEach(vajrams::add);
        return vajrams;
    }

    private static List<? extends VajramDefRoot<Object>> loadAllVajrams(Reflections reflections) {
        return reflections.getSubTypesOf(VajramDefRoot.class).stream().filter(c -> Modifier.isFinal(c.getModifiers())).map(VajramLoader::initVajram).toList();
    }

    private static VajramDefRoot<Object> loadVajram(Class<? extends VajramDefRoot> clazz, Reflections reflections) {
        List<Class> impls = reflections.getSubTypesOf(clazz).stream().filter(subclass -> Modifier.isFinal(subclass.getModifiers())).filter(subType -> clazz.equals(subType.getSuperclass()) || Arrays.asList(subType.getInterfaces()).contains(clazz)).map(subType -> subType.asSubclass(VajramDefRoot.class)).toList();
        if (impls.size() > 1) {
            throw new IllegalArgumentException("Multiple Vajram Impl found in the package '%s' of the provided class: %s".formatted(clazz.getPackageName(), impls));
        }
        if (impls.isEmpty()) {
            throw new IllegalArgumentException("No Vajram Impl found in the package '%s' of the provided class: '%s'".formatted(clazz.getPackageName(), clazz));
        }
        return VajramLoader.initVajram(impls.get(0));
    }

    private static VajramDefRoot<Object> initVajram(Class<? extends VajramDefRoot> aClass) {
        if (!Modifier.isFinal(aClass.getModifiers())) {
            throw new RuntimeException("Provided Vajram impl class should be final");
        }
        try {
            return aClass.getConstructor(VajramInitData.class).newInstance(new VajramInitData());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    private VajramLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

