/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.facets.resolution;

import com.flipkart.krystal.data.ErrableFacetValue;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.vajram.facets.DependencyCommand;
import com.flipkart.krystal.vajram.facets.FanoutCommand;
import com.flipkart.krystal.vajram.facets.One2OneCommand;
import com.flipkart.krystal.vajram.facets.resolution.SimpleFanoutInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolverSpec;
import com.flipkart.krystal.vajram.facets.resolution.SimpleOne2OneInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.SkipPredicate;
import com.flipkart.krystal.vajram.facets.resolution.Transformer;
import com.flipkart.krystal.vajram.facets.specs.DependencySpec;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class InputResolverUtil {
    static <T> DependencyCommand<T> _resolutionHelper(@Nullable FacetSpec<?, ?> sourceFacet, Transformer transformer, List<? extends SkipPredicate> skipPredicates, FacetValues facetValues) {
        Optional<SkipPredicate> skipPredicate;
        FacetValue<?> sourceFacetValue;
        FacetValue<?> facetValue = sourceFacetValue = sourceFacet != null ? sourceFacet.getFacetValue(facetValues) : ErrableFacetValue.nil();
        if (sourceFacetValue != null && (skipPredicate = skipPredicates.stream().map(p -> p).filter(sSkipPredicate -> sSkipPredicate.condition().test(sourceFacetValue)).findFirst()).isPresent()) {
            if (transformer.canFanout()) {
                return FanoutCommand.skipFanout(skipPredicate.get().reason());
            }
            return One2OneCommand.skipExecution(skipPredicate.get().reason());
        }
        Optional transformedInput = Optional.ofNullable(transformer.apply(sourceFacetValue));
        if (transformer.canFanout()) {
            FanoutCommand fanoutCommand = FanoutCommand.executeFanoutWith((Collection)transformedInput.map(ts -> ((Collection)ts).stream()).stream().flatMap(Function.identity()).collect(ImmutableList.toImmutableList()));
            return fanoutCommand;
        }
        One2OneCommand<Object> tOne2OneCommand = One2OneCommand.executeWith(transformedInput.orElse(null));
        return tOne2OneCommand;
    }

    public static <T, CV extends Request<?>, DV extends Request<T>> SimpleInputResolver toResolver(DependencySpec<T, CV, DV> dependency, SimpleInputResolverSpec<?, CV, DV> spec) {
        if (spec.canFanout()) {
            return new SimpleFanoutInputResolver(dependency, spec);
        }
        return new SimpleOne2OneInputResolver(dependency, spec);
    }

    private InputResolverUtil() {
    }
}

