/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.exception;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.except.StackTracelessException;
import java.util.Collections;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class MandatoryFacetsMissingException
extends StackTracelessException {
    private final VajramID vajramID;
    private final Map<String, Throwable> failedMandatoryInputs;
    private @MonotonicNonNull String detailedMessage;

    public MandatoryFacetsMissingException(VajramID vajramID, Map<String, Throwable> failedMandatoryInputs) {
        this.vajramID = vajramID;
        this.failedMandatoryInputs = Collections.unmodifiableMap(failedMandatoryInputs);
    }

    public String getMessage() {
        if (this.detailedMessage == null) {
            this.detailedMessage = this.createMessage();
        }
        return this.detailedMessage;
    }

    private String createMessage() {
        return "Vajram %s did not receive these mandatory inputs: [ %s ]".formatted(this.vajramID, String.join((CharSequence)", ", this.failedMandatoryInputs.keySet().stream().map(s -> "'%s' (Cause: %s)".formatted(s, String.valueOf(this.failedMandatoryInputs.getOrDefault(s, new RuntimeException()).getMessage()))).toList()));
    }
}

