/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.batching;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.data.ExecutionItem;
import com.flipkart.krystal.data.FacetValuesBuilder;
import com.flipkart.krystal.data.ImmutableFacetValuesContainer;
import com.flipkart.krystal.vajram.batching.BatchEnabledFacetValues;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.InputBatcher;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class InputBatcherImpl
implements InputBatcher {
    private static final int DEFAULT_BATCH_SIZE = 1;
    private @Nullable Consumer<List<BatchedFacets>> batchingListener;
    private final Map<ImmutableFacetValuesContainer, List<ExecutionItem>> unBatchedRequests = new HashMap<ImmutableFacetValuesContainer, List<ExecutionItem>>();
    private int minBatchSize = 1;

    public InputBatcherImpl() {
    }

    public InputBatcherImpl(int minBatchSize) {
        this.minBatchSize = minBatchSize;
    }

    @Override
    public List<BatchedFacets> add(ExecutionItem batchEnabledFacets) {
        FacetValuesBuilder facetValuesBuilder = batchEnabledFacets.facetValues();
        if (facetValuesBuilder instanceof BatchEnabledFacetValues) {
            BatchEnabledFacetValues batchEnabledFacetValues = (BatchEnabledFacetValues)facetValuesBuilder;
            ImmutableFacetValuesContainer batchKey = batchEnabledFacetValues._batchKey();
            this.unBatchedRequests.computeIfAbsent(batchKey, k -> new ArrayList()).add(batchEnabledFacets);
            return this.getBatchedInputs(batchKey, false);
        }
        throw new IllegalStateException("Expected to receive instance of BatchEnabledFacetValues in batcher but received %s for vajram %s".formatted(batchEnabledFacets.facetValues(), batchEnabledFacets.facetValues()._vajramID()));
    }

    private List<BatchedFacets> getBatchedInputs(ImmutableFacetValuesContainer batchKey, boolean force) {
        List<ExecutionItem> batchItems = this.unBatchedRequests.getOrDefault(batchKey, (List<ExecutionItem>)ImmutableList.of());
        if (force || batchItems.size() >= this.minBatchSize) {
            BatchedFacets batchedFacets = new BatchedFacets(batchItems);
            this.unBatchedRequests.put(batchKey, new ArrayList());
            return List.of(batchedFacets);
        }
        return List.of();
    }

    @Override
    public void batch() {
        Consumer<List<BatchedFacets>> batchingListener = this.batchingListener;
        if (batchingListener != null) {
            ArrayList<BatchedFacets> list = new ArrayList<BatchedFacets>();
            for (ImmutableFacetValuesContainer c : this.unBatchedRequests.keySet()) {
                list.addAll(this.getBatchedInputs(c, true));
            }
            batchingListener.accept(Collections.unmodifiableList(list));
        }
    }

    @Override
    public void onBatching(Consumer<List<BatchedFacets>> listener) {
        this.batchingListener = listener;
    }

    public void onConfigUpdate(ConfigProvider configProvider) {
        this.minBatchSize = configProvider.getConfig("min_batch_size").orElse(1);
    }
}

