/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.facets.resolution;

import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.vajram.exception.MandatoryFacetMissingException;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolverSpec;
import com.flipkart.krystal.vajram.facets.resolution.SkipPredicate;
import com.flipkart.krystal.vajram.facets.resolution.Transformer;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.flipkart.krystal.vajram.facets.specs.MandatorySingleValueFacetSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MandatorySingleValTransformResolverStage<S, T, CV extends Request, DV extends Request> {
    private final InputMirrorSpec<T, DV> targetInput;
    private final MandatorySingleValueFacetSpec<S, CV> sourceFacet;
    private final List<SkipPredicate> skipConditions = new ArrayList<SkipPredicate>();

    MandatorySingleValTransformResolverStage(InputMirrorSpec<T, DV> targetInput, MandatorySingleValueFacetSpec<S, CV> sourceFacet) {
        this.targetInput = targetInput;
        this.sourceFacet = sourceFacet;
    }

    public MandatorySingleValTransformResolverStage<S, T, CV, DV> skipIf(Predicate<S> whenToSkip, String reason) {
        this.skipConditions.add(new SkipPredicate(reason, facetValue -> whenToSkip.test(((FacetValue.SingleFacetValue)facetValue).asErrable().valueOpt().orElseThrow(this::mandatoryFacetMissingException))));
        return this;
    }

    public SimpleInputResolverSpec<T, CV, DV> asResolver(Function<S, @Nullable T> transformer) {
        return new SimpleInputResolverSpec<T, CV, DV>(this.targetInput, this.sourceFacet, this.skipConditions, new Transformer.One2One(facetValue -> transformer.apply(facetValue.asErrable().valueOpt().orElseThrow(this::mandatoryFacetMissingException))));
    }

    private MandatoryFacetMissingException mandatoryFacetMissingException() {
        return new MandatoryFacetMissingException(this.sourceFacet.ofVajramID().id(), this.sourceFacet.name());
    }
}

