/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.utils;

import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.VajramInitData;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class VajramLoader {
    public static List<? extends VajramDefRoot<Object>> loadVajramsFromClassPath(String packagePrefix) {
        return new Reflections(packagePrefix, new Scanner[0]).getSubTypesOf(VajramDefRoot.class).stream().filter(c -> Modifier.isFinal(c.getModifiers())).map(VajramLoader::initVajram).toList();
    }

    public static VajramDefRoot<Object> createVajramObjectForClass(Class<? extends VajramDefRoot<?>> clazz) {
        List<Class> impls = new Reflections(clazz.getPackageName(), new Scanner[0]).getSubTypesOf(clazz).stream().filter(subclass -> Modifier.isFinal(subclass.getModifiers())).filter(subType -> clazz.equals(subType.getSuperclass()) || Arrays.asList(subType.getInterfaces()).contains(clazz)).map(subType -> subType.asSubclass(VajramDefRoot.class)).toList();
        if (impls.size() > 1) {
            throw new IllegalArgumentException("Multiple Vajram Impl found in the package '%s' of the provided class: %s".formatted(clazz.getPackageName(), impls));
        }
        if (impls.isEmpty()) {
            throw new IllegalArgumentException("No Vajram Impl found in the package '%s' of the provided class: '%s'".formatted(clazz.getPackageName(), clazz));
        }
        return VajramLoader.initVajram(impls.get(0));
    }

    private static VajramDefRoot<Object> initVajram(Class<? extends VajramDefRoot> aClass) {
        if (!Modifier.isFinal(aClass.getModifiers())) {
            throw new RuntimeException("Provided Vajram impl class should be final");
        }
        try {
            return aClass.getConstructor(VajramInitData.class).newInstance(new VajramInitData());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private VajramLoader() {
    }
}

