/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.facets.resolution;

import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.resolution.ResolverCommand;
import com.flipkart.krystal.vajram.facets.DependencyCommand;
import com.flipkart.krystal.vajram.facets.One2OneCommand;
import com.flipkart.krystal.vajram.facets.resolution.AbstractSimpleInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.InputResolverUtil;
import com.flipkart.krystal.vajram.facets.resolution.One2OneInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolverSpec;
import com.flipkart.krystal.vajram.facets.specs.DependencySpec;
import java.util.List;

public final class SimpleOne2OneInputResolver<S, T, CV extends Request<?>, DV extends Request<?>>
extends AbstractSimpleInputResolver<S, T, CV, DV>
implements One2OneInputResolver {
    SimpleOne2OneInputResolver(DependencySpec<?, CV, DV> dependency, SimpleInputResolverSpec<T, CV, DV> resolverSpec) {
        super(dependency, resolverSpec, false);
    }

    @Override
    public ResolverCommand resolve(List<? extends ImmutableRequest.Builder<?>> _depRequests, FacetValues _rawFacetValues) {
        try {
            DependencyCommand depCommand = InputResolverUtil._resolutionHelper(this.getResolverSpec().source(), this.getResolverSpec().transformer(), this.getResolverSpec().skipConditions(), _rawFacetValues);
            if (depCommand instanceof One2OneCommand) {
                ResolverCommand.SkipDependency command;
                One2OneCommand one2OneCommand = (One2OneCommand)depCommand;
                if (depCommand.shouldSkip()) {
                    command = ResolverCommand.skip((String)one2OneCommand.doc(), (Throwable)one2OneCommand.skipCause());
                } else {
                    for (ImmutableRequest.Builder<?> depRequest : _depRequests) {
                        this.getResolverSpec().targetInput().setToRequest(depRequest, one2OneCommand.input());
                    }
                    command = ResolverCommand.executeWithRequests(_depRequests);
                }
                return command;
            }
            throw new IllegalStateException("single input resolver must return One2OneCommand command only");
        }
        catch (Exception e) {
            return ResolverCommand.skip((String)String.format("Got exception %s while executing the resolver of the dependency %s", e, this.getDependency().name()), (Throwable)e);
        }
    }
}

