/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.batching;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.data.ExecutionItem;
import com.flipkart.krystal.data.FacetValuesBuilder;
import com.flipkart.krystal.data.ImmutableFacetValuesContainer;
import com.flipkart.krystal.vajram.batching.BatchEnabledFacetValues;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.InputBatcher;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public final class InputBatcherImpl
implements InputBatcher {
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int DEFAULT_BATCH_SIZE = 1;
    private @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Consumer<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BatchedFacets>> batchingListener;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableFacetValuesContainer, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutionItem>> unBatchedRequests = new HashMap<ImmutableFacetValuesContainer, List<ExecutionItem>>();
    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int minBatchSize = 1;

    public InputBatcherImpl() {
    }

    public InputBatcherImpl(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int minBatchSize) {
        this.minBatchSize = minBatchSize;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BatchedFacets> add(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutionItem batchEnabledFacets) {
        FacetValuesBuilder facetValuesBuilder = batchEnabledFacets.facetValues();
        if (facetValuesBuilder instanceof BatchEnabledFacetValues) {
            BatchEnabledFacetValues batchEnabledFacetValues = (BatchEnabledFacetValues)facetValuesBuilder;
            ImmutableFacetValuesContainer batchKey = batchEnabledFacetValues._batchKey();
            this.unBatchedRequests.computeIfAbsent(batchKey, k -> new ArrayList()).add(batchEnabledFacets);
            return this.getBatchedInputs(batchKey, false);
        }
        throw new IllegalStateException("Expected to receive instance of BatchEnabledFacetValues in batcher but received %s for vajram %s".formatted(batchEnabledFacets.facetValues(), batchEnabledFacets.facetValues()._vajramID()));
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BatchedFacets> getBatchedInputs(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableFacetValuesContainer batchKey, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean force) {
        List<ExecutionItem> batchItems = this.unBatchedRequests.getOrDefault(batchKey, (List<ExecutionItem>)ImmutableList.of());
        if (force || batchItems.size() >= this.minBatchSize) {
            BatchedFacets batchedFacets = new BatchedFacets(batchItems);
            this.unBatchedRequests.put(batchKey, new ArrayList());
            return List.of(batchedFacets);
        }
        return List.of();
    }

    @Override
    public void batch() {
        Consumer<List<BatchedFacets>> batchingListener = this.batchingListener;
        if (batchingListener != null) {
            ArrayList<BatchedFacets> list = new ArrayList<BatchedFacets>();
            for (ImmutableFacetValuesContainer c : this.unBatchedRequests.keySet()) {
                list.addAll(this.getBatchedInputs(c, true));
            }
            batchingListener.accept(Collections.unmodifiableList(list));
        }
    }

    @Override
    public void onBatching(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Consumer<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BatchedFacets>> listener) {
        this.batchingListener = listener;
    }

    public void onConfigUpdate(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ConfigProvider configProvider) {
        this.minBatchSize = configProvider.getConfig("min_batch_size").orElse(1);
    }
}

