/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.guice.traitbinding;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.tags.ElementTags;
import com.flipkart.krystal.traits.StaticDispatchPolicy;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.guice.traitbinding.TraitBinder;
import com.flipkart.krystal.vajram.guice.traitbinding.TraitBinding;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Key;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StaticDispatchPolicyImpl
extends StaticDispatchPolicy {
    private final VajramID traitID;
    private final ImmutableList<Class<? extends Request<?>>> dispatchTargetReqs;
    private final VajramKryonGraph vajramKryonGraph;
    private final ImmutableMap<Key<? extends Request<?>>, VajramID> bindingsByKey;
    private final Map<VajramID, Map<QualWrapper, VajramID>> bindingsByQualifier = new LinkedHashMap<VajramID, Map<QualWrapper, VajramID>>();

    public StaticDispatchPolicyImpl(VajramKryonGraph vajramKryonGraph, VajramID traitID, TraitBinder traitBinder) {
        this.vajramKryonGraph = vajramKryonGraph;
        this.traitID = traitID;
        this.bindingsByKey = (ImmutableMap)traitBinder.traitBindings().stream().collect(ImmutableMap.toImmutableMap(TraitBinding::key, binding -> vajramKryonGraph.getVajramIdByVajramReqType(binding.concreteVajramRequestType())));
        this.dispatchTargetReqs = ImmutableList.copyOf(traitBinder.traitBindings().stream().map(TraitBinding::concreteVajramRequestType).toList());
    }

    public VajramID getDispatchTarget(Dependency dependency) {
        ElementTags tags = dependency.tags();
        List<Annotation> list = tags.annotations().stream().filter(annotation -> annotation.annotationType().getAnnotation(Qualifier.class) != null).toList();
        if (list.size() > 1) {
            throw new IllegalStateException("Multiple qualifiers found for " + dependency);
        }
        Annotation qualifier = list.isEmpty() ? null : list.get(0);
        return this.getDispatchTarget(new QualWrapper(qualifier));
    }

    public VajramID getDispatchTarget(@Nullable Annotation qualifier) {
        return this.getDispatchTarget(new QualWrapper(qualifier));
    }

    private VajramID getDispatchTarget(QualWrapper qualWrapper) {
        return this.bindingsByQualifier.computeIfAbsent(this.traitID, vajramID -> new LinkedHashMap()).computeIfAbsent(qualWrapper, qualifierWrapper -> {
            VajramDefinition vajramDefinition = this.vajramKryonGraph.getVajramDefinition(this.traitID);
            Class traitReq = vajramDefinition.reqRootType();
            Annotation qualifier = qualifierWrapper.qualifier();
            Key key = qualifier == null ? Key.get((Class)traitReq) : Key.get((Class)traitReq, (Annotation)qualifier);
            VajramID vajramId = (VajramID)this.bindingsByKey.get((Object)key);
            if (vajramId == null && key.hasAttributes()) {
                vajramId = (VajramID)this.bindingsByKey.get((Object)key.withoutAttributes());
            }
            if (vajramId == null) {
                throw new IllegalStateException("No binding found for " + key + " corresponding to dependency " + qualifierWrapper);
            }
            return vajramId;
        });
    }

    public ImmutableCollection<VajramID> dispatchTargets() {
        return this.bindingsByKey.values();
    }

    @Generated
    public VajramID traitID() {
        return this.traitID;
    }

    @Generated
    public ImmutableList<Class<? extends Request<?>>> dispatchTargetReqs() {
        return this.dispatchTargetReqs;
    }

    private record QualWrapper(@Nullable Annotation qualifier) {
        private QualWrapper(@Nullable Annotation qualifier) {
            Preconditions.checkArgument((boolean)StaticDispatchPolicy.isValidQualifier((Annotation)qualifier), (Object)"qualifier annotation must have the @Qualifier annotation on its type");
        }
    }
}

