/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.guice;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.facets.InputDef;
import com.flipkart.krystal.vajram.facets.InputSource;
import com.flipkart.krystal.vajram.tags.AnnotationTag;
import com.flipkart.krystal.vajram.tags.AnnotationTagKey;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.VajramInjectionProvider;
import com.google.inject.Injector;
import com.google.inject.Key;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramGuiceInjector
implements VajramInjectionProvider {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(VajramGuiceInjector.class);
    private static final @UnknownKeyFor @NonNull @Initialized AnnotationTagKey NAMED_ANNO_TAG = AnnotationTagKey.from(Named.class);
    private final @UnknownKeyFor @NonNull @Initialized VajramKryonGraph vajramKryonGraph;
    private final @UnknownKeyFor @NonNull @Initialized Injector injector;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized VajramID, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Provider<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> providerCache = new LinkedHashMap();

    public VajramGuiceInjector(@UnknownKeyFor @NonNull @Initialized VajramKryonGraph vajramKryonGraph, @UnknownKeyFor @NonNull @Initialized Injector injector) {
        this.vajramKryonGraph = vajramKryonGraph;
        this.injector = injector;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Errable<T> get(@UnknownKeyFor @NonNull @Initialized VajramID vajramID, @UnknownKeyFor @NonNull @Initialized InputDef<T> inputDef) {
        if (!inputDef.sources().contains((Object)InputSource.SESSION)) {
            return Errable.empty();
        }
        return Errable.errableFrom(() -> {
            Provider provider = this.providerCache.computeIfAbsent(vajramID, _v -> new LinkedHashMap()).computeIfAbsent(inputDef.name(), _i -> {
                try {
                    Type type = inputDef.type().javaReflectType();
                    Optional<Annotation> annotation = this.getQualifier(vajramID, inputDef);
                    if (annotation.isEmpty()) {
                        return this.injector.getProvider(Key.get((Type)type));
                    }
                    return this.injector.getProvider(Key.get((Type)type, (Annotation)annotation.get()));
                }
                catch (ClassNotFoundException e) {
                    throw new StackTracelessException("Unable to load data type of Input", (Exception)e);
                }
            });
            return provider.get();
        });
    }

    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Annotation> getQualifier(@UnknownKeyFor @NonNull @Initialized VajramID vajramID, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized InputDef<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputDef) {
        List qualifierAnnotations = inputDef.tags().values().stream().mapMulti((tag, consumer) -> {
            if (tag instanceof AnnotationTag) {
                boolean isQualifierAnno;
                AnnotationTag annoTag = (AnnotationTag)tag;
                Annotation annotation = annoTag.tagValue();
                boolean bl = isQualifierAnno = annotation.annotationType().getAnnotation(Qualifier.class) != null;
                if (isQualifierAnno) {
                    consumer.accept(annoTag.tagValue());
                }
            }
        }).toList();
        if (qualifierAnnotations.isEmpty()) {
            return Optional.empty();
        }
        if (qualifierAnnotations.size() == 1) {
            return Optional.ofNullable((Annotation)qualifierAnnotations.get(0));
        }
        throw new IllegalStateException("More than one @jakarta.inject.Qualifier annotations (%s) found on input '%s' of vajram '%s'. This is not allowed".formatted(qualifierAnnotations, inputDef.name(), vajramID.vajramId()));
    }
}

