/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.guice.injection;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.except.KrystalCompletionException;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajram.inputinjection.InputInjectionUtils;
import com.flipkart.krystal.vajram.inputinjection.VajramInjectionProvider;
import com.google.inject.Injector;
import com.google.inject.Key;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramGuiceInputInjector
implements VajramInjectionProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VajramGuiceInputInjector.class);
    private final Injector injector;
    private final Map<VajramID, Map<String, Provider<?>>> providerCache = new LinkedHashMap();

    @Inject
    public VajramGuiceInputInjector(Injector injector) {
        this.injector = injector;
    }

    public <T> Provider<T> get(VajramID vajramID, FacetSpec<T, ?> facetDef) {
        if (!FacetType.INJECTION.equals((Object)facetDef.facetType())) {
            return () -> null;
        }
        Provider provider = this.providerCache.computeIfAbsent(vajramID, _v -> new LinkedHashMap()).computeIfAbsent(facetDef.name(), _i -> {
            try {
                Type type = facetDef.type().javaReflectType();
                Optional<Annotation> annotation = this.getQualifier(vajramID, facetDef);
                if (annotation.isEmpty()) {
                    return this.injector.getProvider(Key.get((Type)type));
                }
                return this.injector.getProvider(Key.get((Type)type, (Annotation)annotation.get()));
            }
            catch (ClassNotFoundException e) {
                throw new KrystalCompletionException("Unable to load data type of Input", (Throwable)e);
            }
        });
        return provider;
    }

    private <T> Optional<Annotation> getQualifier(VajramID vajramID, FacetSpec<T, ?> facetDef) {
        Annotation[] qualifierAnnotations = InputInjectionUtils.getQualifiers(facetDef);
        if (qualifierAnnotations.length == 0) {
            return Optional.empty();
        }
        if (qualifierAnnotations.length == 1) {
            return Optional.ofNullable(qualifierAnnotations[0]);
        }
        throw new IllegalStateException("More than one @jakarta.inject.Qualifier annotations (%s) found on input '%s' of vajram '%s'. This is not allowed".formatted(qualifierAnnotations, facetDef.name(), vajramID));
    }
}

