/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.guice.executorscope;

import com.flipkart.krystal.krystex.KrystalExecutor;
import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import java.util.HashMap;
import java.util.Map;

public class KrystalExecutorScope
implements Scope {
    public static final KrystalExecutorScope INSTANCE = new KrystalExecutorScope();
    private final Map<KrystalExecutor, Map<Key<?>, Object>> values = new HashMap();
    private static final Provider<Object> SEEDED_KEY_PROVIDER = () -> {
        throw new IllegalStateException("If you got here then it means that your code asked for scoped object which should have been explicitly seeded in this scope by calling KrystalExecutorScope.seed(), but was not.");
    };

    private KrystalExecutorScope() {
    }

    public ScopeInstance enter(KrystalExecutor krystalExecutor) {
        Preconditions.checkState((this.values.get(krystalExecutor) == null ? 1 : 0) != 0, (Object)"A krystal executor scoping block is already in progress");
        this.values.put(krystalExecutor, new HashMap());
        return new ScopeInstance(krystalExecutor);
    }

    public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
        return () -> {
            Map<Key<?>, Object> scopedObjects = this.getScopedObjectMap(KrystalExecutorScope.getExecutor());
            Object current = scopedObjects.get(key);
            if (current == null && !scopedObjects.containsKey(key)) {
                current = unscoped.get();
                if (Scopes.isCircularProxy((Object)current)) {
                    return current;
                }
                scopedObjects.put(key, current);
            }
            return current;
        };
    }

    public static <T> Provider<T> seededKeyProvider() {
        return SEEDED_KEY_PROVIDER;
    }

    private Map<Key<?>, Object> getScopedObjectMap(KrystalExecutor krystalExecutor) {
        return this.values.computeIfAbsent(krystalExecutor, _k -> new HashMap());
    }

    private static KrystalExecutor getExecutor() {
        KrystalExecutor executorForCurrentThread = KrystalExecutor.getExecutorForCurrentThread();
        if (executorForCurrentThread == null) {
            throw new OutOfScopeException("Could not retrieve krystal executor for current scope. This means we are not inside a Krystal executor scope");
        }
        return executorForCurrentThread;
    }

    public final class ScopeInstance
    implements AutoCloseable {
        private final KrystalExecutor krystalExecutor;

        public ScopeInstance(KrystalExecutor krystalExecutor) {
            this.krystalExecutor = krystalExecutor;
        }

        public <T> void seed(Key<T> key, T value) {
            Map<Key<?>, Object> scopedObjects = KrystalExecutorScope.this.getScopedObjectMap(this.krystalExecutor);
            Preconditions.checkState((!scopedObjects.containsKey(key) ? 1 : 0) != 0, (String)"A value for the key %s was already seeded in this scope. Old value: %s New value: %s", key, (Object)scopedObjects.get(key), value);
            scopedObjects.put(key, value);
        }

        public <T> void seed(Class<T> clazz, T value) {
            this.seed(Key.get(clazz), value);
        }

        @Override
        public void close() {
            Preconditions.checkState((KrystalExecutorScope.this.values.remove(this.krystalExecutor) != null ? 1 : 0) != 0, (Object)"This krystal executor scope was already closed");
        }
    }
}

