/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.guice.traitbinding;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.tags.ElementTags;
import com.flipkart.krystal.traits.StaticDispatchPolicy;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.guice.traitbinding.TraitBinder;
import com.flipkart.krystal.vajram.guice.traitbinding.TraitBinding;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Key;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StaticDispatchPolicyImpl
extends StaticDispatchPolicy {
    private final VajramID traitID;
    private final ImmutableSet<Class<? extends Request<?>>> dispatchTargetReqs;
    private final ImmutableSet<VajramID> dispatchTargetIDs;
    private final VajramKryonGraph vajramKryonGraph;
    private final ImmutableMap<Key<? extends Request<?>>, Class<? extends Request<?>>> bindingsByKey;
    private final Map<VajramID, Map<QualWrapper, Class<? extends Request<?>>>> bindingsByQualifier = new LinkedHashMap();

    public StaticDispatchPolicyImpl(VajramKryonGraph vajramKryonGraph, VajramID traitID, TraitBinder traitBinder) {
        this.vajramKryonGraph = vajramKryonGraph;
        this.traitID = traitID;
        this.bindingsByKey = (ImmutableMap)traitBinder.traitBindings().stream().collect(ImmutableMap.toImmutableMap(TraitBinding::key, TraitBinding::concreteVajramRequestType));
        this.dispatchTargetReqs = (ImmutableSet)traitBinder.traitBindings().stream().map(TraitBinding::concreteVajramRequestType).collect(ImmutableSet.toImmutableSet());
        this.dispatchTargetIDs = (ImmutableSet)this.dispatchTargetReqs.stream().map(arg_0 -> ((VajramKryonGraph)vajramKryonGraph).getVajramIdByVajramReqType(arg_0)).collect(ImmutableSet.toImmutableSet());
    }

    public Class<? extends Request<?>> getDispatchTarget(Dependency dependency) {
        ElementTags tags = dependency.tags();
        List<Annotation> list = tags.annotations().stream().filter(annotation -> annotation.annotationType().getAnnotation(Qualifier.class) != null).toList();
        if (list.size() > 1) {
            throw new IllegalStateException("Multiple qualifiers found for " + String.valueOf(dependency));
        }
        Annotation qualifier = list.isEmpty() ? null : list.get(0);
        return this.getDispatchTarget(new QualWrapper(qualifier));
    }

    public VajramID getDispatchTargetID(Dependency dependency) {
        return this.vajramKryonGraph.getVajramIdByVajramReqType(this.getDispatchTarget(dependency));
    }

    public Class<? extends Request<?>> getDispatchTarget(@Nullable Annotation qualifier) {
        return this.getDispatchTarget(new QualWrapper(qualifier));
    }

    public VajramID getDispatchTargetID(@Nullable Annotation qualifier) {
        return this.vajramKryonGraph.getVajramIdByVajramReqType(this.getDispatchTarget(qualifier));
    }

    private Class<? extends Request<?>> getDispatchTarget(QualWrapper qualWrapper) {
        return this.bindingsByQualifier.computeIfAbsent(this.traitID, vajramID -> new LinkedHashMap()).computeIfAbsent(qualWrapper, qualifierWrapper -> {
            VajramDefinition vajramDefinition = this.vajramKryonGraph.getVajramDefinition(this.traitID);
            Class traitReq = vajramDefinition.reqRootType();
            Annotation qualifier = qualifierWrapper.qualifier();
            Key key = qualifier == null ? Key.get((Class)traitReq) : Key.get((Class)traitReq, (Annotation)qualifier);
            Class dispatchTarget = (Class)this.bindingsByKey.get((Object)key);
            if (dispatchTarget == null && key.hasAttributes()) {
                dispatchTarget = (Class)this.bindingsByKey.get((Object)key.withoutAttributes());
            }
            if (dispatchTarget == null) {
                throw new IllegalStateException("No binding found for " + String.valueOf(key) + " corresponding to dependency " + String.valueOf(qualifierWrapper));
            }
            return dispatchTarget;
        });
    }

    @Generated
    public VajramID traitID() {
        return this.traitID;
    }

    @Generated
    public ImmutableSet<Class<? extends Request<?>>> dispatchTargetReqs() {
        return this.dispatchTargetReqs;
    }

    @Generated
    public ImmutableSet<VajramID> dispatchTargetIDs() {
        return this.dispatchTargetIDs;
    }

    private record QualWrapper(@Nullable Annotation qualifier) {
        private QualWrapper(@Nullable Annotation qualifier) {
            Preconditions.checkArgument((boolean)StaticDispatchPolicy.isValidQualifier((Annotation)qualifier), (Object)"qualifier annotation must have the @Qualifier annotation on its type");
        }
    }
}

