/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.api.schema;

import com.flipkart.krystal.vajram.graphql.api.execution.VajramExecutionStrategy;
import graphql.GraphQL;
import graphql.execution.ExecutionStrategy;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import lombok.Generated;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class GraphQlInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQlInitializer.class);
    private final ConcurrentHashMap<String, PreparsedDocumentEntry> documentCache = new ConcurrentHashMap();
    private final TypeDefinitionRegistry typeDefinitionRegistry = this.computeTypeDefinitionRegistry();
    private final GraphQL graphQL = this.getGraphQl(this.typeDefinitionRegistry);

    @Inject
    public GraphQlInitializer() {
    }

    public TypeDefinitionRegistry getTypeDefinitionRegistry() {
        return this.typeDefinitionRegistry;
    }

    public GraphQL getGraphQl() {
        return this.graphQL;
    }

    private TypeDefinitionRegistry computeTypeDefinitionRegistry() {
        if (this.typeDefinitionRegistry != null) {
            return this.typeDefinitionRegistry;
        }
        SchemaParser schemaParser = new SchemaParser();
        TypeDefinitionRegistry typeDefinitionRegistryComplete = new TypeDefinitionRegistry();
        for (Map.Entry<String, InputStream> entry : this.getResourceFileContents().entrySet()) {
            typeDefinitionRegistryComplete.merge(schemaParser.parse(entry.getValue()));
        }
        return typeDefinitionRegistryComplete;
    }

    private Map<String, InputStream> getResourceFileContents() {
        HashMap<String, InputStream> fileToContentMap = new HashMap<String, InputStream>();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Collection resource = ClasspathHelper.forResource((String)"Schema.graphqls", (ClassLoader[])new ClassLoader[0]);
        builder.addUrls(resource);
        builder.addScanners(new Scanner[]{Scanners.Resources});
        Reflections reflections = new Reflections((Configuration)builder);
        Set files = reflections.getResources(Pattern.compile("(.*).graphqls"));
        for (String file : files) {
            ClassLoader classLoader;
            InputStream content = null;
            ClassLoader[] classLoaderArray = ClasspathHelper.classLoaders((ClassLoader[])new ClassLoader[0]);
            int n = classLoaderArray.length;
            for (int i = 0; i < n && (content = (classLoader = classLoaderArray[i]).getResourceAsStream(file)) == null; ++i) {
            }
            if (content != null) {
                fileToContentMap.put(file, content);
                continue;
            }
            log.error("Could not read graphqls file {}", (Object)file);
        }
        log.info("GraphQl Files loaded: {}", fileToContentMap.keySet());
        return fileToContentMap;
    }

    private GraphQL getGraphQl(TypeDefinitionRegistry typeDefinitionRegistry) {
        RuntimeWiring.Builder runtimeWiring = RuntimeWiring.newRuntimeWiring();
        runtimeWiring.scalar(ExtendedScalars.Object);
        runtimeWiring.scalar(ExtendedScalars.DateTime);
        runtimeWiring.scalar(ExtendedScalars.Date);
        runtimeWiring.scalar(ExtendedScalars.GraphQLLong);
        GraphQLSchema graphQLSchema = new SchemaGenerator().makeExecutableSchema(typeDefinitionRegistry, runtimeWiring.build());
        PreparsedDocumentProvider preParsedCache = (executionInput, computeFunction) -> {
            Function<String, PreparsedDocumentEntry> mapCompute = key -> (PreparsedDocumentEntry)computeFunction.apply(executionInput);
            return CompletableFuture.completedFuture(this.documentCache.computeIfAbsent(executionInput.getQuery(), mapCompute));
        };
        return GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).queryExecutionStrategy((ExecutionStrategy)new VajramExecutionStrategy()).preparsedDocumentProvider(preParsedCache).build();
    }
}

