/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.api.execution;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.vajram.facets.specs.DependencySpec;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajramexecutor.krystex.VajramGraph;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import graphql.execution.ExecutionContext;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.ExecutableNormalizedOperation;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class QueryAnalyseUtil {
    public static final String DEFAULT_ENTITY_ID_FIELD = "id";
    private static final String FIRST_NODE = "QueryGraphQLAggregator";
    public static final String DATA_FETCHER = "dataFetcher";
    public static final String VAJRAM_ID = "vajramId";
    public static final String REF_FETCHER = "refFetcher";
    public static final String ENTITY_FETCHER = "entityFetcher";
    public static final String METADATA_FIELDS = "metadataFields";

    static ImmutableSet<DependentChain> getNodeExecutionConfigBasedOnQuery(ExecutionContext executionContext, Map<String, Map<String, List<String>>> reverseEntityTypeToFieldResolverMap, Map<String, Map<String, String>> entityToRefToTypeMap, Map<String, Map<String, String>> entityTypeToReferenceFetcher, VajramGraph vajramGraph) {
        GraphQLSchema graphQLSchema = executionContext.getGraphQLSchema();
        ExecutableNormalizedOperation executableNormalizedOperation = (ExecutableNormalizedOperation)executionContext.getNormalizedQueryTree().get();
        graphql.com.google.common.collect.ImmutableMap queriedFields = executableNormalizedOperation.getCoordinatesToNormalizedFields().asMap();
        HashSet<VajramID> vajramsToExecute = new HashSet<VajramID>();
        HashSet<DependentChain> dependentChainToSkip = new HashSet<DependentChain>();
        String queriedEntity = executionContext.getGraphQLSchema().getQueryType().getName().toUpperCase();
        HashSet<String> metadataFields = new HashSet<String>();
        QueryAnalyseUtil.scanForMetadataFields(executableNormalizedOperation.getTopLevelFields(), metadataFields);
        if (!metadataFields.isEmpty()) {
            executionContext.getGraphQLContext().put((Object)METADATA_FIELDS, metadataFields);
        }
        for (FieldCoordinates entry : queriedFields.keySet()) {
            GraphQLAppliedDirective graphQLAppliedDirectiveRef;
            if (entry.getFieldName().startsWith("__")) continue;
            GraphQLAppliedDirective graphQLAppliedDirective = graphQLSchema.getFieldDefinition(entry).getAppliedDirective(DATA_FETCHER);
            if (graphQLAppliedDirective != null) {
                vajramsToExecute.add(VajramID.vajramID((String)graphQLAppliedDirective.getArgument(VAJRAM_ID).getValue().toString()));
            }
            if ((graphQLAppliedDirectiveRef = graphQLSchema.getFieldDefinition(entry).getAppliedDirective(REF_FETCHER)) == null) continue;
            vajramsToExecute.add(VajramID.vajramID((String)graphQLAppliedDirectiveRef.getArgument(ENTITY_FETCHER).getValue().toString()));
        }
        QueryAnalyseUtil.setSkipDependentChains(vajramsToExecute, dependentChainToSkip, vajramGraph, queriedEntity, reverseEntityTypeToFieldResolverMap, entityToRefToTypeMap, entityTypeToReferenceFetcher);
        return ImmutableSet.copyOf(dependentChainToSkip);
    }

    private static void scanForMetadataFields(Collection<ExecutableNormalizedField> fields, Set<String> metadataFields) {
        for (ExecutableNormalizedField field : fields) {
            if (field.getName().startsWith("__")) {
                metadataFields.add(field.getName());
            }
            if (field.getChildren().isEmpty()) continue;
            QueryAnalyseUtil.scanForMetadataFields(field.getChildren(), metadataFields);
        }
    }

    private static void setSkipDependentChains(Set<VajramID> vajramsToExecute, Set<DependentChain> dependentChainToSkip, VajramGraph vajramNodeGraph, String queriedEntity, Map<String, Map<String, List<String>>> reverseEntityTypeToFieldResolverMap, Map<String, Map<String, String>> entityToRefToTypeMap, Map<String, Map<String, String>> entityTypeToReferenceFetcher) {
        ImmutableMap facetsByName = vajramNodeGraph.getVajramDefinition(VajramID.vajramID((String)FIRST_NODE)).facetsByName();
        for (Map.Entry<String, Map<String, List<String>>> entityToFieldEntry : reverseEntityTypeToFieldResolverMap.entrySet()) {
            if (queriedEntity.equalsIgnoreCase(entityToFieldEntry.getKey())) {
                ArrayList<Dependency> depList = new ArrayList<Dependency>();
                depList.add((Dependency)facetsByName.get((Object)queriedEntity.toLowerCase()));
                QueryAnalyseUtil.setSkipDependentChainPerEntity(vajramsToExecute, dependentChainToSkip, vajramNodeGraph, entityToFieldEntry.getKey(), depList, entityToRefToTypeMap, reverseEntityTypeToFieldResolverMap, entityTypeToReferenceFetcher);
                continue;
            }
            for (String fieldTypeDep : entityToFieldEntry.getValue().keySet()) {
                DependentChain dependentChain = vajramNodeGraph.computeDependentChain(FIRST_NODE, (Dependency)Objects.requireNonNull((FacetSpec)facetsByName.get((Object)entityToFieldEntry.getKey().toLowerCase())), new Dependency[]{(Dependency)Objects.requireNonNull((FacetSpec)facetsByName.get((Object)fieldTypeDep))});
                dependentChainToSkip.add(dependentChain);
            }
        }
    }

    private static void setSkipDependentChainPerEntity(Set<VajramID> vajramsToExecute, Set<DependentChain> dependentChainToSkip, VajramGraph vajramNodeGraph, String entity, List<Dependency> dependencyList, Map<String, Map<String, String>> entityToRefToTypeMap, Map<String, Map<String, List<String>>> reverseEntityTypeToFieldResolverMap, Map<String, Map<String, String>> entityTypeToReferenceFetcher) {
        for (String vajram : reverseEntityTypeToFieldResolverMap.get(entity).keySet()) {
            if (vajramsToExecute.contains(VajramID.vajramID((String)vajram))) continue;
            Dependency mostRecentDependency = null;
            Dependency[] depChain = new Dependency[dependencyList.size()];
            if (dependencyList.size() > 1) {
                for (int i = 1; i < dependencyList.size(); ++i) {
                    depChain[i - 1] = mostRecentDependency = dependencyList.get(i);
                }
            }
            if (mostRecentDependency instanceof DependencySpec) {
                DependencySpec dependencySpec = (DependencySpec)mostRecentDependency;
                VajramID mostRecentVajram = dependencySpec.onVajramID();
                ImmutableMap facetsByName = vajramNodeGraph.getVajramDefinition(mostRecentVajram).facetsByName();
                depChain[dependencyList.size() - 1] = (Dependency)facetsByName.get((Object)vajram);
                DependentChain dependentChain = vajramNodeGraph.computeDependentChain(FIRST_NODE, dependencyList.get(0), depChain);
                dependentChainToSkip.add(dependentChain);
                continue;
            }
            throw new UnsupportedOperationException("Unknown dependency type: " + String.valueOf(mostRecentDependency));
        }
        if (!dependencyList.isEmpty()) {
            Dependency mostRecentDependency = dependencyList.get(dependencyList.size() - 1);
            if (mostRecentDependency instanceof DependencySpec) {
                DependencySpec dependencySpec = (DependencySpec)mostRecentDependency;
                VajramID mostRecentVajram = dependencySpec.onVajramID();
                ImmutableMap facetsByName = vajramNodeGraph.getVajramDefinition(mostRecentVajram).facetsByName();
                for (Map.Entry<String, String> refFieldVajram : entityTypeToReferenceFetcher.get(entity).entrySet()) {
                    ArrayList<Dependency> newDepList = new ArrayList<Dependency>(dependencyList);
                    newDepList.add((Dependency)facetsByName.get((Object)refFieldVajram.getKey()));
                    QueryAnalyseUtil.setSkipDependentChainPerEntity(vajramsToExecute, dependentChainToSkip, vajramNodeGraph, entityToRefToTypeMap.get(entity).get(refFieldVajram.getKey()).toUpperCase(), newDepList, entityToRefToTypeMap, reverseEntityTypeToFieldResolverMap, entityTypeToReferenceFetcher);
                }
            }
        } else {
            throw new IllegalStateException("Empty dependency not yet handled");
        }
    }
}

