/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.api.traits;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.traits.ComputeDispatchPolicy;
import com.flipkart.krystal.vajram.graphql.api.traits.GraphQlOperationAggregate_Req;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.google.common.collect.ImmutableSet;
import graphql.ExecutionInput;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphQlOperationDispatch
extends ComputeDispatchPolicy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQlOperationDispatch.class);
    private final VajramKryonGraph graph;
    private final TypeDefinitionRegistry typeDefinitionRegistry;
    private final ImmutableSet<Class<? extends Request<?>>> dispatchTargets;
    private final ImmutableSet<VajramID> dispatchTargetIDs;

    public GraphQlOperationDispatch(VajramKryonGraph graph, TypeDefinitionRegistry typeDefinitionRegistry, Set<Class<? extends GraphQlOperationAggregate_Req>> dispatchTargets) {
        this.graph = graph;
        this.typeDefinitionRegistry = typeDefinitionRegistry;
        HashSet<Class<? extends GraphQlOperationAggregate_Req>> reqs = new HashSet<Class<? extends GraphQlOperationAggregate_Req>>();
        for (Class<? extends GraphQlOperationAggregate_Req> dispatchTarget : dispatchTargets) {
            reqs.add(dispatchTarget);
        }
        this.dispatchTargets = ImmutableSet.copyOf(reqs);
        this.dispatchTargetIDs = (ImmutableSet)dispatchTargets.stream().map(arg_0 -> ((VajramKryonGraph)graph).getVajramIdByVajramReqType(arg_0)).collect(ImmutableSet.toImmutableSet());
    }

    public VajramID traitID() {
        return this.graph.getVajramIdByVajramReqType(GraphQlOperationAggregate_Req.class);
    }

    public ImmutableSet<Class<? extends Request<?>>> dispatchTargetReqs() {
        return this.dispatchTargets;
    }

    public ImmutableSet<VajramID> dispatchTargetIDs() {
        return this.dispatchTargetIDs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public @Nullable VajramID getDispatchTargetID(@Nullable Dependency dependency, Request<?> request) {
        String resolvedOperationTypeName;
        if (!(request instanceof GraphQlOperationAggregate_Req)) return request._vajramID();
        GraphQlOperationAggregate_Req operationAggregateReq = (GraphQlOperationAggregate_Req)request;
        ExecutionInput executionInput = operationAggregateReq.executionInput();
        if (executionInput == null) {
            log.error("Execution input is null - cannot compute dispatch target for {}. Forwarding as is.", (Object)operationAggregateReq);
            return null;
        }
        Optional schemaDefinition = this.typeDefinitionRegistry.schemaDefinition();
        if (schemaDefinition.isEmpty()) {
            log.error("Schema definition is empty. SchemaDefinition is mandatory for vajram-graphql - cannot compute dispatch target for {}. Forwarding as is.", (Object)operationAggregateReq);
            return null;
        }
        Map<String, OperationTypeDefinition> operationTypesByOpName = ((SchemaDefinition)schemaDefinition.get()).getOperationTypeDefinitions().stream().collect(Collectors.toMap(OperationTypeDefinition::getName, op -> op));
        String requestedOperationType = executionInput.getOperationName();
        if (requestedOperationType == null || requestedOperationType.isBlank()) {
            OperationDefinition.Operation operationType = operationAggregateReq.operationType();
            if (operationType == null) {
                log.error("Operation type is null - cannot compute dispatch target for {}. Forwarding as is.", (Object)operationAggregateReq);
                return null;
            }
            if (OperationDefinition.Operation.QUERY.equals((Object)operationType)) {
                OperationTypeDefinition queryOperationDef = operationTypesByOpName.get("query");
                if (queryOperationDef == null) {
                    log.error("Default query operation has not been configured in schema {} - cannot compute dispatch target for {}. Forwarding as is.", (Object)operationAggregateReq);
                    return null;
                }
                resolvedOperationTypeName = queryOperationDef.getTypeName().getName();
                return VajramID.vajramID((String)(resolvedOperationTypeName + "_GQlAggr"));
            } else if (OperationDefinition.Operation.MUTATION.equals((Object)operationType)) {
                OperationTypeDefinition mutationOperationDef = operationTypesByOpName.get("mutation");
                if (mutationOperationDef == null) {
                    log.error("Default mutation operation has not been configured in schema {} - cannot compute dispatch target for {}. Forwarding as is.", (Object)schemaDefinition);
                    return null;
                }
                resolvedOperationTypeName = mutationOperationDef.getTypeName().getName();
                return VajramID.vajramID((String)(resolvedOperationTypeName + "_GQlAggr"));
            } else {
                if (!OperationDefinition.Operation.SUBSCRIPTION.equals((Object)operationType)) throw new UnsupportedOperationException("Unrecognized operation type: " + String.valueOf(operationType));
                OperationTypeDefinition subscriptionOperationDef = operationTypesByOpName.get("subscription");
                if (subscriptionOperationDef == null) {
                    log.error("Default subscription operation has not been configured in schema {} - cannot compute dispatch target for {}. Forwarding as is.", (Object)schemaDefinition);
                    return null;
                }
                resolvedOperationTypeName = subscriptionOperationDef.getTypeName().getName();
            }
            return VajramID.vajramID((String)(resolvedOperationTypeName + "_GQlAggr"));
        } else {
            resolvedOperationTypeName = requestedOperationType;
        }
        return VajramID.vajramID((String)(resolvedOperationTypeName + "_GQlAggr"));
    }
}

