/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.api.execution;

import com.flipkart.krystal.core.VajramInvocation;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.data.RequestResponseFuture;
import com.flipkart.krystal.vajram.graphql.api.model.GraphQlOperationObject;
import com.flipkart.krystal.vajram.graphql.api.traits.GraphQlQueryAggregate_Req;
import com.flipkart.krystal.vajram.graphql.api.traits.GraphQlQueryAggregate_ReqImmut;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStrategy;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResultPath;
import graphql.language.Field;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class VajramExecutionStrategy
extends ExecutionStrategy {
    public static final String GRAPHQL_OPERATION_REQUEST_CTX_KEY = "vajram_graphql_operation_request";
    public static final Class<VajramInvocation> VAJRAM_INVOCATION_CTX_KEY = VajramInvocation.class;
    private final FieldCollector fieldCollector = new FieldCollector();

    @Inject
    public VajramExecutionStrategy() {
    }

    public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        GraphQLContext graphQLContext = executionContext.getGraphQLContext();
        Object operationRequest = Objects.requireNonNull(graphQLContext.get((Object)GRAPHQL_OPERATION_REQUEST_CTX_KEY), "vajram_graphql_operation_request cannot be null");
        VajramInvocation vajramInvocation = Objects.requireNonNull((VajramInvocation)graphQLContext.get(VAJRAM_INVOCATION_CTX_KEY), "VajramInvocation cannot be null");
        if (!(operationRequest instanceof GraphQlQueryAggregate_Req)) {
            throw new IllegalArgumentException("Operation request is not of type GraphQlQueryAggregate_Req");
        }
        GraphQlQueryAggregate_Req queryAggregateReq = (GraphQlQueryAggregate_Req)operationRequest;
        GraphQlQueryAggregate_ReqImmut.Builder request = queryAggregateReq._asBuilder().graphql_executionContext(executionContext).graphql_executionStrategy(this).graphql_executionStrategyParams(parameters);
        RequestResponseFuture requestResponseFuture = new RequestResponseFuture((Request)request, new CompletableFuture());
        vajramInvocation.executeVajram(requestResponseFuture);
        return requestResponseFuture.response().handle((graphQlOpTypeModel, throwable) -> GraphQlOperationObject._asExecutionResult((Errable<GraphQlOperationObject>)Errable.errableFrom((Object)graphQlOpTypeModel, (Throwable)throwable)));
    }

    public ExecutionStrategyParameters newParametersForFieldExecution(ExecutionContext executionContext, ExecutionStrategyParameters parameters, @Nullable MergedField field) {
        ResultPath resultPath = parameters.getPath();
        if (field != null) {
            resultPath = parameters.getPath().segment(VajramExecutionStrategy.mkNameForPath(field));
        }
        ExecutionStrategyParameters.Builder builder = ExecutionStrategyParameters.newParameters((ExecutionStrategyParameters)parameters).path(resultPath);
        if (field != null) {
            builder.field(field);
        }
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        GraphQLObjectType resolvedObjectType = this.resolveType(executionContext, parameters, (GraphQLType)executionStepInfo.getUnwrappedNonNullType());
        ExecutionStepInfo newExecutionStepInfo = executionStepInfo.changeTypeWithPreservedNonNull((GraphQLOutputType)resolvedObjectType);
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext);
        builder.executionStepInfo(newExecutionStepInfo).nonNullFieldValidator(nonNullableFieldValidator).source(executionContext.getValueUnboxer().unbox(parameters.getSource())).parent(parameters);
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters().schema(executionContext.getGraphQLSchema()).objectType(resolvedObjectType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getCoercedVariables().toMap()).build();
        ExecutionStrategyParameters newParameters = builder.build();
        if (field != null) {
            MergedSelectionSet subFields = this.fieldCollector.collectFields(collectorParameters, newParameters.getField());
            newParameters = ExecutionStrategyParameters.newParameters((ExecutionStrategyParameters)newParameters).executionStepInfo(this.createExecutionStepInfo(executionContext, newParameters, this.getFieldDef(executionContext, newParameters, field.getSingleField()), resolvedObjectType)).build();
            return ExecutionStrategyParameters.newParameters((ExecutionStrategyParameters)newParameters).fields(subFields).build();
        }
        return ExecutionStrategyParameters.newParameters((ExecutionStrategyParameters)newParameters).build();
    }

    public static String mkNameForPath(MergedField mergedField) {
        return ((Field)mergedField.getFields().get(0)).getResultKey();
    }

    protected GraphQLObjectType resolveType(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLType fieldType) {
        if (fieldType instanceof GraphQLList) {
            GraphQLList graphQLList = (GraphQLList)fieldType;
            fieldType = graphQLList.getWrappedType();
        }
        return super.resolveType(executionContext, parameters, fieldType);
    }
}

