/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.api.execution;

import com.flipkart.krystal.vajram.graphql.api.errors.GraphQLErrorInfo;
import com.google.common.collect.Sets;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.MergedSelectionSet;
import graphql.language.SourceLocation;
import graphql.scalars.ExtendedScalars;
import graphql.schema.idl.RuntimeWiring;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public final class GraphQLUtils {
    public static RuntimeWiring buildRuntimeWarning() {
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        builder.scalar(ExtendedScalars.Object);
        return builder.build();
    }

    public static GraphQLError convertToGraphQlError(GraphQLErrorInfo errorInfo) {
        return new GraphQLErrorFromMap(errorInfo.getErrors());
    }

    public static boolean isFieldQueried(String fieldName, ExecutionStrategyParameters params) {
        MergedSelectionSet fields = params.getFields();
        return fields.getSubFields().containsKey(fieldName) || params.getField().getSingleField().getName().equals(fieldName);
    }

    public static boolean isAnyFieldQueried(Set<String> fieldNames, ExecutionStrategyParameters params) {
        MergedSelectionSet fields = params.getFields();
        return !Sets.intersection(fields.getSubFields().keySet(), fieldNames).isEmpty() || fieldNames.contains(params.getField().getSingleField().getName());
    }

    @Generated
    private GraphQLUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class GraphQLErrorFromMap
    implements GraphQLError {
        private final Map<String, Object> errorMap;

        public GraphQLErrorFromMap(Map<String, Object> errorMap) {
            this.errorMap = errorMap;
        }

        public String getMessage() {
            Object message = this.errorMap.get("message");
            return message != null ? message.toString() : "Unknown error";
        }

        public List<SourceLocation> getLocations() {
            Object locations = this.errorMap.get("locations");
            return locations instanceof List ? (List)locations : null;
        }

        public ErrorClassification getErrorType() {
            Object classification = this.errorMap.get("errorType");
            return classification instanceof ErrorClassification ? (ErrorClassification)classification : ErrorType.DataFetchingException;
        }

        public List<Object> getPath() {
            Object path = this.errorMap.get("path");
            return path instanceof List ? (List)path : null;
        }

        public Map<String, Object> getExtensions() {
            Object extensions = this.errorMap.get("extensions");
            return extensions instanceof Map ? (Map)extensions : null;
        }

        public Map<String, Object> toSpecification() {
            return new LinkedHashMap<String, Object>(this.errorMap);
        }
    }
}

