/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.api.schema;

import com.flipkart.krystal.vajram.graphql.api.execution.VajramExecutionStrategy;
import graphql.GraphQL;
import graphql.execution.ExecutionStrategy;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

@Singleton
public final class GraphQlLoader {
    private final ConcurrentHashMap<String, PreparsedDocumentEntry> documentCache = new ConcurrentHashMap();

    @Inject
    public GraphQlLoader() {
    }

    public GraphQL loadGraphQl() throws IOException {
        SchemaParser schemaParser = new SchemaParser();
        TypeDefinitionRegistry typeDefinitionRegistryComplete = new TypeDefinitionRegistry();
        for (Map.Entry<String, String> entry : this.getResourceFileContents().entrySet()) {
            typeDefinitionRegistryComplete.merge(schemaParser.parse(entry.getValue()));
        }
        RuntimeWiring.Builder runtimeWiring = RuntimeWiring.newRuntimeWiring();
        runtimeWiring.scalar(ExtendedScalars.Object);
        runtimeWiring.scalar(ExtendedScalars.DateTime);
        runtimeWiring.scalar(ExtendedScalars.Date);
        runtimeWiring.scalar(ExtendedScalars.GraphQLLong);
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        GraphQLSchema graphQLSchema = schemaGenerator.makeExecutableSchema(typeDefinitionRegistryComplete, runtimeWiring.build());
        PreparsedDocumentProvider preParsedCache = (executionInput, computeFunction) -> {
            Function<String, PreparsedDocumentEntry> mapCompute = key -> (PreparsedDocumentEntry)computeFunction.apply(executionInput);
            return CompletableFuture.completedFuture(this.documentCache.computeIfAbsent(executionInput.getQuery(), mapCompute));
        };
        return GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).queryExecutionStrategy((ExecutionStrategy)new VajramExecutionStrategy()).preparsedDocumentProvider(preParsedCache).build();
    }

    Map<String, String> getResourceFileContents() throws IOException {
        HashMap<String, String> fileToContentMap = new HashMap<String, String>();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addUrls(ClasspathHelper.forResource((String)"", (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()}));
        builder.addScanners(new Scanner[]{Scanners.Resources});
        Reflections reflections = new Reflections((Configuration)builder);
        Set files = reflections.getResources(Pattern.compile("(.*).graphqls"));
        for (String file : files) {
            String content = this.readResourceFile(file);
            if (content == null) continue;
            fileToContentMap.put(file, content);
        }
        return fileToContentMap;
    }

    private String readResourceFile(String filePath) throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(filePath);
        if (inputStream == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        int c = br.read();
        while (c != -1) {
            sb.append((char)c);
            c = br.read();
        }
        return sb.toString();
    }
}

