/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.api;

import com.flipkart.krystal.vajram.graphql.api.GraphQLErrorInfo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultGraphQLErrorInfo
implements GraphQLErrorInfo {
    private final List<String> messages = new ArrayList<String>();
    private final List<Object> path;
    private final Throwable throwable;

    public DefaultGraphQLErrorInfo(List<Object> path, Throwable throwable) {
        this.path = new ArrayList<Object>(path);
        this.throwable = throwable;
        if (throwable != null && throwable.getMessage() != null) {
            this.messages.add(throwable.getMessage());
        }
    }

    public DefaultGraphQLErrorInfo(List<Object> path, String message) {
        this.path = new ArrayList<Object>(path);
        this.throwable = null;
        if (message != null) {
            this.messages.add(message);
        }
    }

    @Override
    public void addMessage(String message) {
        if (message != null) {
            this.messages.add(message);
        }
    }

    @Override
    public Map<String, Object> getErrors() {
        LinkedHashMap<String, Object> errorMap = new LinkedHashMap<String, Object>();
        if (!this.messages.isEmpty()) {
            errorMap.put("message", this.messages.size() == 1 ? this.messages.get(0) : String.join((CharSequence)"; ", this.messages));
        } else {
            errorMap.put("message", "Unknown error");
        }
        if (this.path != null && !this.path.isEmpty()) {
            errorMap.put("path", new ArrayList<Object>(this.path));
        }
        LinkedHashMap<String, String> extensions = new LinkedHashMap<String, String>();
        if (this.throwable != null) {
            String errorCode = this.getErrorCode(this.throwable);
            extensions.put("code", errorCode);
            extensions.put("exception", this.throwable.getClass().getSimpleName());
        } else {
            extensions.put("code", "INTERNAL_ERROR");
        }
        errorMap.put("extensions", extensions);
        return errorMap;
    }

    private String getErrorCode(Throwable throwable) {
        String className = throwable.getClass().getSimpleName();
        if (className.contains("NotFound") || className.contains("NoSuchElement")) {
            return "NOT_FOUND";
        }
        if (className.contains("IllegalArgument") || className.contains("Validation")) {
            return "BAD_REQUEST";
        }
        if (className.contains("Unauthorized") || className.contains("Authentication")) {
            return "UNAUTHORIZED";
        }
        if (className.contains("Forbidden") || className.contains("Access")) {
            return "FORBIDDEN";
        }
        if (className.contains("Timeout")) {
            return "TIMEOUT";
        }
        return "INTERNAL_ERROR";
    }
}

