/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.api;

import com.flipkart.krystal.vajram.graphql.api.GraphQLErrorInfo;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.execution.ExecutionStrategyParameters;
import graphql.language.Field;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.SourceLocation;
import graphql.scalars.ExtendedScalars;
import graphql.schema.idl.RuntimeWiring;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public final class GraphQLUtils {
    public static RuntimeWiring buildRuntimeWarning() {
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        builder.scalar(ExtendedScalars.Object);
        return builder.build();
    }

    public static GraphQLError convertToGraphQlError(GraphQLErrorInfo errorInfo) {
        return new GraphQLErrorFromMap(errorInfo.getErrors());
    }

    public static boolean isFieldQueriedInTheNestedType(String nestedField, ExecutionStrategyParameters params) {
        String[] nestedFieldArray = nestedField.split("\\.");
        return GraphQLUtils.pathMatchesInTheFields(nestedFieldArray, params.getField().getSingleField().getSelectionSet(), 0);
    }

    public static boolean isFieldQueriedInTheNestedType(Set<String> fieldSupported, ExecutionStrategyParameters params) {
        for (String value : fieldSupported) {
            String[] nestedFieldArray = value.split("\\.");
            if (!GraphQLUtils.pathMatchesInTheFields(nestedFieldArray, params.getField().getSingleField().getSelectionSet(), 0)) continue;
            return true;
        }
        return false;
    }

    private static boolean pathMatchesInTheFields(String[] nestedFieldArray, SelectionSet field, int index) {
        if (index >= nestedFieldArray.length) {
            return true;
        }
        for (Selection selection : field.getSelections()) {
            Field selectedField = (Field)selection;
            if (!selectedField.getName().equals(nestedFieldArray[index])) continue;
            return GraphQLUtils.pathMatchesInTheFields(nestedFieldArray, selectedField.getSelectionSet(), ++index);
        }
        return false;
    }

    @Generated
    private GraphQLUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class GraphQLErrorFromMap
    implements GraphQLError {
        private final Map<String, Object> errorMap;

        public GraphQLErrorFromMap(Map<String, Object> errorMap) {
            this.errorMap = errorMap;
        }

        public String getMessage() {
            Object message = this.errorMap.get("message");
            return message != null ? message.toString() : "Unknown error";
        }

        public List<SourceLocation> getLocations() {
            Object locations = this.errorMap.get("locations");
            return locations instanceof List ? (List)locations : null;
        }

        public ErrorClassification getErrorType() {
            Object classification = this.errorMap.get("errorType");
            return classification instanceof ErrorClassification ? (ErrorClassification)classification : ErrorType.DataFetchingException;
        }

        public List<Object> getPath() {
            Object path = this.errorMap.get("path");
            return path instanceof List ? (List)path : null;
        }

        public Map<String, Object> getExtensions() {
            Object extensions = this.errorMap.get("extensions");
            return extensions instanceof Map ? (Map)extensions : null;
        }

        public Map<String, Object> toSpecification() {
            return new LinkedHashMap<String, Object>(this.errorMap);
        }
    }
}

