/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.api;

import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.krystex.kryon.KryonExecutionConfig;
import com.flipkart.krystal.vajram.graphql.api.AbstractGraphQlModel;
import com.flipkart.krystal.vajram.graphql.api.ExecutionLifecycleListener;
import com.flipkart.krystal.vajram.graphql.api.QueryAnalyseUtil;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutor;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutorConfig;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.google.common.collect.ImmutableSet;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.GraphqlErrorException;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStrategy;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResultPath;
import graphql.language.Field;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.ExecutableNormalizedOperation;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VajramExecutionStrategy
extends ExecutionStrategy {
    public static final String VAJRAM_KRYON_GRAPH = "vajram_kryon_graph";
    public static final String VAJRAM_EXECUTOR_CONFIG = "vajram_executor_config";
    public static final String TASK_ID = "taskId";
    public static final String TYPENAME_FIELD = "__typename";
    private final FieldCollector fieldCollector = new FieldCollector();
    private final InitVajramRequestCreator initVajramRequestCreator;
    private final ExecutionLifecycleListener executionLifecycleListener;
    private final Map<String, Map<String, List<String>>> reverseEntityTypeToFieldResolverMap;
    private final Map<String, Map<String, String>> entityToRefToTypeMap;
    private final Map<String, Map<String, String>> entityTypeToReferenceFetcher;

    public VajramExecutionStrategy(InitVajramRequestCreator initVajramRequestCreator, ExecutionLifecycleListener executionLifecycleListener, Map<String, Map<String, List<String>>> reverseEntityTypeToFieldResolverMap, Map<String, Map<String, String>> entityToRefToTypeMap, Map<String, Map<String, String>> entityTypeToReferenceFetcher) {
        this.initVajramRequestCreator = initVajramRequestCreator;
        this.executionLifecycleListener = executionLifecycleListener;
        this.reverseEntityTypeToFieldResolverMap = reverseEntityTypeToFieldResolverMap;
        this.entityToRefToTypeMap = entityToRefToTypeMap;
        this.entityTypeToReferenceFetcher = entityTypeToReferenceFetcher;
    }

    public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        GraphQLContext graphQLContext = executionContext.getGraphQLContext();
        KrystexVajramExecutorConfig.KrystexVajramExecutorConfigBuilder vajramExecutorConfigBuilder = (KrystexVajramExecutorConfig.KrystexVajramExecutorConfigBuilder)graphQLContext.getOrDefault((Object)VAJRAM_EXECUTOR_CONFIG, (Object)KrystexVajramExecutorConfig.builder());
        VajramKryonGraph vajramKryonGraph = (VajramKryonGraph)graphQLContext.get((Object)VAJRAM_KRYON_GRAPH);
        ImmutableSet<DependentChain> dependantChainList = QueryAnalyseUtil.getNodeExecutionConfigBasedOnQuery(executionContext, this.reverseEntityTypeToFieldResolverMap, this.entityToRefToTypeMap, this.entityTypeToReferenceFetcher, vajramKryonGraph);
        ImmutableRequest<?> immutableRequest = this.initVajramRequestCreator.create(executionContext, this, this.getParams(parameters));
        try (KrystexVajramExecutor vajramExecutor = KrystexVajramExecutor.builder().vajramKryonGraph(vajramKryonGraph).executorConfig(vajramExecutorConfigBuilder.build()).build();){
            this.executionLifecycleListener.onExecutionStart(new ExecutionLifecycleListener.ExecutionStartEvent(vajramExecutor, executionContext));
            CompletionStage completionStage = vajramExecutor.execute(immutableRequest, KryonExecutionConfig.builder().disabledDependentChains(dependantChainList).executionId((String)graphQLContext.get((Object)TASK_ID)).build()).handle((o, throwable) -> {
                if (throwable != null) {
                    return ExecutionResult.newExecutionResult().addError((GraphQLError)((GraphqlErrorException.Builder)GraphqlErrorException.newErrorException().cause(throwable)).build()).build();
                }
                Object resultData = this.processTypenameFields(executionContext, o);
                return ExecutionResult.newExecutionResult().data(resultData).build();
            });
            return completionStage;
        }
    }

    private Object processTypenameFields(ExecutionContext executionContext, Object originalData) {
        if (originalData == null) {
            return null;
        }
        Set metadataFields = (Set)executionContext.getGraphQLContext().get((Object)"metadataFields");
        if (metadataFields == null || metadataFields.isEmpty()) {
            return originalData;
        }
        if (metadataFields.contains(TYPENAME_FIELD)) {
            this.addTypeNameFieldsToObject(originalData, executionContext);
        }
        return originalData;
    }

    private void addTypeNameFieldsToObject(Object originalData, ExecutionContext executionContext) {
        if (originalData == null) {
            return;
        }
        ExecutableNormalizedOperation operation = (ExecutableNormalizedOperation)executionContext.getNormalizedQueryTree().get();
        List fields = operation.getTopLevelFields();
        HashMap<String, Boolean> fieldPathsWithTypename = new HashMap<String, Boolean>();
        for (ExecutableNormalizedField field : fields) {
            if (!field.getName().equals(TYPENAME_FIELD)) continue;
            fieldPathsWithTypename.put("", true);
            break;
        }
        for (ExecutableNormalizedField field : fields) {
            if (field.getName().equals(TYPENAME_FIELD)) continue;
            this.populateFieldPathsWithTypename(field, "", fieldPathsWithTypename);
        }
        if (!fieldPathsWithTypename.isEmpty()) {
            this.addTypenameToObjectsBasedOnPaths(originalData, "", fieldPathsWithTypename);
        }
    }

    private void populateFieldPathsWithTypename(ExecutableNormalizedField field, String path, Map<String, Boolean> pathsWithTypename) {
        boolean hasTypenameField = false;
        String currentPath = path.isEmpty() ? field.getName() : path + "." + field.getName();
        for (ExecutableNormalizedField child : field.getChildren()) {
            if (!child.getName().equals(TYPENAME_FIELD)) continue;
            hasTypenameField = true;
            break;
        }
        if (hasTypenameField) {
            pathsWithTypename.put(currentPath, true);
        }
        for (ExecutableNormalizedField child : field.getChildren()) {
            if (child.getName().equals(TYPENAME_FIELD)) continue;
            this.populateFieldPathsWithTypename(child, currentPath, pathsWithTypename);
        }
    }

    private void addTypenameToObjectsBasedOnPaths(Object obj, String currentPath, Map<String, Boolean> pathsWithTypename) {
        block6: {
            block7: {
                block5: {
                    if (obj == null) {
                        return;
                    }
                    if (!(obj instanceof AbstractGraphQlModel)) break block5;
                    AbstractGraphQlModel model = (AbstractGraphQlModel)obj;
                    if (pathsWithTypename.containsKey(currentPath)) {
                        model._values().put(TYPENAME_FIELD, model.getClass().getSimpleName());
                    }
                    for (Map.Entry<String, Object> entry : new HashMap<String, Object>(model._values()).entrySet()) {
                        String fieldName = entry.getKey();
                        Object value = entry.getValue();
                        if (fieldName.equals(TYPENAME_FIELD)) continue;
                        String childPath = currentPath.isEmpty() ? fieldName : currentPath + "." + fieldName;
                        this.addTypenameToObjectsBasedOnPaths(value, childPath, pathsWithTypename);
                    }
                    break block6;
                }
                if (!(obj instanceof List)) break block7;
                List list = (List)obj;
                for (Object item : list) {
                    this.addTypenameToObjectsBasedOnPaths(item, currentPath, pathsWithTypename);
                }
                break block6;
            }
            if (!(obj instanceof Map)) break block6;
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                String fieldName = (String)entry.getKey();
                Object value = entry.getValue();
                if (fieldName.equals(TYPENAME_FIELD)) continue;
                String childPath = currentPath.isEmpty() ? fieldName : currentPath + "." + fieldName;
                this.addTypenameToObjectsBasedOnPaths(value, childPath, pathsWithTypename);
            }
        }
    }

    private ExecutionStrategyParameters getParams(ExecutionStrategyParameters parameters) {
        MergedSelectionSet fields = parameters.getFields();
        List fieldNames = fields.getKeys();
        if (!fieldNames.isEmpty()) {
            if (fieldNames.contains(TYPENAME_FIELD) && fieldNames.size() > 1) {
                String firstSubstantiveField = fieldNames.stream().filter(name -> !name.equals(TYPENAME_FIELD)).findFirst().orElse((String)fieldNames.get(0));
                MergedField currentField = fields.getSubField(firstSubstantiveField);
                ResultPath fieldPath = parameters.getPath().segment(VajramExecutionStrategy.mkNameForPath(currentField));
                return parameters.transform(builder -> builder.field(currentField).path(fieldPath).parent(parameters));
            }
            String firstField = (String)fieldNames.get(0);
            MergedField currentField = fields.getSubField(firstField);
            ResultPath fieldPath = parameters.getPath().segment(VajramExecutionStrategy.mkNameForPath(currentField));
            return parameters.transform(builder -> builder.field(currentField).path(fieldPath).parent(parameters));
        }
        return parameters;
    }

    public ExecutionStrategyParameters newParametersForFieldExecution(ExecutionContext executionContext, ExecutionStrategyParameters parameters, @Nullable MergedField field) {
        ResultPath resultPath = parameters.getPath();
        if (field != null) {
            resultPath = parameters.getPath().segment(VajramExecutionStrategy.mkNameForPath(field));
        }
        ExecutionStrategyParameters.Builder builder = ExecutionStrategyParameters.newParameters((ExecutionStrategyParameters)parameters).path(resultPath);
        if (field != null) {
            builder.field(field);
        }
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        GraphQLObjectType resolvedObjectType = this.resolveType(executionContext, parameters, (GraphQLType)executionStepInfo.getUnwrappedNonNullType());
        ExecutionStepInfo newExecutionStepInfo = executionStepInfo.changeTypeWithPreservedNonNull((GraphQLOutputType)resolvedObjectType);
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext);
        builder.executionStepInfo(newExecutionStepInfo).nonNullFieldValidator(nonNullableFieldValidator).source(executionContext.getValueUnboxer().unbox(parameters.getSource())).parent(parameters);
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters().schema(executionContext.getGraphQLSchema()).objectType(resolvedObjectType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getCoercedVariables().toMap()).build();
        ExecutionStrategyParameters newParameters = builder.build();
        if (field != null) {
            MergedSelectionSet subFields = this.fieldCollector.collectFields(collectorParameters, newParameters.getField());
            newParameters = ExecutionStrategyParameters.newParameters((ExecutionStrategyParameters)newParameters).executionStepInfo(this.createExecutionStepInfo(executionContext, newParameters, this.getFieldDef(executionContext, newParameters, field.getSingleField()), resolvedObjectType)).build();
            return ExecutionStrategyParameters.newParameters((ExecutionStrategyParameters)newParameters).fields(subFields).build();
        }
        return ExecutionStrategyParameters.newParameters((ExecutionStrategyParameters)newParameters).build();
    }

    public static String mkNameForPath(MergedField mergedField) {
        return ((Field)mergedField.getFields().get(0)).getResultKey();
    }

    protected GraphQLObjectType resolveType(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLType fieldType) {
        if (fieldType instanceof GraphQLList) {
            GraphQLList graphQLList = (GraphQLList)fieldType;
            fieldType = graphQLList.getWrappedType();
        }
        return super.resolveType(executionContext, parameters, fieldType);
    }

    @FunctionalInterface
    public static interface InitVajramRequestCreator {
        public ImmutableRequest<?> create(ExecutionContext var1, VajramExecutionStrategy var2, ExecutionStrategyParameters var3);
    }
}

