/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.vajram.graphql.codegen.CodeGenConstants;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQLTypeName;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQlFieldSpec;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQlTypeDecorator;
import com.flipkart.krystal.vajram.graphql.codegen.PlainType;
import com.flipkart.krystal.vajram.graphql.codegen.SchemaReaderUtil;
import com.flipkart.krystal.vajram.graphql.codegen.WrappedType;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.StringValue;
import graphql.language.Value;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.tools.StandardLocation;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphQlCodeGenUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQlCodeGenUtil.class);
    private final SchemaReaderUtil schemaReaderUtil;

    public GraphQlCodeGenUtil(CodeGenUtility util) {
        this(GraphQlCodeGenUtil.getSchemaFilePath(util).toFile());
    }

    public GraphQlCodeGenUtil(File schemaFile) {
        this.schemaReaderUtil = new SchemaReaderUtil(schemaFile);
    }

    public static Path getSchemaFilePath(CodeGenUtility util) {
        try {
            return new File(util.processingEnv().getFiler().getResource(StandardLocation.SOURCE_PATH, "", "Schema.graphqls").toUri()).toPath();
        }
        catch (IOException e) {
            util.note((CharSequence)"Failed to get schema file in SOURCE_PATH. This can happen in projects which have not configured a JPMS named moduled. Trying to look for 'moduleRootPath' annotation processor option");
            Path moduleRootPath = util.moduleRootPath();
            if (moduleRootPath == null) {
                throw new RuntimeException("Schema.graphqls was not present in SOURCE_PATH, nor was the krystal.codegen.moduleRootPath passed");
            }
            File schemaFile = moduleRootPath.resolve(CodeGenConstants.GRAPHQL_SRC_DIR).resolve("Schema.graphqls").toFile();
            if (!schemaFile.exists()) {
                util.note((CharSequence)("Schema.graphqls was not present in SOURCE_PATH, nor was it found in the module path: " + schemaFile.getAbsolutePath()));
            }
            if (!schemaFile.exists()) {
                util.note((CharSequence)"Schema.graphqls not found. GraphQl Code Generation May be skipped");
            }
            return schemaFile.toPath();
        }
    }

    TypeName toTypeNameForField(GraphQlFieldSpec fieldSpec) {
        return this.toTypeNameForField(fieldSpec.fieldType(), fieldSpec);
    }

    TypeName toTypeNameForField(GraphQlTypeDecorator graphQlTypeDecorator, GraphQlFieldSpec fieldSpec) {
        if (graphQlTypeDecorator instanceof PlainType) {
            PlainType plainType = (PlainType)graphQlTypeDecorator;
            return this.getTypeNameForField(plainType, fieldSpec).annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()});
        }
        if (graphQlTypeDecorator instanceof WrappedType) {
            WrappedType wrappedType = (WrappedType)graphQlTypeDecorator;
            return this.getTypeNameForField(wrappedType, fieldSpec);
        }
        throw new IllegalArgumentException("Unknown fieldType: " + String.valueOf(graphQlTypeDecorator));
    }

    TypeName getTypeNameForField(WrappedType fieldType, GraphQlFieldSpec fieldSpec) {
        GraphQlTypeDecorator innerGraphQlTypeDecorator = fieldType.innerType();
        return switch (fieldType.wrapperType()) {
            default -> throw new IncompatibleClassChangeError();
            case WrappedType.WrapperType.NONNULL -> {
                if (innerGraphQlTypeDecorator instanceof PlainType) {
                    PlainType plainType = (PlainType)innerGraphQlTypeDecorator;
                    yield this.getTypeNameForField(plainType, fieldSpec);
                }
                yield this.toTypeNameForField(innerGraphQlTypeDecorator, fieldSpec);
            }
            case WrappedType.WrapperType.LIST -> ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.toTypeNameForField(innerGraphQlTypeDecorator, fieldSpec)});
        };
    }

    ClassName getTypeNameForField(PlainType fieldType, GraphQlFieldSpec fieldSpec) {
        GraphQLTypeName typeName = new GraphQLTypeName(fieldType.graphQlType().getName());
        String packageName = null;
        for (Directive directive : fieldSpec.fieldDefinition().getDirectives()) {
            if (!directive.getName().equals("customType")) continue;
            for (Argument argument : directive.getArguments()) {
                StringValue stringValue;
                Value value;
                if (argument.getName().equals("packageName") && (value = argument.getValue()) instanceof StringValue) {
                    stringValue = (StringValue)value;
                    packageName = stringValue.getValue();
                }
                if (!argument.getName().equals("className") || !((value = argument.getValue()) instanceof StringValue)) continue;
                stringValue = (StringValue)value;
                typeName = new GraphQLTypeName(stringValue.getValue());
            }
        }
        return switch (fieldType.graphQlType().getName()) {
            case "String" -> ClassName.get(String.class);
            case "Int" -> ClassName.get(Integer.class);
            case "Boolean" -> ClassName.get(Boolean.class);
            case "Float" -> ClassName.get(Float.class);
            case "ID" -> {
                GraphQLTypeName enclosingType = fieldSpec.enclosingType();
                if (enclosingType != null) {
                    yield this.schemaReaderUtil.entityIdClassName(enclosingType);
                }
                yield ClassName.get(Object.class);
            }
            default -> ClassName.get((String)Objects.requireNonNullElse(packageName, this.schemaReaderUtil.getPackageNameForType(typeName)), (String)typeName.value(), (String[])new String[0]);
        };
    }

    @Generated
    public SchemaReaderUtil schemaReaderUtil() {
        return this.schemaReaderUtil;
    }
}

