/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.model.Model;
import com.flipkart.krystal.model.ModelRoot;
import com.flipkart.krystal.model.SupportedModelProtocols;
import com.flipkart.krystal.vajram.graphql.api.model.GraphQlEntityId;
import com.flipkart.krystal.vajram.graphql.api.model.GraphQlObject;
import com.flipkart.krystal.vajram.graphql.api.model.GraphQlOperationObject;
import com.flipkart.krystal.vajram.graphql.api.model.GraphQlResponseJson;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQLTypeName;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQlCodeGenUtil;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQlFieldSpec;
import com.flipkart.krystal.vajram.graphql.codegen.SchemaReaderUtil;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import graphql.language.AbstractDescribedNode;
import graphql.language.Description;
import graphql.language.DirectivesContainer;
import graphql.language.EnumTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.TypeDefinition;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.checkerframework.checker.nullness.qual.NonNull;

class GraphQLEntityGen
implements CodeGenerator {
    private final CodeGenUtility util;
    private final GraphQlCodeGenUtil graphQlCodeGenUtil;
    private final SchemaReaderUtil schemaReaderUtil;

    public GraphQLEntityGen(CodeGenUtility util, File schemaFile) {
        this.util = util;
        this.graphQlCodeGenUtil = new GraphQlCodeGenUtil(schemaFile);
        this.schemaReaderUtil = this.graphQlCodeGenUtil.schemaReaderUtil();
    }

    public void generate() {
        TypeDefinitionRegistry typeDefinitionRegistry = this.schemaReaderUtil.typeDefinitionRegistry();
        String rootPackageName = this.schemaReaderUtil.rootPackageName();
        Optional schemaDefinition = typeDefinitionRegistry.schemaDefinition();
        if (schemaDefinition.isEmpty()) {
            this.util.note((CharSequence)"No schema definition found - skipping entity generation");
            return;
        }
        Map<String, OperationTypeDefinition> opDefsByName = ((SchemaDefinition)schemaDefinition.get()).getOperationTypeDefinitions().stream().collect(Collectors.toMap(operationTypeDefinition -> operationTypeDefinition.getTypeName().getName(), od -> od));
        Map typesWithDataModels = Maps.filterValues((Map)typeDefinitionRegistry.types(), typeDefinition -> typeDefinition instanceof EnumTypeDefinition || typeDefinition instanceof ObjectTypeDefinition);
        this.util.note((CharSequence)"Generating id models and data models for types : %s".formatted(typesWithDataModels));
        for (Map.Entry entry : typesWithDataModels.entrySet()) {
            GraphQLTypeName graphQLTypeName2 = new GraphQLTypeName((String)entry.getKey());
            TypeDefinition typeDefinition2 = (TypeDefinition)entry.getValue();
            try {
                TypeSpec.Builder typeSpec;
                ClassName entityClassName = this.schemaReaderUtil.typeClassName(graphQLTypeName2);
                if (typeDefinition2 instanceof EnumTypeDefinition) {
                    TypeSpec.Builder enumTypeSpecBuilder = TypeSpec.enumBuilder((String)graphQLTypeName2.value()).addModifiers(new Modifier[]{Modifier.PUBLIC});
                    ((EnumTypeDefinition)typeDefinition2).getEnumValueDefinitions().forEach(enumValueDefinition -> enumTypeSpecBuilder.addEnumConstant(enumValueDefinition.getName()));
                    typeSpec = enumTypeSpecBuilder;
                } else if (typeDefinition2 instanceof ObjectTypeDefinition) {
                    boolean isEntity = typeDefinition2.hasDirective("entity");
                    boolean isOpType = opDefsByName.get(typeDefinition2.getName()) != null;
                    ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
                    GraphQLTypeName enclosingType = GraphQLTypeName.of(typeDefinition2);
                    boolean idMissing = true;
                    String entityIdFieldName = this.schemaReaderUtil.getEntityIdFieldName(typeDefinition2);
                    if (typeDefinition2.getChildren() != null) {
                        for (int i = 0; i < typeDefinition2.getChildren().size(); ++i) {
                            Object e = typeDefinition2.getChildren().get(i);
                            if (!(e instanceof FieldDefinition)) continue;
                            FieldDefinition fieldDefinition = (FieldDefinition)e;
                            String fieldName = fieldDefinition.getName();
                            boolean isEntityIdField = entityIdFieldName.equals(fieldName);
                            GraphQlFieldSpec fieldSpec = this.schemaReaderUtil.fieldSpecFromField(fieldDefinition, "", enclosingType);
                            TypeName typeNameForField = this.graphQlCodeGenUtil.toTypeNameForField(fieldSpec);
                            if (isEntity && isEntityIdField) {
                                idMissing = false;
                                typeNameForField = this.schemaReaderUtil.entityIdClassName(graphQLTypeName2);
                            }
                            methodSpecs.add(MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(typeNameForField).addJavadoc(GraphQLEntityGen.getDescription(fieldDefinition), new Object[0]).build());
                        }
                        if (isEntity && idMissing) {
                            this.util.error("The entity %s does not have an '%s' field. Every entity MUST have an id.Either remove the '@entity' directive from the type or add an '%s' field".formatted(entityClassName.simpleName(), entityIdFieldName, entityIdFieldName), new Element[0]);
                        }
                    }
                    ClassName immutableClassName = ClassName.get((String)entityClassName.packageName(), (String)(entityClassName.simpleName() + "_Immut"), (String[])new String[0]);
                    methodSpecs.add(MethodSpec.overriding((ExecutableElement)this.util.getMethod(() -> Model.class.getMethod("_asBuilder", new Class[0]))).returns((TypeName)immutableClassName.nestedClass("Builder")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
                    typeSpec = this.util.interfaceBuilder(entityClassName.simpleName(), "").addAnnotation(AnnotationSpec.builder(ModelRoot.class).addMember("type", "$T.$L", new Object[]{ModelRoot.ModelType.class, ModelRoot.ModelType.RESPONSE.name()}).addMember("builderExtendsModelRoot", "true", new Object[0]).build()).addAnnotation(AnnotationSpec.builder(SupportedModelProtocols.class).addMember("value", "$T.class", new Object[]{GraphQlResponseJson.class}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethods(methodSpecs).addSuperinterface((TypeName)(isOpType ? ClassName.get(GraphQlOperationObject.class) : ClassName.get(GraphQlObject.class)));
                    if (isEntity) {
                        ClassName entityIdClassName = this.schemaReaderUtil.entityIdClassName(graphQLTypeName2);
                        this.util.generateSourceFile(entityIdClassName.canonicalName(), JavaFile.builder((String)entityIdClassName.packageName(), (TypeSpec)this.util.classBuilder(entityIdClassName.simpleName(), entityClassName.canonicalName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(GraphQlEntityId.class).addField(String.class, "value", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.methodBuilder((String)"value").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return value", new Object[0]).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "value", new Modifier[0]).addStatement("this.value = value", new Object[0]).build()).build()).build().toString(), null);
                    }
                } else {
                    this.util.note((CharSequence)("Skipping unknown entity type: " + String.valueOf(typeDefinition2)));
                    continue;
                }
                if (typeDefinition2 instanceof AbstractDescribedNode) {
                    AbstractDescribedNode describedNode = (AbstractDescribedNode)typeDefinition2;
                    typeSpec.addJavadoc(GraphQLEntityGen.getDescription(describedNode), new Object[0]);
                }
                this.util.generateSourceFile(entityClassName.canonicalName(), JavaFile.builder((String)entityClassName.packageName(), (TypeSpec)typeSpec.build()).build().toString(), null);
            }
            catch (Throwable e) {
                this.util.error("Could not generate id models and data models for type '%s' due to error '%s'".formatted(entry.getKey(), Throwables.getStackTraceAsString((Throwable)e)), new Element[0]);
            }
        }
        Map<GraphQLTypeName, @NonNull ObjectTypeDefinition> aggregatableTypes = this.schemaReaderUtil.aggregatableTypes();
        this.util.note((CharSequence)"Evaluating '%s' to generate GraphQl Field Models where needed (i.e. if a data fetcher is bound to multiple fields)".formatted(aggregatableTypes));
        aggregatableTypes.forEach((graphQLTypeName, entityTypeDefinition) -> {
            try {
                HashMap<ClassName, List> fieldDefinitions = new HashMap<ClassName, List>();
                for (FieldDefinition fieldDefinition : entityTypeDefinition.getFieldDefinitions()) {
                    if (fieldDefinition.getDirectives("dataFetcher").isEmpty()) continue;
                    fieldDefinitions.computeIfAbsent(this.schemaReaderUtil.getDataFetcherClassName((DirectivesContainer<?>)fieldDefinition), _k -> new ArrayList()).add(fieldDefinition);
                }
                fieldDefinitions.forEach((dataFetcherName, fieldDefinitionList) -> {
                    ClassName className = ClassName.get((String)dataFetcherName.packageName(), (String)(dataFetcherName.simpleName() + "_GQlFields"), (String[])new String[0]);
                    if (fieldDefinitionList.size() > 1) {
                        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)className);
                        for (FieldDefinition fieldDefinitionDf : fieldDefinitionList) {
                            builder.addField(FieldSpec.builder((TypeName)this.graphQlCodeGenUtil.toTypeNameForField(this.schemaReaderUtil.fieldSpecFromField(fieldDefinitionDf, "", (GraphQLTypeName)graphQLTypeName)), (String)fieldDefinitionDf.getName(), (Modifier[])new Modifier[]{Modifier.PUBLIC}).build());
                        }
                        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"lombok.experimental", (String)"Accessors", (String[])new String[0])).addMember("fluent", "true", new Object[0]).build()).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"lombok", (String)"Getter", (String[])new String[0])).build()).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"lombok", (String)"Builder", (String[])new String[0])).build()).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"lombok", (String)"Setter", (String[])new String[0])).build());
                        this.util.generateSourceFile(className.canonicalName(), JavaFile.builder((String)className.packageName(), (TypeSpec)builder.build()).build().toString(), null);
                    }
                });
            }
            catch (Throwable e) {
                this.util.error("Could not generate GraphQl Fields Models for type '%s' due to error '%s'".formatted(graphQLTypeName, Throwables.getStackTraceAsString((Throwable)e)), new Element[0]);
            }
        });
    }

    private static String getDescription(AbstractDescribedNode<?> describedNode) {
        Description description = describedNode.getDescription();
        if (description == null) {
            return "";
        }
        return Objects.requireNonNullElse(description.getContent(), "");
    }
}

