/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.codegen;

import com.flipkart.krystal.vajram.graphql.codegen.Fetcher;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQLTypeName;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQlFetcherType;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQlFieldSpec;
import com.flipkart.krystal.vajram.graphql.codegen.SimpleFetcher;
import com.flipkart.krystal.vajram.graphql.codegen.VajramFetcher;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.squareup.javapoet.ClassName;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.EnumTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaReaderUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaReaderUtil.class);
    public static final String GRAPHQL_SCHEMA_EXTENSION = ".graphqls";
    public static final String CUSTOM_TYPE_DIRECTIVE = "customType";
    public static final String PACKAGE_NAME_DIR_ARG = "packageName";
    public static final String CLASS_NAME_DIR_ARG = "className";
    private final Map<GraphQLTypeName, Map<GraphQlFieldSpec, ClassName>> entityTypeToFieldToTypeAggregator = new HashMap<GraphQLTypeName, Map<GraphQlFieldSpec, ClassName>>();
    private final Map<GraphQLTypeName, Map<GraphQlFieldSpec, Fetcher>> entityTypeToFieldToFetcher = new HashMap<GraphQLTypeName, Map<GraphQlFieldSpec, Fetcher>>();
    private final Map<GraphQLTypeName, Map<Fetcher, List<GraphQlFieldSpec>>> typeToFetcherToFields = new HashMap<GraphQLTypeName, Map<Fetcher, List<GraphQlFieldSpec>>>();
    private final String rootPackageName;
    private final TypeDefinitionRegistry typeDefinitionRegistry;
    private final ImmutableMap<@NonNull GraphQLTypeName, @NonNull ObjectTypeDefinition> graphQLObjectTypes;
    private final Map<GraphQLTypeName, @NonNull ObjectTypeDefinition> entityTypes;
    private final Map<GraphQLTypeName, @NonNull ObjectTypeDefinition> composedTypes;
    private final Map<GraphQLTypeName, ObjectTypeDefinition> aggregatableTypes;
    private final Map<GraphQLTypeName, ObjectTypeDefinition> operationTypes;
    private final @Nullable ObjectTypeDefinition queryType;
    private final @Nullable ObjectTypeDefinition mutationType;
    private final @Nullable ObjectTypeDefinition subscriptionType;

    public SchemaReaderUtil(File schemaFile) {
        this.typeDefinitionRegistry = SchemaReaderUtil.getTypeDefinitionRegistry(schemaFile);
        this.rootPackageName = SchemaReaderUtil.getRootPackageName(this.typeDefinitionRegistry);
        this.graphQLObjectTypes = SchemaReaderUtil.computeGraphQLTypes(this.typeDefinitionRegistry);
        this.entityTypes = Maps.filterValues(this.graphQLObjectTypes, typeDef -> typeDef.hasDirective("entity"));
        this.composedTypes = Maps.filterValues(this.graphQLObjectTypes, typeDef -> typeDef.hasDirective("composedType"));
        HashMap<GraphQLTypeName, @NonNull ObjectTypeDefinition> aggregatableTypes = new HashMap<GraphQLTypeName, ObjectTypeDefinition>(this.entityTypes);
        aggregatableTypes.putAll(this.composedTypes);
        Optional schemaDefinition = this.typeDefinitionRegistry.schemaDefinition();
        if (schemaDefinition.isEmpty()) {
            throw new IllegalStateException("Schema definition is mandatory. Could not find Schema definition.");
        }
        Map<String, OperationTypeDefinition> operationTypesByOpName = ((SchemaDefinition)schemaDefinition.get()).getOperationTypeDefinitions().stream().collect(Collectors.toMap(OperationTypeDefinition::getName, op -> op));
        Map<GraphQLTypeName, OperationTypeDefinition> operationTypesByType = ((SchemaDefinition)schemaDefinition.get()).getOperationTypeDefinitions().stream().collect(Collectors.toMap(operationTypeDefinition -> GraphQLTypeName.of(operationTypeDefinition.getTypeName().getName()), op -> op));
        this.operationTypes = Maps.filterKeys(this.graphQLObjectTypes, operationTypesByType::containsKey);
        OperationTypeDefinition queryOpDef = operationTypesByOpName.get("query");
        if (queryOpDef != null) {
            GraphQLTypeName queryTypeName = GraphQLTypeName.of(queryOpDef.getTypeName().getName());
            this.queryType = (ObjectTypeDefinition)this.graphQLObjectTypes.get((Object)queryTypeName);
            if (this.queryType != null) {
                aggregatableTypes.put(queryTypeName, this.queryType);
            }
        } else {
            this.queryType = null;
        }
        OperationTypeDefinition mutationOpDef = operationTypesByOpName.get("mutation");
        if (mutationOpDef != null) {
            GraphQLTypeName queryTypeName = GraphQLTypeName.of(mutationOpDef.getTypeName().getName());
            this.mutationType = (ObjectTypeDefinition)this.graphQLObjectTypes.get((Object)queryTypeName);
            if (this.mutationType != null) {
                aggregatableTypes.put(queryTypeName, this.mutationType);
            }
        } else {
            this.mutationType = null;
        }
        OperationTypeDefinition subscriptionOpDef = operationTypesByOpName.get("subscription");
        if (subscriptionOpDef != null) {
            GraphQLTypeName queryTypeName = GraphQLTypeName.of(subscriptionOpDef.getTypeName().getName());
            this.subscriptionType = (ObjectTypeDefinition)this.graphQLObjectTypes.get((Object)queryTypeName);
            if (this.subscriptionType != null) {
                aggregatableTypes.put(queryTypeName, this.subscriptionType);
            }
        } else {
            this.subscriptionType = null;
        }
        this.aggregatableTypes = aggregatableTypes;
        this.setFieldVajramsForEachEntity(this.typeDefinitionRegistry);
    }

    private static TypeDefinitionRegistry getTypeDefinitionRegistry(File schemaFile) {
        SchemaParser schemaParser = new SchemaParser();
        TypeDefinitionRegistry typeDefinitionRegistry = new TypeDefinitionRegistry();
        ArrayList<File> files = new ArrayList<File>();
        typeDefinitionRegistry.merge(schemaParser.parse(schemaFile));
        String rootPackageName = SchemaReaderUtil.getRootPackageName(typeDefinitionRegistry);
        String typesPath = rootPackageName.replace('.', File.separatorChar);
        File graphqlsDir = schemaFile.getParentFile().toPath().resolve(typesPath).toFile();
        String[] graphqlSchemaFileNames = graphqlsDir.list((dir, name) -> name.endsWith(GRAPHQL_SCHEMA_EXTENSION));
        if (graphqlSchemaFileNames != null) {
            for (String graphqlSchemaFileName : graphqlSchemaFileNames) {
                File graphqlSchemaFile = new File(graphqlsDir, graphqlSchemaFileName);
                log.info("Found graphql schema file {} ", (Object)graphqlSchemaFile);
                if (!graphqlSchemaFile.exists()) break;
                files.add(graphqlSchemaFile);
            }
        }
        files.forEach(file -> typeDefinitionRegistry.merge(schemaParser.parse(file)));
        return typeDefinitionRegistry;
    }

    private static String getRootPackageName(TypeDefinitionRegistry typeDefinitionRegistry) {
        SchemaDefinition schemaExtensionDefinition = (SchemaDefinition)typeDefinitionRegistry.schemaDefinition().orElseThrow();
        List rootPackages = schemaExtensionDefinition.getDirectives("rootPackage");
        if (rootPackages.size() != 1) {
            throw new IllegalStateException("Expected exactly 1 @rootPackage directive on schema definition. Found :" + rootPackages.size());
        }
        Directive rootPackage = (Directive)rootPackages.get(0);
        return ((StringValue)rootPackage.getArgument("name").getValue()).getValue();
    }

    ClassName typeClassName(GraphQLTypeName graphQLTypeName) {
        return ClassName.get((String)this.getPackageNameForType(graphQLTypeName), (String)graphQLTypeName.value(), (String[])new String[0]);
    }

    boolean hasEntityId(TypeDefinition typeDefinition) {
        if (!(typeDefinition instanceof ObjectTypeDefinition)) {
            return false;
        }
        ObjectTypeDefinition objectTypeDefinition = (ObjectTypeDefinition)typeDefinition;
        return objectTypeDefinition.hasDirective("entity") || objectTypeDefinition.hasDirective("composedType");
    }

    ClassName entityIdClassName(GraphQLTypeName graphQLTypeName) {
        Object t;
        Optional typeDefinition = this.typeDefinitionRegistry.getType(graphQLTypeName.value());
        if (typeDefinition.isEmpty() || !((t = typeDefinition.get()) instanceof ObjectTypeDefinition)) {
            throw new IllegalArgumentException("Only ObjectTypeDefinitions can have entity ids");
        }
        ObjectTypeDefinition objectTypeDefinition = (ObjectTypeDefinition)t;
        boolean isEntity = objectTypeDefinition.hasDirective("entity");
        Optional<String> composedInEntity = SchemaReaderUtil.getDirectiveArgumentString(objectTypeDefinition, "composedType", "inEntity");
        if (composedInEntity.isPresent()) {
            return this.entityIdClassName(this.typeClassName(GraphQLTypeName.of(composedInEntity.get())));
        }
        if (isEntity) {
            return this.entityIdClassName(this.typeClassName(graphQLTypeName));
        }
        throw new IllegalArgumentException("Only '@entity' and '@composedType' can have entity ids");
    }

    private ClassName entityIdClassName(ClassName entityClassName) {
        return ClassName.get((String)entityClassName.packageName(), (String)(entityClassName.simpleName() + "Id"), (String[])new String[0]);
    }

    public GraphQlFieldSpec fieldSpecFromField(FieldDefinition fieldDefinition, String nestingPrefix, GraphQLTypeName enclosingType) {
        return GraphQlFieldSpec.builder().fieldName(nestingPrefix + fieldDefinition.getName()).fieldDefinition(fieldDefinition).enclosingType(enclosingType).build();
    }

    private void setFieldVajramsForEachEntity(TypeDefinitionRegistry typeRegistry) {
        for (Map.Entry<GraphQLTypeName, ObjectTypeDefinition> entry : this.aggregatableTypes.entrySet()) {
            GraphQLTypeName parentType = entry.getKey();
            ObjectTypeDefinition objectTypeDefinition = entry.getValue();
            HashMap<GraphQlFieldSpec, Fetcher> fieldToFetcherMap = new HashMap<GraphQlFieldSpec, Fetcher>();
            HashMap<GraphQlFieldSpec, ClassName> fieldToTypeAggregator = new HashMap<GraphQlFieldSpec, ClassName>();
            for (FieldDefinition fieldDefinition : objectTypeDefinition.getFieldDefinitions()) {
                Type fieldDefinitionType = fieldDefinition.getType();
                TypeDefinition fieldTypeDefinition = (TypeDefinition)typeRegistry.getType(fieldDefinitionType).orElseThrow(() -> new IllegalStateException("Could not find type for field: " + String.valueOf(fieldDefinition)));
                String path = "";
                if (fieldDefinition.hasDirective("dataFetcher")) {
                    fieldToFetcherMap.put(this.fieldSpecFromField(fieldDefinition, "", parentType), new VajramFetcher(this.getDataFetcherClassName((DirectivesContainer<?>)fieldDefinition), GraphQlFetcherType.SINGLE_FIELD_DATA_FETCHER));
                    continue;
                }
                if (fieldTypeDefinition.hasDirective("entity") && fieldDefinition.hasDirective("idFetcher")) {
                    fieldToFetcherMap.put(this.fieldSpecFromField(fieldDefinition, "", parentType), new VajramFetcher(this.getIdFetcherClassName((DirectivesContainer<?>)fieldDefinition), GraphQlFetcherType.ID_FETCHER));
                    this.addAggregator(fieldDefinition, fieldTypeDefinition, parentType, fieldToTypeAggregator);
                    continue;
                }
                if (fieldTypeDefinition.hasDirective("entity") && fieldDefinition.hasDirective("inferIdFromArgs")) {
                    fieldToFetcherMap.put(this.fieldSpecFromField(fieldDefinition, "", parentType), new SimpleFetcher(GraphQlFetcherType.INHERIT_ID_FROM_ARGS));
                    this.addAggregator(fieldDefinition, fieldTypeDefinition, parentType, fieldToTypeAggregator);
                    continue;
                }
                if (fieldTypeDefinition.hasDirective("composedType") && fieldDefinition.hasDirective("inferIdFromParent")) {
                    fieldToFetcherMap.put(this.fieldSpecFromField(fieldDefinition, "", parentType), new SimpleFetcher(GraphQlFetcherType.INHERIT_ID_FROM_PARENT));
                    this.addAggregator(fieldDefinition, fieldTypeDefinition, parentType, fieldToTypeAggregator);
                    continue;
                }
                this.dfsSchema(fieldDefinition, path, fieldToFetcherMap, typeRegistry, parentType);
            }
            HashMap fetcherToFieldsMap = new HashMap();
            fieldToFetcherMap.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList()))).forEach((fetcher, graphQlFieldSpecs) -> {
                if (graphQlFieldSpecs.size() == 1) {
                    fetcherToFieldsMap.put(fetcher, graphQlFieldSpecs);
                } else if (fetcher instanceof VajramFetcher) {
                    VajramFetcher vajramFetcher = (VajramFetcher)fetcher;
                    VajramFetcher newFetcher = new VajramFetcher(vajramFetcher.vajramClassName(), GraphQlFetcherType.MULTI_FIELD_DATA_FETCHER);
                    for (GraphQlFieldSpec graphQlFieldSpec : graphQlFieldSpecs) {
                        fieldToFetcherMap.replace(graphQlFieldSpec, newFetcher);
                    }
                    fetcherToFieldsMap.put(newFetcher, graphQlFieldSpecs);
                }
            });
            this.entityTypeToFieldToFetcher.put(parentType, fieldToFetcherMap);
            this.typeToFetcherToFields.put(parentType, fetcherToFieldsMap);
            this.entityTypeToFieldToTypeAggregator.put(parentType, fieldToTypeAggregator);
        }
    }

    private void addAggregator(FieldDefinition fieldDefinition, TypeDefinition fieldTypeDefinition, GraphQLTypeName type, Map<GraphQlFieldSpec, ClassName> fieldToTypeAggregator) {
        Type fieldDefinitionType = fieldDefinition.getType();
        while (fieldDefinitionType instanceof NonNullType) {
            NonNullType nonNullType = (NonNullType)fieldDefinitionType;
            fieldDefinitionType = nonNullType.getType();
        }
        while (fieldDefinitionType instanceof ListType) {
            ListType listType = (ListType)fieldDefinitionType;
            fieldDefinitionType = listType.getType();
            while (fieldDefinitionType instanceof NonNullType) {
                NonNullType nonNullType = (NonNullType)fieldDefinitionType;
                fieldDefinitionType = nonNullType.getType();
            }
        }
        if (!(fieldDefinitionType instanceof TypeName)) {
            return;
        }
        try {
            GraphQLTypeName graphQlTypeName = new GraphQLTypeName(fieldTypeDefinition.getName());
            String packageName = this.getPackageNameForType(graphQlTypeName);
            String typeAggregatorSimpleName = graphQlTypeName.value() + "_GQlAggr";
            fieldToTypeAggregator.put(this.fieldSpecFromField(fieldDefinition, "", type), ClassName.get((String)packageName, (String)typeAggregatorSimpleName, (String[])new String[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void dfsSchema(FieldDefinition incomingField, String path, Map<GraphQlFieldSpec, Fetcher> fieldToResolverMap, TypeDefinitionRegistry typeRegistry, GraphQLTypeName enclosingType) {
        ObjectTypeDefinition typeDefinitionCast;
        String newPath;
        TypeDefinition typeDefinition;
        block9: {
            block8: {
                typeDefinition = (TypeDefinition)typeRegistry.getType(incomingField.getType()).orElseThrow();
                newPath = path + incomingField.getName() + ".";
                if (!(typeDefinition instanceof ObjectTypeDefinition)) break block8;
                typeDefinitionCast = (ObjectTypeDefinition)typeDefinition;
                if (typeDefinition.hasDirective("dataFetcher")) break block9;
            }
            if (!(typeDefinition instanceof ScalarTypeDefinition)) {
                if (!(typeDefinition instanceof EnumTypeDefinition)) return;
            }
            if (!typeDefinition.hasDirective("dataFetcher")) return;
            fieldToResolverMap.put(this.fieldSpecFromField(incomingField, newPath, enclosingType), new VajramFetcher(this.getDataFetcherClassName((DirectivesContainer<?>)incomingField), GraphQlFetcherType.SINGLE_FIELD_DATA_FETCHER));
            return;
        }
        VajramFetcher baseFetcher = new VajramFetcher(this.getDataFetcherClassName((DirectivesContainer<?>)typeDefinition), GraphQlFetcherType.MULTI_FIELD_DATA_FETCHER);
        Iterator iterator = typeDefinitionCast.getFieldDefinitions().iterator();
        while (iterator.hasNext()) {
            FieldDefinition fieldDefinition = (FieldDefinition)iterator.next();
            if (fieldDefinition.hasDirective("dataFetcher")) {
                fieldToResolverMap.put(this.fieldSpecFromField(fieldDefinition, newPath, enclosingType), new VajramFetcher(this.getDataFetcherClassName((DirectivesContainer<?>)fieldDefinition), GraphQlFetcherType.SINGLE_FIELD_DATA_FETCHER));
                continue;
            }
            Object var13_13 = typeRegistry.getType(fieldDefinition.getType()).orElse(null);
            if (var13_13 instanceof ObjectTypeDefinition) {
                ObjectTypeDefinition innerFieldTypeDef = var13_13;
                if (innerFieldTypeDef.hasDirective("dataFetcher")) {
                    this.dfsSchema(fieldDefinition, newPath, fieldToResolverMap, typeRegistry, enclosingType);
                    continue;
                }
                fieldToResolverMap.put(this.fieldSpecFromField(fieldDefinition, newPath, GraphQLTypeName.of(innerFieldTypeDef)), baseFetcher);
                continue;
            }
            fieldToResolverMap.put(this.fieldSpecFromField(fieldDefinition, newPath, enclosingType), baseFetcher);
        }
    }

    private @NonNull String getPackageNameFromDirective(DirectivesContainer<?> directivesContainer, @Nullable String directiveName) {
        if (directiveName == null) {
            return this.rootPackageName;
        }
        String subPackagePart = SchemaReaderUtil.getDirectiveArgumentString(directivesContainer, directiveName, "subPackage").map(s -> "." + s).orElse("");
        return this.rootPackageName + subPackagePart;
    }

    public ClassName getDataFetcherClassName(DirectivesContainer<?> directivesContainer) {
        String packageName = this.getPackageNameFromDirective(directivesContainer, "dataFetcher");
        return ClassName.get((String)packageName, (String)SchemaReaderUtil.getDirectiveArgumentString(directivesContainer, "dataFetcher", "vajramId").orElseThrow(), (String[])new String[0]);
    }

    public ClassName getIdFetcherClassName(DirectivesContainer<?> directivesContainer) {
        return ClassName.get((String)this.getPackageNameFromDirective(directivesContainer, "idFetcher"), (String)SchemaReaderUtil.getDirectiveArgumentString(directivesContainer, "idFetcher", "vajramId").orElseThrow(), (String[])new String[0]);
    }

    private static ImmutableMap<GraphQLTypeName, ObjectTypeDefinition> computeGraphQLTypes(TypeDefinitionRegistry typeRegistry) {
        HashMap<GraphQLTypeName, ObjectTypeDefinition> entityTypesToDefinition = new HashMap<GraphQLTypeName, ObjectTypeDefinition>();
        for (TypeDefinition typeDefinition : typeRegistry.types().values()) {
            if (!(typeDefinition instanceof ObjectTypeDefinition)) continue;
            ObjectTypeDefinition objectTypeDefinition = (ObjectTypeDefinition)typeDefinition;
            entityTypesToDefinition.put(GraphQLTypeName.of(typeDefinition.getName()), objectTypeDefinition);
        }
        return ImmutableMap.copyOf(entityTypesToDefinition);
    }

    static Optional<String> getDirectiveArgumentString(DirectivesContainer<?> element, String directiveName, String argName) {
        List directives = element.getDirectives(directiveName);
        if (directives.isEmpty()) {
            return Optional.empty();
        }
        Argument argument = ((Directive)directives.get(0)).getArgument(argName);
        return argument == null ? Optional.empty() : Optional.ofNullable((StringValue)argument.getValue()).map(StringValue::getValue);
    }

    String getPackageNameForType(GraphQLTypeName graphQLTypeName) {
        TypeDefinition objectTypeDefinition = Objects.requireNonNull((TypeDefinition)this.typeDefinitionRegistry().types().get(graphQLTypeName.value()), () -> "Could not find type definition for type: " + String.valueOf(graphQLTypeName));
        Object subPackage = SchemaReaderUtil.getDirectiveArgumentString(objectTypeDefinition, "subPackage", "name").orElse(graphQLTypeName.value().toLowerCase()).trim();
        if (!((String)subPackage).isEmpty()) {
            subPackage = "." + (String)subPackage;
        }
        return this.rootPackageName + (String)subPackage;
    }

    public String getEntityIdFieldName(TypeDefinition fieldTypeDef) {
        return SchemaReaderUtil.getDirectiveArgumentString(fieldTypeDef, "entity", "entityIdField").orElse("id");
    }

    public Optional<GraphQLTypeName> getComposingEntityType(ObjectTypeDefinition typeDefinition) {
        return typeDefinition.hasDirective("entity") ? Optional.of(GraphQLTypeName.of(typeDefinition)) : SchemaReaderUtil.getDirectiveArgumentString(typeDefinition, "composedType", "inEntity").map(GraphQLTypeName::of);
    }

    @Generated
    Map<GraphQLTypeName, Map<GraphQlFieldSpec, ClassName>> entityTypeToFieldToTypeAggregator() {
        return this.entityTypeToFieldToTypeAggregator;
    }

    @Generated
    Map<GraphQLTypeName, Map<GraphQlFieldSpec, Fetcher>> entityTypeToFieldToFetcher() {
        return this.entityTypeToFieldToFetcher;
    }

    @Generated
    Map<GraphQLTypeName, Map<Fetcher, List<GraphQlFieldSpec>>> typeToFetcherToFields() {
        return this.typeToFetcherToFields;
    }

    @Generated
    public String rootPackageName() {
        return this.rootPackageName;
    }

    @Generated
    public TypeDefinitionRegistry typeDefinitionRegistry() {
        return this.typeDefinitionRegistry;
    }

    @Generated
    public ImmutableMap<@NonNull GraphQLTypeName, @NonNull ObjectTypeDefinition> graphQLObjectTypes() {
        return this.graphQLObjectTypes;
    }

    @Generated
    public Map<GraphQLTypeName, @NonNull ObjectTypeDefinition> entityTypes() {
        return this.entityTypes;
    }

    @Generated
    public Map<GraphQLTypeName, @NonNull ObjectTypeDefinition> composedTypes() {
        return this.composedTypes;
    }

    @Generated
    public Map<GraphQLTypeName, ObjectTypeDefinition> aggregatableTypes() {
        return this.aggregatableTypes;
    }

    @Generated
    public Map<GraphQLTypeName, ObjectTypeDefinition> operationTypes() {
        return this.operationTypes;
    }

    @Generated
    public @Nullable ObjectTypeDefinition queryType() {
        return this.queryType;
    }

    @Generated
    public @Nullable ObjectTypeDefinition mutationType() {
        return this.mutationType;
    }

    @Generated
    public @Nullable ObjectTypeDefinition subscriptionType() {
        return this.subscriptionType;
    }
}

