/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.Constants;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.model.PlainJavaObject;
import com.flipkart.krystal.vajram.ComputeVajramDef;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.facets.Dependency;
import com.flipkart.krystal.vajram.facets.FanoutCommand;
import com.flipkart.krystal.vajram.facets.One2OneCommand;
import com.flipkart.krystal.vajram.facets.Output;
import com.flipkart.krystal.vajram.facets.resolution.Resolve;
import com.flipkart.krystal.vajram.graphql.api.execution.GraphQLUtils;
import com.flipkart.krystal.vajram.graphql.api.execution.VajramExecutionStrategy;
import com.flipkart.krystal.vajram.graphql.api.model.GraphQlResponseJson;
import com.flipkart.krystal.vajram.graphql.api.traits.GraphQlOperationAggregate;
import com.flipkart.krystal.vajram.graphql.codegen.CodeGenConstants;
import com.flipkart.krystal.vajram.graphql.codegen.Fetcher;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQLTypeName;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQlCodeGenUtil;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQlFetcherType;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQlFieldSpec;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQlTypeDecorator;
import com.flipkart.krystal.vajram.graphql.codegen.SchemaReaderUtil;
import com.flipkart.krystal.vajram.graphql.codegen.VajramFetcher;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategyParameters;
import graphql.language.DirectivesContainer;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.TypeDefinition;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;
import lombok.Generated;
import lombok.extern.slf4j.Slf4j;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLObjectAggregateGen
implements CodeGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLObjectAggregateGen.class);
    public static final String GRAPHQL_RESPONSE = "_GQlFields";
    private final CodeGenUtility util;
    private final SchemaReaderUtil schemaReaderUtil;
    private final GraphQlCodeGenUtil graphQlCodeGenUtil;

    public GraphQLObjectAggregateGen(CodeGenUtility util, File schemaFile) {
        this.util = util;
        this.graphQlCodeGenUtil = new GraphQlCodeGenUtil(schemaFile);
        this.schemaReaderUtil = this.graphQlCodeGenUtil.schemaReaderUtil();
    }

    public void generate() {
        Map<GraphQLTypeName, ObjectTypeDefinition> aggregatableTypes = this.schemaReaderUtil.aggregatableTypes();
        this.util.note((CharSequence)"Generating typeAggregators for aggregatable types : '%s'".formatted(aggregatableTypes));
        aggregatableTypes.forEach((objectTypeName, typeDefinition) -> {
            try {
                ClassName className = this.getAggregatorName((GraphQLTypeName)objectTypeName);
                Map<ClassName, List<GraphQlFieldSpec>> refToFieldMap = this.getDfToListOfFieldsDeRef((ObjectTypeDefinition)typeDefinition);
                TypeSpec.Builder typeAggregator = this.util.classBuilder(className.simpleName(), "").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ComputeVajramDef.class), (TypeName[])new TypeName[]{this.asVajramReturnType((GraphQLTypeName)objectTypeName)})).addAnnotation(Vajram.class).addAnnotation(AnnotationSpec.builder(Slf4j.class).build()).addTypes(this.createFacetDefinitions((ObjectTypeDefinition)typeDefinition)).addMethods(this.getInputResolvers((GraphQLTypeName)objectTypeName, (ObjectTypeDefinition)typeDefinition)).addMethod(this.outputLogic((GraphQLTypeName)objectTypeName));
                ObjectTypeDefinition queryType = this.schemaReaderUtil.queryType();
                if (queryType != null && queryType.getName().equals(objectTypeName.value())) {
                    typeAggregator.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(GraphQlOperationAggregate.class), (TypeName[])new TypeName[]{this.asVajramReturnType((GraphQLTypeName)objectTypeName)}));
                }
                refToFieldMap.forEach((vajramClass, graphQlFieldSpecs) -> {
                    String vajramId = vajramClass.simpleName();
                    typeAggregator.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get(Set.class, (Type[])new Type[]{String.class}), (String)(vajramId + "_FIELDS"), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.of($L)", new Object[]{Set.class, graphQlFieldSpecs.stream().map(f -> CodeBlock.of((String)"$S", (Object[])new Object[]{f.fieldName()})).collect(CodeBlock.joining((String)","))}).build());
                });
                JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)typeAggregator.build()).build();
                StringWriter writer = new StringWriter();
                try {
                    javaFile.writeTo((Appendable)writer);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    try {
                        JavaFileObject requestFile = this.util.processingEnv().getFiler().createSourceFile(className.canonicalName(), new Element[0]);
                        this.util.note((CharSequence)"Successfully Create source file %s".formatted(className));
                        try (PrintWriter out = new PrintWriter(requestFile.openWriter());){
                            out.println(writer);
                        }
                    }
                    catch (Exception e) {
                        this.util.error("Error creating java file for className: %s. Error: %s".formatted(className, e), new Element[0]);
                    }
                }
                catch (Exception e) {
                    StringWriter exception = new StringWriter();
                    e.printStackTrace(new PrintWriter(exception));
                    this.util.error("Error while generating file for class %s. Exception: %s".formatted(className, exception), new Element[0]);
                }
            }
            catch (Throwable e) {
                this.util.error("Error generating GraphQl Object Aggregator for object type '%s' due to exception '%s'".formatted(objectTypeName, Throwables.getStackTraceAsString((Throwable)e)), new Element[0]);
            }
        });
    }

    private ClassName asVajramReturnType(GraphQLTypeName objectTypeName) {
        ClassName className = this.schemaReaderUtil.typeClassName(objectTypeName);
        return ClassName.get((String)className.packageName(), (String)(className.simpleName() + "_Immut"), (String[])new String[0]).nestedClass("Builder");
    }

    private ClassName getAggregatorName(GraphQLTypeName typeName) {
        return ClassName.get((String)this.schemaReaderUtil.getPackageNameForType(typeName), (String)(typeName.value() + "_GQlAggr"), (String[])new String[0]);
    }

    private List<TypeSpec> createFacetDefinitions(ObjectTypeDefinition typeDefinition) {
        GraphQLTypeName typeName = GraphQLTypeName.of(typeDefinition);
        TypeSpec.Builder inputs = TypeSpec.classBuilder((String)"_Inputs").addModifiers(new Modifier[]{Modifier.STATIC});
        if (this.schemaReaderUtil.hasEntityId((TypeDefinition)typeDefinition)) {
            inputs.addField(FieldSpec.builder((TypeName)this.schemaReaderUtil.entityIdClassName(typeName), (String)"graphql_entityId", (Modifier[])new Modifier[0]).addAnnotation(CodeGenConstants.IF_ABSENT_FAIL).build());
        }
        inputs.addField(FieldSpec.builder(ExecutionContext.class, (String)"graphql_executionContext", (Modifier[])new Modifier[0]).addAnnotation(CodeGenConstants.IF_ABSENT_FAIL).build());
        inputs.addField(FieldSpec.builder((TypeName)ClassName.get(VajramExecutionStrategy.class), (String)"graphql_executionStrategy", (Modifier[])new Modifier[0]).addAnnotation(CodeGenConstants.IF_ABSENT_FAIL).build());
        inputs.addField(FieldSpec.builder(ExecutionStrategyParameters.class, (String)"graphql_executionStrategyParams", (Modifier[])new Modifier[0]).addAnnotation(CodeGenConstants.IF_ABSENT_FAIL).build());
        TypeSpec.Builder internalFacets = TypeSpec.classBuilder((String)"_InternalFacets").addModifiers(new Modifier[]{Modifier.STATIC});
        Map<Fetcher, List<GraphQlFieldSpec>> fetcherToFields = this.schemaReaderUtil.typeToFetcherToFields().get(typeName);
        for (Map.Entry<Fetcher, List<GraphQlFieldSpec>> entry : fetcherToFields.entrySet()) {
            Fetcher fetcher = entry.getKey();
            if (!(fetcher instanceof VajramFetcher)) continue;
            VajramFetcher fetcher2 = (VajramFetcher)fetcher;
            List<GraphQlFieldSpec> fields = entry.getValue();
            internalFacets.addField(FieldSpec.builder((TypeName)this.getFetcherResponseType(fetcher2, fields), (String)GraphQLObjectAggregateGen.getFacetName(fetcher2, fields), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(Dependency.class).addMember("onVajram", "$T.class", new Object[]{fetcher2.vajramClassName()}).build()).build());
        }
        for (Map.Entry<Object, List<GraphQlFieldSpec>> entry : this.schemaReaderUtil.entityTypeToFieldToTypeAggregator().get(typeName).entrySet()) {
            GraphQlFieldSpec fieldSpec = (GraphQlFieldSpec)entry.getKey();
            ClassName typeAggregatorClassName = (ClassName)entry.getValue();
            AnnotationSpec.Builder depAnnotation = AnnotationSpec.builder(Dependency.class).addMember("onVajram", "$T.class", new Object[]{typeAggregatorClassName});
            if (this.isGraphQlList(fieldSpec)) {
                depAnnotation.addMember("canFanout", "true", new Object[0]);
            }
            internalFacets.addField(FieldSpec.builder((TypeName)this.asVajramReturnType(fieldSpec), (String)fieldSpec.fieldName(), (Modifier[])new Modifier[0]).addAnnotation(depAnnotation.build()).build());
        }
        return List.of(inputs.build(), internalFacets.build());
    }

    private ClassName asVajramReturnType(GraphQlFieldSpec fieldSpec) {
        return this.asVajramReturnType(GraphQLTypeName.of((TypeDefinition)this.schemaReaderUtil.typeDefinitionRegistry().getType(this.getDeclaredActualFieldType(fieldSpec).graphQlType()).orElseThrow()));
    }

    private GraphQlTypeDecorator getDeclaredActualFieldType(GraphQlFieldSpec fieldSpec) {
        GraphQlTypeDecorator currentType = fieldSpec.fieldType();
        if (currentType.isNonNull()) {
            currentType = currentType.innerType();
        }
        if (currentType.isList()) {
            currentType = currentType.innerType();
        }
        if (currentType.isNonNull()) {
            currentType = currentType.innerType();
        }
        return currentType;
    }

    private boolean isGraphQlList(GraphQlFieldSpec fieldSpec) {
        GraphQlTypeDecorator currentType = fieldSpec.fieldType();
        if (currentType.isNonNull()) {
            currentType = currentType.innerType();
        }
        return currentType.isList();
    }

    private static String getFacetName(VajramFetcher fetcher, List<GraphQlFieldSpec> fields) {
        return switch (fetcher.type()) {
            case GraphQlFetcherType.MULTI_FIELD_DATA_FETCHER, GraphQlFetcherType.ID_FETCHER -> fetcher.vajramClassName().simpleName();
            default -> fields.get(0).fieldName();
        };
    }

    private TypeName getFetcherResponseType(VajramFetcher fetcher, List<GraphQlFieldSpec> fieldsDeRef) {
        Object responseType;
        ClassName fetcherClassName = fetcher.vajramClassName();
        if (fieldsDeRef.size() == 1) {
            GraphQlFieldSpec fieldSpec = fieldsDeRef.get(0);
            FieldDefinition fieldDefinition = fieldSpec.fieldDefinition();
            Optional typeDefinition = this.schemaReaderUtil.typeDefinitionRegistry().getType(fieldDefinition.getType());
            if (typeDefinition.isPresent() && this.schemaReaderUtil.hasEntityId((TypeDefinition)typeDefinition.get())) {
                ClassName entityIdClassName = this.schemaReaderUtil.entityIdClassName(GraphQLTypeName.of((TypeDefinition)typeDefinition.get()));
                GraphQlTypeDecorator innerType = fieldSpec.fieldType();
                boolean isInnerNonNull = false;
                if (innerType.isNonNull()) {
                    innerType = innerType.innerType();
                }
                boolean isList = false;
                if (innerType.isList()) {
                    innerType = innerType.innerType();
                    isList = true;
                }
                if (innerType.isNonNull()) {
                    isInnerNonNull = true;
                }
                responseType = isList ? ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{isInnerNonNull ? entityIdClassName : entityIdClassName.annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()})}) : entityIdClassName;
            } else {
                responseType = this.graphQlCodeGenUtil.toTypeNameForField(fieldSpec.fieldType(), fieldSpec);
            }
        } else {
            responseType = ClassName.get((String)fetcherClassName.packageName(), (String)(fetcherClassName.simpleName() + GRAPHQL_RESPONSE), (String[])new String[0]);
        }
        return responseType;
    }

    private Map<ClassName, List<GraphQlFieldSpec>> getDfToListOfFieldsDeRef(ObjectTypeDefinition typeDefinition) {
        HashMap<ClassName, List<GraphQlFieldSpec>> dfToListOfFieldsDeRef = new HashMap<ClassName, List<GraphQlFieldSpec>>();
        GraphQLTypeName enclosingType = GraphQLTypeName.of(typeDefinition);
        typeDefinition.getFieldDefinitions().forEach(field -> {
            if (field.hasDirective("dataFetcher")) {
                dfToListOfFieldsDeRef.computeIfAbsent(this.schemaReaderUtil.getDataFetcherClassName((DirectivesContainer<?>)field), k -> new ArrayList()).add(this.schemaReaderUtil.fieldSpecFromField((FieldDefinition)field, "", enclosingType));
            } else if (field.hasDirective("idFetcher")) {
                dfToListOfFieldsDeRef.computeIfAbsent(this.schemaReaderUtil.getIdFetcherClassName((DirectivesContainer<?>)field), k -> new ArrayList()).add(this.schemaReaderUtil.fieldSpecFromField((FieldDefinition)field, "", enclosingType));
            }
        });
        return dfToListOfFieldsDeRef;
    }

    private CodeBlock getFieldSetters(VajramFetcher fetcher, List<GraphQlFieldSpec> graphQlFieldSpecs) {
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        String facetName = GraphQLObjectAggregateGen.getFacetName(fetcher, graphQlFieldSpecs);
        for (GraphQlFieldSpec graphQlFieldSpec : graphQlFieldSpecs) {
            boolean canFanout = this.isGraphQlList(graphQlFieldSpec);
            if (GraphQlFetcherType.TYPE_AGGREGATOR.equals((Object)fetcher.type()) && canFanout) {
                codeBlockBuilder.addNamed("entity.$fieldName:L($errable:T.withValue($facetName:L.responses()));\n", Map.ofEntries(Map.entry("facetName", facetName), Map.entry("fieldName", graphQlFieldSpec.fieldName()), Map.entry("errable", Errable.class)));
                continue;
            }
            codeBlockBuilder.addNamed("$facetName:L.handle(\n    _failure -> entity.$fieldName:L(_failure.cast()),\n    _nonNil -> entity.$fieldName:L(_nonNil.value()$fieldExtractor:L));\n\n", Map.ofEntries(Map.entry("facetName", facetName), Map.entry("fieldName", graphQlFieldSpec.fieldName()), Map.entry("fieldExtractor", graphQlFieldSpecs.size() > 1 ? CodeBlock.of((String)".$L()", (Object[])new Object[]{graphQlFieldSpec.fieldName()}) : CodeBlock.of((String)"", (Object[])new Object[0]))));
        }
        return codeBlockBuilder.build();
    }

    private MethodSpec outputLogic(GraphQLTypeName objectTypeName) {
        TypeDefinition objectTypeDefinition = (TypeDefinition)this.schemaReaderUtil.typeDefinitionRegistry().getType(objectTypeName.value()).orElseThrow();
        boolean isEntity = objectTypeDefinition.hasDirective("entity");
        String entityIdFieldName = this.schemaReaderUtil.getEntityIdFieldName(objectTypeDefinition);
        ClassName immutGQlRespJsonClassName = this.getImmutGQlRespJsonClassName(objectTypeName);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"output").addAnnotation(Output.class).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)this.asVajramReturnType(objectTypeName));
        if (isEntity) {
            builder.addParameter((TypeName)this.schemaReaderUtil.entityIdClassName(objectTypeName), "graphql_entityId", new Modifier[0]);
        }
        builder.addStatement("$T.Builder entity = $T._builder()$L", new Object[]{immutGQlRespJsonClassName, immutGQlRespJsonClassName, isEntity ? CodeBlock.of((String)".$L($L)", (Object[])new Object[]{entityIdFieldName, "graphql_entityId"}) : Constants.EMPTY_CODE_BLOCK});
        this.schemaReaderUtil.typeToFetcherToFields().getOrDefault(objectTypeName, Map.of()).forEach((fetcher, fields) -> {
            VajramFetcher vajramFetcher;
            if (!(fetcher instanceof VajramFetcher) || (vajramFetcher = (VajramFetcher)fetcher).type().equals((Object)GraphQlFetcherType.ID_FETCHER)) {
                return;
            }
            builder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Errable.class), (TypeName[])new TypeName[]{this.getFetcherResponseType(vajramFetcher, (List<GraphQlFieldSpec>)fields)}), GraphQLObjectAggregateGen.getFacetName(vajramFetcher, fields), new Modifier[0]);
            builder.addCode("$L", new Object[]{this.getFieldSetters(vajramFetcher, (List<GraphQlFieldSpec>)fields)});
        });
        this.schemaReaderUtil.entityTypeToFieldToTypeAggregator().getOrDefault(objectTypeName, Map.of()).forEach((fieldSpec, aggregatorClassName) -> {
            VajramFetcher fetcher = new VajramFetcher((ClassName)aggregatorClassName, GraphQlFetcherType.TYPE_AGGREGATOR);
            boolean canFanout = this.isGraphQlList((GraphQlFieldSpec)fieldSpec);
            builder.addParameter((TypeName)(canFanout ? ParameterizedTypeName.get((ClassName)ClassName.get(FanoutDepResponses.class), (TypeName[])new TypeName[]{GraphQLObjectAggregateGen.getRequestClassName(aggregatorClassName), this.asVajramReturnType((GraphQlFieldSpec)fieldSpec)}) : ParameterizedTypeName.get((ClassName)ClassName.get(Errable.class), (TypeName[])new TypeName[]{this.asVajramReturnType((GraphQlFieldSpec)fieldSpec)})), fieldSpec.fieldName(), new Modifier[0]);
            builder.addCode("$L", new Object[]{this.getFieldSetters(fetcher, List.of(fieldSpec))});
        });
        builder.addParameter(ExecutionContext.class, "graphql_executionContext", new Modifier[0]);
        builder.addParameter(VajramExecutionStrategy.class, "graphql_executionStrategy", new Modifier[0]);
        builder.addParameter(ExecutionStrategyParameters.class, "graphql_executionStrategyParams", new Modifier[0]);
        return builder.addStatement("return entity\n    .graphql_executionStrategy(graphql_executionStrategy)\n    .graphql_executionContext(graphql_executionContext)\n    .graphql_executionStrategyParams(graphql_executionStrategyParams)", new Object[0]).build();
    }

    private ClassName getImmutGQlRespJsonClassName(GraphQLTypeName objectTypeName) {
        return ClassName.get((String)this.schemaReaderUtil.getPackageNameForType(objectTypeName), (String)(objectTypeName.value() + "_Immut" + GraphQlResponseJson.INSTANCE.modelClassesSuffix()), (String[])new String[0]);
    }

    private List<MethodSpec> getInputResolvers(GraphQLTypeName entityType, ObjectTypeDefinition typeDefinition) {
        ArrayList<MethodSpec> methodSpecList = new ArrayList<MethodSpec>();
        this.schemaReaderUtil.typeToFetcherToFields().get(entityType).forEach((fetcher, fields) -> {
            if (fetcher instanceof VajramFetcher) {
                VajramFetcher vajramFetcher = (VajramFetcher)fetcher;
                methodSpecList.add(this.createFetcherInputResolver(vajramFetcher, (List<GraphQlFieldSpec>)fields, entityType, (TypeDefinition)typeDefinition));
            }
        });
        this.schemaReaderUtil.entityTypeToFieldToTypeAggregator().get(entityType).forEach((field, typeAggregatorClass) -> {
            @Nullable Fetcher fetcher = this.schemaReaderUtil.entityTypeToFieldToFetcher().get(entityType).get(field);
            if (fetcher != null) {
                methodSpecList.add(this.createTypeAggregatorInputResolver(fetcher, entityType, typeDefinition, (GraphQlFieldSpec)field, (ClassName)typeAggregatorClass));
            }
        });
        return methodSpecList;
    }

    private MethodSpec createFetcherInputResolver(VajramFetcher fetcher, List<GraphQlFieldSpec> fields, GraphQLTypeName parentTypeName, TypeDefinition parentTypeDef) {
        String vajramId = fetcher.vajramClassName().simpleName();
        ClassName vajramReqClass = GraphQLObjectAggregateGen.getRequestClassName(fetcher.vajramClassName());
        boolean isParentOpType = this.schemaReaderUtil.operationTypes().containsKey(parentTypeName);
        boolean parentTypeHasEntityId = !isParentOpType;
        String facetName = GraphQLObjectAggregateGen.getFacetName(fetcher, fields);
        ArrayList<CodeBlock> depInputNames = new ArrayList<CodeBlock>();
        ArrayList<CodeBlock> depInputSetterCode = new ArrayList<CodeBlock>();
        if (parentTypeHasEntityId) {
            depInputNames.add(CodeBlock.of((String)"$T.$L_n", (Object[])new Object[]{vajramReqClass, this.schemaReaderUtil.getEntityIdFieldName(parentTypeDef)}));
            depInputSetterCode.add(CodeBlock.of((String)".$L($L)", (Object[])new Object[]{this.schemaReaderUtil.getEntityIdFieldName(parentTypeDef), "graphql_entityId"}));
        }
        if (fields.size() == 1) {
            for (InputValueDefinition inputValueDefinition : fields.get(0).fieldDefinition().getInputValueDefinitions()) {
                String argName = inputValueDefinition.getName();
                depInputNames.add(CodeBlock.of((String)"$T.$L_n", (Object[])new Object[]{vajramReqClass, argName}));
                depInputSetterCode.add(CodeBlock.of((String)".$L($L.getExecutionStepInfo().getArgument($S))", (Object[])new Object[]{argName, "graphql_executionStrategyParams_new", argName}));
            }
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)facetName).addAnnotation(AnnotationSpec.builder(Resolve.class).addMember("dep", "$T.$L_n", new Object[]{GraphQLObjectAggregateGen.getFacetClassName(this.getAggregatorName(parentTypeName)), facetName}).addMember("depInputs", "$L", new Object[]{depInputNames.stream().collect(CodeBlock.joining((String)",", (String)"{", (String)"}"))}).build()).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(One2OneCommand.class), (TypeName[])new TypeName[]{GraphQLObjectAggregateGen.getRequestClassName(fetcher.vajramClassName())})).addParameter(ExecutionContext.class, "graphql_executionContext", new Modifier[0]).addParameter(VajramExecutionStrategy.class, "graphql_executionStrategy", new Modifier[0]).addParameter(ExecutionStrategyParameters.class, "graphql_executionStrategyParams", new Modifier[0]).addCode("            if ($T.isAnyFieldQueried($L_FIELDS, $L)) {\n              $L\n              return $T.executeWith(\n                  $T._builder()\n                      $L);\n            } else {\n              return $T.skipExecution($S);\n            }\n", new Object[]{GraphQLUtils.class, vajramId, "graphql_executionStrategyParams", fields.size() == 1 ? CodeBlock.of((String)"              var graphql_executionStrategyParams_new =\n                  graphql_executionStrategy.newParametersForFieldExecution(\n                      graphql_executionContext,\n                      graphql_executionStrategyParams,\n                      graphql_executionStrategyParams.getFields().getSubField($S));\n", (Object[])new Object[]{fields.get(0).fieldName()}) : Constants.EMPTY_CODE_BLOCK, One2OneCommand.class, ClassName.get((String)fetcher.vajramClassName().packageName(), (String)(fetcher.vajramClassName().simpleName() + "_ReqImmut" + PlainJavaObject.POJO.modelClassesSuffix()), (String[])new String[0]), depInputSetterCode.stream().collect(CodeBlock.joining((String)"\n")), One2OneCommand.class, vajramId});
        if (parentTypeHasEntityId) {
            methodBuilder.addParameter((TypeName)this.schemaReaderUtil.entityIdClassName(parentTypeName), "graphql_entityId", new Modifier[0]);
        }
        return methodBuilder.build();
    }

    private static ClassName getRequestClassName(ClassName vajramClass) {
        return ClassName.get((String)vajramClass.packageName(), (String)(vajramClass.simpleName() + "_Req"), (String[])new String[0]);
    }

    private static ClassName getFacetClassName(ClassName aggregatorName) {
        return ClassName.get((String)aggregatorName.packageName(), (String)(aggregatorName.simpleName() + "_Fac"), (String[])new String[0]);
    }

    private MethodSpec createTypeAggregatorInputResolver(Fetcher fetcher, GraphQLTypeName parentTypeName, ObjectTypeDefinition parentTypeDefinition, GraphQlFieldSpec fieldSpec, ClassName typeAggregatorClass) {
        String string;
        SchemaReaderUtil.getDirectiveArgumentString(parentTypeDefinition, "composedType", "inEntity");
        Optional<GraphQLTypeName> parentComposingEntityType = this.schemaReaderUtil.getComposingEntityType(parentTypeDefinition);
        boolean isParentOpType = this.schemaReaderUtil.operationTypes().containsKey(parentTypeName);
        boolean parentTypeHasEntityId = !isParentOpType;
        boolean canFanout = this.isGraphQlList(fieldSpec);
        ObjectTypeDefinition fieldTypeDef = (ObjectTypeDefinition)this.schemaReaderUtil.typeDefinitionRegistry().getType(fieldSpec.fieldType().graphQlType()).orElseThrow(() -> new IllegalStateException("Could not find type " + String.valueOf(fieldSpec.fieldType().graphQlType()) + " of field " + String.valueOf(fieldSpec.fieldDefinition())));
        GraphQLTypeName fieldTypeName = GraphQLTypeName.of(fieldTypeDef);
        Optional<GraphQLTypeName> fieldComposingEntityType = this.schemaReaderUtil.getComposingEntityType(fieldTypeDef);
        ClassName vajramReqClass = GraphQLObjectAggregateGen.getRequestClassName(typeAggregatorClass);
        String fieldName = fieldSpec.fieldName();
        if (fetcher instanceof VajramFetcher) {
            VajramFetcher vajramFetcher = (VajramFetcher)fetcher;
            string = vajramFetcher.vajramClassName().simpleName();
        } else {
            string = parentTypeHasEntityId ? "graphql_entityId" : "";
        }
        String entityIdFacetName = string;
        String entityIdFieldName = this.schemaReaderUtil.getEntityIdFieldName((TypeDefinition)fieldTypeDef);
        GraphQlFetcherType fetcherType = fetcher.type();
        if (isParentOpType) {
            if (fetcherType == GraphQlFetcherType.INHERIT_ID_FROM_ARGS) {
                if (fieldSpec.fieldDefinition().getInputValueDefinitions().size() != 1) {
                    throw this.util.errorAndThrow("Entity fields in operation types must contain exactly one argument: " + fieldName, new Element[0]);
                }
                String argName = ((InputValueDefinition)fieldSpec.fieldDefinition().getInputValueDefinitions().get(0)).getName();
                if (!entityIdFieldName.equals(argName)) {
                    throw this.util.errorAndThrow("Entity field argument name '%s' in operation type '%s' does not match entity id '%s' of entity '%s'".formatted(argName, parentTypeName.value(), entityIdFieldName, fieldTypeName.value()), new Element[0]);
                }
            } else if (fetcherType == GraphQlFetcherType.INHERIT_ID_FROM_PARENT) {
                throw this.util.errorAndThrow("Entity field '%s' cannot inherit id from parent when parent '%s' is an operation type".formatted(fieldName, parentTypeName.value()), new Element[0]);
            }
        } else if (fetcherType == GraphQlFetcherType.INHERIT_ID_FROM_PARENT && !parentComposingEntityType.equals(fieldComposingEntityType)) {
            throw this.util.errorAndThrow("Directive @inheritFromParent on field '%s' in type '%s' specifies that the field type must be a @composedType whose 'inEntity' argument matches the parent entity of the field. Expected: '%s', Found '%s'\n".formatted(fieldName, parentTypeName.value(), parentComposingEntityType.map(GraphQLTypeName::value).orElse(null), fieldComposingEntityType.map(GraphQLTypeName::value).orElse(null)), new Element[0]);
        }
        CodeBlock entityIdAccessCode = switch (fetcherType) {
            case GraphQlFetcherType.ID_FETCHER -> {
                if (canFanout) {
                    yield CodeBlock.of((String)"$L.valueOpt().get()", (Object[])new Object[]{entityIdFacetName});
                }
                yield CodeBlock.of((String)"_nonNil.value()", (Object[])new Object[0]);
            }
            case GraphQlFetcherType.INHERIT_ID_FROM_ARGS -> CodeBlock.of((String)"new $T($L.getExecutionStepInfo().getArgument($S))", (Object[])new Object[]{this.schemaReaderUtil.entityIdClassName(fieldTypeName), "graphql_executionStrategyParams_new", entityIdFieldName});
            case GraphQlFetcherType.INHERIT_ID_FROM_PARENT -> CodeBlock.of((String)"graphql_entityId", (Object[])new Object[0]);
            default -> null;
        };
        ClassName depReqImmutType = ClassName.get((String)typeAggregatorClass.packageName(), (String)(typeAggregatorClass.simpleName() + "_ReqImmut"), (String[])new String[0]);
        ClassName depReqImmutPojoType = ClassName.get((String)depReqImmutType.packageName(), (String)(depReqImmutType.simpleName() + PlainJavaObject.POJO.modelClassesSuffix()), (String[])new String[0]);
        Map.Entry[] entryArray = new Map.Entry[13];
        entryArray[0] = Map.entry("graphqlUtils", GraphQLUtils.class);
        entryArray[1] = Map.entry("fieldName", fieldName);
        entryArray[2] = Map.entry("fetcherFacetName", entityIdFacetName);
        entryArray[3] = Map.entry("entityIdAccessCode", entityIdAccessCode != null ? entityIdAccessCode : Constants.EMPTY_CODE_BLOCK);
        entryArray[4] = Map.entry("entityType", this.graphQlCodeGenUtil.toTypeNameForField(this.getDeclaredActualFieldType(fieldSpec), fieldSpec));
        entryArray[5] = Map.entry("reqPojoType", depReqImmutPojoType);
        entryArray[6] = Map.entry("facet_entityId", "graphql_entityId");
        entryArray[7] = Map.entry("throwable", Throwable.class);
        entryArray[8] = Map.entry("forLoopStart", entityIdAccessCode != null ? (canFanout ? CodeBlock.of((String)"        $T<$T> _reqs = new $T<>();\n        for (var _entityId : $L) {", (Object[])new Object[]{List.class, depReqImmutType.nestedClass("Builder"), ArrayList.class, entityIdAccessCode}) : CodeBlock.of((String)"var _entityId = $L;", (Object[])new Object[]{entityIdAccessCode})) : Constants.EMPTY_CODE_BLOCK);
        entryArray[9] = Map.entry("forLoopEnd", canFanout ? CodeBlock.of((String)"        _reqs.add(_req);\n        }\n", (Object[])new Object[]{entityIdFacetName}) : CodeBlock.of((String)"", (Object[])new Object[0]));
        entryArray[10] = Map.entry("execute", canFanout ? CodeBlock.of((String)"return $T.executeFanoutWith(_reqs);", (Object[])new Object[]{FanoutCommand.class}) : CodeBlock.of((String)"return $T.executeWith(_req);", (Object[])new Object[]{One2OneCommand.class}));
        entryArray[11] = Map.entry("skip", canFanout ? CodeBlock.of((String)"$T.skipFanout", (Object[])new Object[]{FanoutCommand.class}) : CodeBlock.of((String)"$T.skipExecution", (Object[])new Object[]{One2OneCommand.class}));
        entryArray[12] = Map.entry("skipNotQueried", CodeBlock.of((String)"'$L' not queried", (Object[])new Object[]{fieldName}));
        Map args = Map.ofEntries(entryArray);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)fieldName).addAnnotation(AnnotationSpec.builder(Resolve.class).addMember("dep", "$T.$L_n", new Object[]{GraphQLObjectAggregateGen.getFacetClassName(this.getAggregatorName(parentTypeName)), fieldName}).addMember("depInputs", "{$T.graphql_executionContext_n, $T.graphql_executionStrategy_n, $T.graphql_executionStrategyParams_n, $T.$L_n}", new Object[]{vajramReqClass, vajramReqClass, vajramReqClass, vajramReqClass, "graphql_entityId"}).build()).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(canFanout ? FanoutCommand.class : One2OneCommand.class), (TypeName[])new TypeName[]{depReqImmutType.nestedClass("Builder")})).addParameter(ExecutionContext.class, "graphql_executionContext", new Modifier[0]).addParameter(VajramExecutionStrategy.class, "graphql_executionStrategy", new Modifier[0]).addParameter(ExecutionStrategyParameters.class, "graphql_executionStrategyParams", new Modifier[0]).addNamedCode("    if (!$graphqlUtils:T.isFieldQueried($fieldName:S, graphql_executionStrategyParams)){\n      return $skip:L($skipNotQueried:S);\n    }\n", args).addNamedCode(fetcherType == GraphQlFetcherType.INHERIT_ID_FROM_PARENT || fetcherType == GraphQlFetcherType.INHERIT_ID_FROM_ARGS ? "      $requestBuildingLogic:L\n" : "    return $fetcherFacetName:L.map(\n          _failure -> $skip:L(\"'$fetcherFacetName:L' failed with error.\", _failure.error()),\n          () -> $skip:L(\"'$fetcherFacetName:L' returned null\"),\n          _nonNil -> {\n            $requestBuildingLogic:L\n          });\n", (Map)ImmutableMap.builder().put((Object)"requestBuildingLogic", (Object)CodeBlock.builder().addNamed("\n            var graphql_executionStrategyParams_new = graphql_executionStrategy.newParametersForFieldExecution(\n                    graphql_executionContext,\n                    graphql_executionStrategyParams,\n                    graphql_executionStrategyParams.getFields().getSubField($fieldName:S));\n            $forLoopStart:L\n            var _req = $reqPojoType:T._builder()\n                .$facet_entityId:L(_entityId)\n                .graphql_executionContext(graphql_executionContext)\n                .graphql_executionStrategy(graphql_executionStrategy)\n                .graphql_executionStrategyParams(graphql_executionStrategyParams_new);\n            $forLoopEnd:L\n            $execute:L\n", args).build()).putAll(args).build());
        if (!entityIdFacetName.isBlank()) {
            if (fetcherType == GraphQlFetcherType.INHERIT_ID_FROM_PARENT) {
                fieldComposingEntityType.ifPresent(typeName -> methodBuilder.addParameter((TypeName)this.schemaReaderUtil.entityIdClassName((GraphQLTypeName)typeName), entityIdFacetName, new Modifier[0]));
            } else if (fetcher instanceof VajramFetcher) {
                VajramFetcher vajramFetcher = (VajramFetcher)fetcher;
                methodBuilder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Errable.class), (TypeName[])new TypeName[]{this.getFetcherResponseType(vajramFetcher, List.of(fieldSpec))}), entityIdFacetName, new Modifier[0]);
            }
        }
        return methodBuilder.build();
    }
}

