/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.graphql.codegen;

import com.flipkart.krystal.codegen.common.models.AbstractKrystalAnnoProcessor;
import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.models.RunOnlyWhenCodegenPhaseIs;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQLEntityGen;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQLObjectAggregateGen;
import com.flipkart.krystal.vajram.graphql.codegen.GraphQlCodeGenUtil;
import com.google.auto.service.AutoService;
import com.google.common.base.Throwables;
import java.io.File;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@SupportedOptions(value={"krystal.codegen.phase", "krystal.codegen.moduleRootPath"})
@RunOnlyWhenCodegenPhaseIs(value=CodegenPhase.MODELS)
@AutoService(value={Processor.class})
public class GraphQLAnnotationProcessor
extends AbstractKrystalAnnoProcessor {
    boolean generated;

    protected boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.generated) {
            return false;
        }
        CodeGenUtility util = this.codeGenUtil();
        File schemaFile = GraphQlCodeGenUtil.getSchemaFilePath(util).toFile();
        if (!schemaFile.exists()) {
            util.note((CharSequence)"Schema.graphqls not found. Skipping GraphQl Code Generation");
            return false;
        }
        util.note((CharSequence)("Annotations: " + String.valueOf(annotations)));
        for (TypeElement typeElement : annotations) {
            util.note((CharSequence)("Annotation Processor: " + String.valueOf(((Object)((Object)this)).getClass()) + "; Annotation:" + String.valueOf(typeElement) + "; Classes: " + String.valueOf(roundEnv.getElementsAnnotatedWith(typeElement))));
        }
        try {
            new GraphQLObjectAggregateGen(this.codeGenUtil(), schemaFile).generate();
        }
        catch (Exception e) {
            util.error("[GraphQL Codegen Exception] " + Throwables.getStackTraceAsString((Throwable)e), new Element[0]);
        }
        try {
            new GraphQLEntityGen(util, schemaFile).generate();
        }
        catch (Exception e) {
            util.error("[GraphQL Codegen Exception] " + Throwables.getStackTraceAsString((Throwable)e), new Element[0]);
        }
        this.generated = true;
        return false;
    }
}

